/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.Dump;
import de.independit.scheduler.server.dump.DumpFolder;
import de.independit.scheduler.server.dump.DumpSchedulingEntity;
import de.independit.scheduler.server.dump.DumpScope;
import de.independit.scheduler.server.exception.SDMSException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

final class Cleanup {
    public static final String __version = "@(#) $Id: Cleanup.java,v 2.7.14.1 2013/03/14 10:24:11 ronald Exp $";
    private final SystemEnvironment sysEnv;
    private final boolean force;
    private final HashSet renderIds;
    private final Vector sortedDumps;
    private final HashMap keepList;
    private final Vector cleanups = new Vector();
    private final Vector keeps = new Vector();
    private int nomapStart;

    Cleanup(SystemEnvironment systemEnvironment, boolean bl, HashSet hashSet, Vector vector, HashMap hashMap) {
        this.sysEnv = systemEnvironment;
        this.force = bl;
        this.renderIds = hashSet;
        this.sortedDumps = vector;
        this.keepList = hashMap;
    }

    final void cleanup() throws SDMSException {
        for (int i = this.sortedDumps.size() - 1; i >= 0; --i) {
            String string;
            Vector vector;
            if (i != 17 && i != 12 || (vector = (Vector)this.sortedDumps.get(i)) == null || vector.isEmpty()) continue;
            this.cleanups.clear();
            this.keeps.clear();
            switch (i) {
                case 17: {
                    string = "SCOPE";
                    this.collect(vector);
                    break;
                }
                case 12: {
                    string = "FOLDER";
                    this.collect(vector, (Vector)this.sortedDumps.get(13));
                    break;
                }
                default: {
                    string = null;
                }
            }
            if (this.cleanups.isEmpty()) continue;
            Collections.sort(this.cleanups, Compare.ObjectNames);
            Collections.sort(this.keeps, Compare.ObjectNames);
            this.nomapStart = this.keeps.size();
            this.collectKeepListEntries(string);
            if (Dump.maps[i].isEmpty()) {
                this.nomapStart = this.keeps.size();
                Collections.sort(this.keeps, Compare.ObjectNames);
            }
            this.render(string, i == 12 && this.force);
        }
    }

    private final void collect(Vector vector) throws SDMSException {
        int n = vector.size();
        block4: for (int i = 0; i < n; ++i) {
            DumpScope dumpScope = (DumpScope)vector.get(i);
            if (!this.renderIds.isEmpty() && !this.renderIds.contains(dumpScope.sdmsId)) continue;
            switch (dumpScope.s.getType(this.sysEnv)) {
                case 1: {
                    this.cleanups.add(dumpScope.getName());
                    continue block4;
                }
                case 2: {
                    this.keeps.add("scope " + dumpScope.getName());
                }
            }
        }
    }

    private final void collect(Vector vector, Vector vector2) {
        int n;
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            DumpFolder dumpFolder = (DumpFolder)vector.get(n);
            if (!this.renderIds.isEmpty() && !this.renderIds.contains(dumpFolder.sdmsId)) continue;
            this.cleanups.add(dumpFolder.getName());
        }
        n = vector2.size();
        for (int i = 0; i < n; ++i) {
            this.keeps.add("folder " + ((DumpSchedulingEntity)vector2.get(i)).getName());
        }
    }

    private final void collectKeepListEntries(String string) {
        if (this.keepList == null || this.keepList.isEmpty()) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        for (Vector vector2 : this.keepList.keySet()) {
            String string2 = (String)this.keepList.get(vector2);
            if (!string2.equals(string)) continue;
            if (vector2.lastElement() != null) {
                vector.add(Dump.quotedPath(vector2));
                continue;
            }
            Vector vector3 = new Vector(vector2);
            vector3.remove(vector3.size() - 1);
            vector.add(Dump.quotedPath(vector3) + ".all");
        }
        Collections.sort(vector, Compare.ObjectNames);
        this.keeps.addAll(vector);
    }

    private final void render(String string, boolean bl) {
        Dump.println();
        Dump.println("cleanup " + string.toLowerCase());
        Dump.println("\t" + Dump.join(",\n\t", this.cleanups));
        Dump.println("\twith");
        if (bl) {
            Dump.println("\t\tforce,");
        }
        Dump.print("\t\tkeep = ");
        int n = this.keeps.size();
        if (n == 0) {
            Dump.print("none");
        } else {
            Dump.print("(");
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    Dump.print(",");
                }
                Dump.print("\n\t\t\t");
                if (i == this.nomapStart) {
                    Dump.print('\u0000');
                }
                Dump.print(this.keeps.get(i).toString());
            }
            Dump.print(")");
        }
        Dump.println(";");
    }
}

