/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.Dump;
import de.independit.scheduler.server.dump.DumpInterval;
import de.independit.scheduler.server.dump.DumpSchedulingEntity;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchy;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchyTable;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import java.util.Collections;
import java.util.Vector;

class DumpIntervalStructure
extends Dump {
    public static final String __version = "@(#) $Id: DumpIntervalStructure.java,v 2.5.14.1 2013/03/14 10:24:13 ronald Exp $";
    final DumpInterval dumpIval;
    private String jobDefinition;
    private Long embeddedIntervalId;
    private Vector ihList;
    private SDMSInterval ival;
    private Long ivalId;
    private Vector withList;

    static final Vector getDumpedList(SystemEnvironment systemEnvironment, Long l, DumpInterval dumpInterval) throws SDMSException {
        Vector<String> vector = new Vector<String>(2);
        boolean bl = false;
        SDMSInterval sDMSInterval = SDMSIntervalTable.getObject(systemEnvironment, l);
        Long l2 = sDMSInterval.getEmbeddedIntervalId(systemEnvironment);
        if (l2 == null) {
            vector.add("embedded = none");
        } else {
            vector.add("embedded = none /* dummy */");
            bl = true;
        }
        if (SDMSIntervalHierarchyTable.idx_parentId.getVector(systemEnvironment, l).isEmpty()) {
            vector.add("filter = none");
        } else {
            vector.add("filter = none /* dummy */");
            bl = true;
        }
        if (bl) {
            new DumpIntervalStructure(systemEnvironment, sDMSInterval, dumpInterval);
        }
        return vector;
    }

    DumpIntervalStructure(SystemEnvironment systemEnvironment, SDMSInterval sDMSInterval, DumpInterval dumpInterval) throws SDMSException {
        super(systemEnvironment, 21, sDMSInterval);
        this.dumpIval = dumpInterval;
    }

    @Override
    final String initialize(SystemEnvironment systemEnvironment) throws SDMSException {
        this.ival = (SDMSInterval)this.sdmsObj;
        this.ivalId = this.sdmsId;
        this.embeddedIntervalId = this.ival.getEmbeddedIntervalId(systemEnvironment);
        this.ihList = SDMSIntervalHierarchyTable.idx_parentId.getVector(systemEnvironment, this.ivalId);
        return DumpIntervalStructure.quotedName(this.ivalId, this.ival.getName(systemEnvironment));
    }

    private final void loadJobDefinition(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.ival.getSeId(systemEnvironment);
        if (l != null) {
            this.jobDefinition = DumpSchedulingEntity.getDumpedName(systemEnvironment, l);
        }
    }

    private final void loadEmbedded(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.embeddedIntervalId != null) {
            this.withList.add("embedded = " + DumpInterval.getDumpedName(systemEnvironment, this.embeddedIntervalId));
        }
    }

    private final void loadFilter(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.ihList.isEmpty()) {
            return;
        }
        int n = this.ihList.size();
        Vector<String> vector = new Vector<String>(n);
        for (int i = 0; i < n; ++i) {
            SDMSIntervalHierarchy sDMSIntervalHierarchy = (SDMSIntervalHierarchy)this.ihList.get(i);
            Long l = sDMSIntervalHierarchy.getChildId(systemEnvironment);
            vector.add(DumpInterval.getDumpedName(systemEnvironment, l));
        }
        Collections.sort(vector, Compare.Lexically);
        this.withList.add("filter = (\n\t\t\t" + DumpIntervalStructure.join(",\n\t\t\t", vector) + ")");
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        this.loadJobDefinition(systemEnvironment);
        this.withList = new Vector();
        this.loadEmbedded(systemEnvironment);
        this.loadFilter(systemEnvironment);
    }

    @Override
    final void render(String string) {
        DumpIntervalStructure.println("alter interval " + this.getName());
        if (this.jobDefinition != null) {
            DumpIntervalStructure.println("\t\t(" + this.jobDefinition + ')');
        }
        DumpIntervalStructure.println("\twith");
        DumpIntervalStructure.println("\t\t" + DumpIntervalStructure.join(",\n\t\t", this.withList) + ';');
    }
}

