/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.Dump;
import de.independit.scheduler.server.dump.DumpNamedResource;
import de.independit.scheduler.server.dump.DumpSchedulingEntity;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import java.util.Collections;
import java.util.Vector;

class DumpSchedulingEntityParameter
extends Dump {
    public static final String __version = "@(#) $Id: DumpSchedulingEntityParameter.java,v 2.7.14.1 2013/03/14 10:24:15 ronald Exp $";
    private Vector pdList;
    private Long seId;
    private Vector parmDefs;

    static final boolean getDumpedList(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, l).isEmpty()) {
            return false;
        }
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
        new DumpSchedulingEntityParameter(systemEnvironment, sDMSSchedulingEntity);
        return true;
    }

    DumpSchedulingEntityParameter(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        super(systemEnvironment, 16, sDMSSchedulingEntity);
    }

    @Override
    final String initialize(SystemEnvironment systemEnvironment) throws SDMSException {
        this.seId = this.sdmsId;
        this.pdList = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, this.seId);
        return DumpSchedulingEntity.getDumpedName(systemEnvironment, this.seId);
    }

    private final String getDefaultValue(SystemEnvironment systemEnvironment, SDMSParameterDefinition sDMSParameterDefinition) throws SDMSException {
        String string = sDMSParameterDefinition.getDefaultValue(systemEnvironment);
        if (string == null) {
            return "";
        }
        return DumpSchedulingEntityParameter.quotedString(string.substring(1));
    }

    private final String getDefault(SystemEnvironment systemEnvironment, SDMSParameterDefinition sDMSParameterDefinition) throws SDMSException {
        String string = this.getDefaultValue(systemEnvironment, sDMSParameterDefinition);
        return string.equals("") ? "" : "\n\t\t\t\tdefault = " + string;
    }

    private final String getReference(SystemEnvironment systemEnvironment, SDMSParameterDefinition sDMSParameterDefinition) throws SDMSException {
        Long l = sDMSParameterDefinition.getLinkPdId(systemEnvironment);
        SDMSParameterDefinition sDMSParameterDefinition2 = SDMSParameterDefinitionTable.getObject(systemEnvironment, l);
        String string = DumpSchedulingEntityParameter.quotedName(l, sDMSParameterDefinition2.getName(systemEnvironment));
        Long l2 = sDMSParameterDefinition2.getSeId(systemEnvironment);
        String string2 = DumpSchedulingEntity.getDumpedName(systemEnvironment, l2);
        return string2 + " (" + string + ")" + this.getDefault(systemEnvironment, sDMSParameterDefinition);
    }

    private final String getResourceReference(SystemEnvironment systemEnvironment, SDMSParameterDefinition sDMSParameterDefinition) throws SDMSException {
        Long l = sDMSParameterDefinition.getLinkPdId(systemEnvironment);
        SDMSParameterDefinition sDMSParameterDefinition2 = SDMSParameterDefinitionTable.getObject(systemEnvironment, l);
        String string = DumpSchedulingEntityParameter.quotedName(l, sDMSParameterDefinition2.getName(systemEnvironment));
        Long l2 = sDMSParameterDefinition2.getSeId(systemEnvironment);
        String string2 = DumpNamedResource.getDumpedName(systemEnvironment, l2);
        return string2 + " (" + string + ")" + this.getDefault(systemEnvironment, sDMSParameterDefinition);
    }

    private final String getExpressionAttr(SystemEnvironment systemEnvironment, SDMSParameterDefinition sDMSParameterDefinition) throws SDMSException {
        String string = sDMSParameterDefinition.getAggFunctionAsString(systemEnvironment);
        return string.toLowerCase() + " (" + this.getDefaultValue(systemEnvironment, sDMSParameterDefinition) + ")";
    }

    private final String getIsLocal(SystemEnvironment systemEnvironment, SDMSParameterDefinition sDMSParameterDefinition) throws SDMSException {
        Boolean bl = sDMSParameterDefinition.getIsLocal(systemEnvironment);
        return bl != false ? " local" : "";
    }

    private final String getAttr(SystemEnvironment systemEnvironment, SDMSParameterDefinition sDMSParameterDefinition) throws SDMSException {
        Integer n = sDMSParameterDefinition.getType(systemEnvironment);
        String string = sDMSParameterDefinition.getTypeAsString(systemEnvironment).toLowerCase();
        switch (n) {
            case 10: {
                return string + " " + this.getReference(systemEnvironment, sDMSParameterDefinition) + this.getIsLocal(systemEnvironment, sDMSParameterDefinition);
            }
            case 20: {
                return "reference child " + this.getReference(systemEnvironment, sDMSParameterDefinition) + this.getIsLocal(systemEnvironment, sDMSParameterDefinition);
            }
            case 91: {
                return "reference resource " + this.getResourceReference(systemEnvironment, sDMSParameterDefinition) + this.getIsLocal(systemEnvironment, sDMSParameterDefinition);
            }
            case 30: {
                return string + " = " + this.getDefaultValue(systemEnvironment, sDMSParameterDefinition) + this.getIsLocal(systemEnvironment, sDMSParameterDefinition);
            }
            case 40: {
                return string + this.getDefault(systemEnvironment, sDMSParameterDefinition) + this.getIsLocal(systemEnvironment, sDMSParameterDefinition);
            }
            case 50: {
                return string + this.getDefault(systemEnvironment, sDMSParameterDefinition) + this.getIsLocal(systemEnvironment, sDMSParameterDefinition);
            }
            case 60: {
                return this.getExpressionAttr(systemEnvironment, sDMSParameterDefinition) + this.getIsLocal(systemEnvironment, sDMSParameterDefinition);
            }
            case 70: {
                return string + this.getDefault(systemEnvironment, sDMSParameterDefinition) + this.getIsLocal(systemEnvironment, sDMSParameterDefinition);
            }
            case 80: {
                return string;
            }
        }
        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04209091638", "unknown/unexpected parameter type: $1", (Object)n));
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        int n = this.pdList.size();
        this.parmDefs = new Vector(n);
        for (int i = 0; i < n; ++i) {
            SDMSParameterDefinition sDMSParameterDefinition = (SDMSParameterDefinition)this.pdList.get(i);
            String string = DumpSchedulingEntityParameter.quotedName(sDMSParameterDefinition.getId(systemEnvironment), sDMSParameterDefinition.getName(systemEnvironment));
            if (sDMSParameterDefinition.getType(systemEnvironment) == 81) continue;
            String string2 = this.getAttr(systemEnvironment, sDMSParameterDefinition);
            this.parmDefs.add(string + "\n\t\t\t\t" + string2);
        }
        Collections.sort(this.parmDefs, Compare.Lexically);
    }

    @Override
    final void render(String string) {
        DumpSchedulingEntityParameter.println("alter job_definition " + this.getName());
        DumpSchedulingEntityParameter.println("\twith");
        DumpSchedulingEntityParameter.println("\t\tparameters = (");
        DumpSchedulingEntityParameter.println("\t\t\t" + DumpSchedulingEntityParameter.join(",\n\t\t\t", this.parmDefs) + ");");
    }
}

