/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.EspState;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateDefinition;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import java.util.Vector;

public class AlterExitStatProf
extends Node {
    public static final String __version = "@(#) $Id: AlterExitStatProf.java,v 2.8.2.1 2013/03/14 10:24:20 ronald Exp $";
    private ObjectURL url;
    private WithHash items;
    private boolean noerr;

    public AlterExitStatProf(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.url = objectURL;
        this.items = withHash;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSExitStateProfile sDMSExitStateProfile;
        try {
            sDMSExitStateProfile = (SDMSExitStateProfile)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311130018", "No Exit State Profile altered"));
                return;
            }
            throw notFoundException;
        }
        Long l = sDMSExitStateProfile.getId(systemEnvironment);
        if (this.items.containsKey("STATUS")) {
            this.removeExitStates(systemEnvironment, l, SDMSExitStateTable.idx_espId.getVector(systemEnvironment, l));
            this.insertExitStates(systemEnvironment, l, (Vector)this.items.get("STATUS"));
            this.checkForFinalState(systemEnvironment, l);
        }
        Long l2 = null;
        if (this.items.containsKey("DEFAULT_MAPPING")) {
            String string = (String)this.items.get("DEFAULT_MAPPING");
            if (string != null) {
                l2 = SDMSExitStateMappingProfileTable.idx_name_getUnique(systemEnvironment, string).getId(systemEnvironment);
            }
            sDMSExitStateProfile.setDefaultEsmpId(systemEnvironment, l2);
        } else {
            l2 = sDMSExitStateProfile.getDefaultEsmpId(systemEnvironment);
        }
        if (this.items.containsKey("FORCE") && ((Boolean)this.items.get("FORCE")).booleanValue()) {
            sDMSExitStateProfile.setIsValid(systemEnvironment, Boolean.FALSE);
        } else {
            sDMSExitStateProfile.checkProfile(systemEnvironment);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03204112156", "Exit State Profile altered"));
    }

    private void removeExitStates(SystemEnvironment systemEnvironment, Long l, Vector vector) throws SDMSException {
        for (SDMSExitState sDMSExitState : vector) {
            sDMSExitState.delete(systemEnvironment);
        }
    }

    private void insertExitStates(SystemEnvironment systemEnvironment, Long l, Vector vector) throws SDMSException {
        int n = 1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (EspState espState : vector) {
            Boolean bl4 = espState.type.equals(new Integer(3)) ? Boolean.TRUE : Boolean.FALSE;
            Boolean bl5 = espState.type.equals(new Integer(1)) ? Boolean.TRUE : Boolean.FALSE;
            Boolean bl6 = espState.unreachable;
            Boolean bl7 = espState.broken;
            Boolean bl8 = espState.batchDefault;
            Boolean bl9 = espState.depDefault;
            if (bl6.booleanValue()) {
                if (bl) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02205311457", "Only one state can be marked as unreachable state"));
                }
                bl = true;
                if (!bl4.booleanValue()) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02204301736", "The unreachable state must be defined FINAL"));
                }
            }
            if (bl7.booleanValue()) {
                if (bl2) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03504300807", "Only one state can be marked as broken state"));
                }
                bl2 = true;
            }
            if (bl8.booleanValue()) {
                if (bl3) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202141012", "Only one state can be marked as default exit stae for batches and milestones"));
                }
                bl3 = true;
                if (!bl4.booleanValue()) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202141013", "The default exit state for batches and milestones must be defined FINAL"));
                }
            }
            if (bl9.booleanValue() && !bl4.booleanValue()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202141014", "A default exit state for dependencies must be defined FINAL"));
            }
            SDMSExitStateDefinition sDMSExitStateDefinition = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, espState.name);
            Long l2 = sDMSExitStateDefinition.getId(systemEnvironment);
            Integer n2 = new Integer(n);
            ++n;
            try {
                SDMSExitStateTable.table.create(systemEnvironment, n2, bl4, bl5, bl6, bl7, bl8, bl9, l, l2);
            }
            catch (DuplicateKeyException duplicateKeyException) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03110120950", "Exit state definition $1 specified more than once", (Object)espState.name));
            }
        }
    }

    private void checkForFinalState(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector vector = SDMSExitStateTable.idx_espId.getVector(systemEnvironment, l);
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            SDMSExitState sDMSExitState = (SDMSExitState)vector.get(i);
            if (!sDMSExitState.getIsFinal(systemEnvironment).booleanValue()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202241103", "An exit state profile requires at least one final state"));
        }
    }
}

