/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSPool;
import de.independit.scheduler.server.repository.SDMSPoolTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSResourceTemplate;
import de.independit.scheduler.server.repository.SDMSResourceTemplateTable;
import java.util.Vector;

public class DropNamedResource
extends Node {
    public static final String __version = "@(#) $Id: DropNamedResource.java,v 2.7.14.3 2013/08/09 09:46:42 ronald Exp $";
    private ObjectURL url;
    private boolean cascade;
    private boolean noerr;

    public DropNamedResource(ObjectURL objectURL, Boolean bl, Boolean bl2) {
        this.url = objectURL;
        this.cascade = bl;
        this.noerr = bl2;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSNamedResource sDMSNamedResource;
        try {
            sDMSNamedResource = (SDMSNamedResource)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311122305", "No Named Resource dropped"));
                return;
            }
            throw notFoundException;
        }
        this.dropNamedResource(systemEnvironment, sDMSNamedResource);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03204112233", "Named Resource dropped"));
    }

    private void dropNamedResource(SystemEnvironment systemEnvironment, SDMSNamedResource sDMSNamedResource) throws SDMSException {
        Long l = sDMSNamedResource.getId(systemEnvironment);
        if (this.cascade) {
            SDMSProxy sDMSProxy;
            int n;
            Vector vector = SDMSNamedResourceTable.idx_parentId.getVector(systemEnvironment, l);
            for (n = 0; n < vector.size(); ++n) {
                this.dropNamedResource(systemEnvironment, (SDMSNamedResource)vector.get(n));
            }
            vector = SDMSResourceTable.idx_nrId.getVector(systemEnvironment, l);
            for (n = 0; n < vector.size(); ++n) {
                sDMSProxy = (SDMSResource)vector.get(n);
                ((SDMSResource)sDMSProxy).delete(systemEnvironment);
            }
            vector = SDMSResourceTemplateTable.idx_nrId.getVector(systemEnvironment, l);
            for (n = 0; n < vector.size(); ++n) {
                sDMSProxy = (SDMSResourceTemplate)vector.get(n);
                ((SDMSResourceTemplate)sDMSProxy).delete(systemEnvironment);
            }
            vector = SDMSPoolTable.idx_nrId.getVector(systemEnvironment, l);
            for (n = 0; n < vector.size(); ++n) {
                sDMSProxy = (SDMSPool)vector.get(n);
                ((SDMSPool)sDMSProxy).delete(systemEnvironment);
            }
        }
        sDMSNamedResource.killParameters(systemEnvironment);
        sDMSNamedResource.delete(systemEnvironment);
    }
}

