/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;

public class DropSchedule
extends Node {
    public static final String __version = "@(#) $Id: DropSchedule.java,v 2.3.4.1 2013/03/14 10:24:31 ronald Exp $";
    private final ObjectURL obj;
    private final boolean noerr;

    public DropSchedule(ObjectURL objectURL, Boolean bl) {
        this.obj = objectURL;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSSchedule sDMSSchedule = (SDMSSchedule)this.obj.resolve(systemEnvironment);
        Long l = this.obj.objId;
        if (SDMSScheduledEventTable.idx_sceId.containsKey(systemEnvironment, l)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04207251740", "Schedule in use by Scheduled Event(s)"));
        }
        if (SDMSScheduleTable.idx_parentId.containsKey(systemEnvironment, l)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04207251742", "Schedule contains sub-schedule(s)"));
        }
        sDMSSchedule.delete(systemEnvironment);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04207251741", "Schedule dropped"));
    }
}

