/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Formatter;
import de.independit.scheduler.server.parser.NamedResourceLister;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileTable;
import java.util.HashSet;
import java.util.Vector;

public class ListNamedResource
extends Node
implements Formatter {
    public static final String __version = "@(#) $Id: ListNamedResource.java,v 2.11.2.2 2013/06/18 09:49:33 ronald Exp $";
    Vector path;
    WithHash with;
    HashSet expandIds;

    public ListNamedResource() {
        this.path = null;
        this.expandIds = new HashSet();
        this.txMode = 1;
        this.auditFlag = false;
    }

    public ListNamedResource(Vector vector, WithHash withHash) {
        this.path = vector;
        this.with = withHash;
        this.expandIds = this.with.containsKey("EXPAND") ? (HashSet)this.with.get("EXPAND") : new HashSet();
        this.txMode = 1;
        this.auditFlag = false;
    }

    @Override
    public Vector fillHeadInfo() {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("NAME");
        vector.add("OWNER");
        vector.add("USAGE");
        vector.add("RESOURCE_STATE_PROFILE");
        vector.add("FACTOR");
        vector.add("SUBCATEGORIES");
        vector.add("RESOURCES");
        vector.add("PRIVS");
        return vector;
    }

    @Override
    public Vector fillVector(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, HashSet hashSet) throws SDMSException {
        Vector vector = new Vector();
        this.fillVector(systemEnvironment, (SDMSNamedResource)sDMSProxy, vector);
        return vector;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSNamedResource sDMSNamedResource = this.path == null ? SDMSNamedResourceTable.idx_parentId_name_getUnique(systemEnvironment, new SDMSKey(null, (Comparable)((Object)"RESOURCE"))) : SDMSNamedResourceTable.getNamedResource(systemEnvironment, this.path);
        Long l = sDMSNamedResource.getId(systemEnvironment);
        if (this.expandIds != null && !this.expandIds.contains(l)) {
            this.expandIds.add(l);
        }
        SDMSOutputContainer sDMSOutputContainer = null;
        NamedResourceLister namedResourceLister = new NamedResourceLister(this.path, this.expandIds);
        namedResourceLister.setTitle(new SDMSMessage(systemEnvironment, "03207191657", "List of Named Resources"));
        namedResourceLister.setFormatter(this);
        if (this.with != null && this.with.containsKey("FILTER")) {
            namedResourceLister.objFilter.initialize_filter(systemEnvironment, (Vector)this.with.get("FILTER"), 0, true);
            namedResourceLister.useFilter = true;
        }
        sDMSOutputContainer = namedResourceLister.list(systemEnvironment);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "02111101415", "$1 Named Resource(s) found", (Object)new Integer(sDMSOutputContainer.lines)));
    }

    private void fillVector(SystemEnvironment systemEnvironment, SDMSNamedResource sDMSNamedResource, Vector vector) throws SDMSException {
        Object object;
        vector.add(sDMSNamedResource.getId(systemEnvironment));
        vector.add(sDMSNamedResource.pathVector(systemEnvironment));
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSNamedResource.getOwnerId(systemEnvironment));
        vector.add(sDMSGroup.getName(systemEnvironment));
        vector.add(sDMSNamedResource.getUsageAsString(systemEnvironment));
        Long l = sDMSNamedResource.getRspId(systemEnvironment);
        if (l != null) {
            object = SDMSResourceStateProfileTable.getObject(systemEnvironment, l);
            vector.add(((SDMSResourceStateProfileProxyGeneric)object).getName(systemEnvironment));
        } else {
            vector.add(null);
        }
        vector.add(sDMSNamedResource.getFactor(systemEnvironment));
        int n = 0;
        int n2 = 0;
        object = SDMSNamedResourceTable.idx_parentId.getVector(systemEnvironment, sDMSNamedResource.getId(systemEnvironment));
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            SDMSNamedResource sDMSNamedResource2 = (SDMSNamedResource)((Vector)object).get(i);
            if (sDMSNamedResource2.getUsage(systemEnvironment) == 8) {
                ++n;
                continue;
            }
            ++n2;
        }
        vector.add(new Integer(n));
        vector.add(new Integer(n2));
        vector.add(sDMSNamedResource.getPrivileges(systemEnvironment).toString());
    }
}

