/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import java.util.Vector;

public class MoveFolder
extends Node {
    private ObjectURL url;
    private Vector name2;
    private String newName;

    public MoveFolder(ObjectURL objectURL, Vector vector) {
        this.url = objectURL;
        this.name2 = vector;
        this.newName = null;
    }

    public MoveFolder(ObjectURL objectURL, String string) {
        this.url = objectURL;
        this.name2 = null;
        this.newName = string;
    }

    private void moveFolder(SystemEnvironment systemEnvironment, SDMSFolder sDMSFolder) throws SDMSException {
        Long l;
        String string;
        SDMSFolder sDMSFolder2;
        try {
            sDMSFolder2 = SDMSFolderTable.getFolder(systemEnvironment, this.name2);
            string = sDMSFolder.getName(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            string = (String)this.name2.remove(this.name2.size() - 1);
            sDMSFolder2 = SDMSFolderTable.getFolder(systemEnvironment, this.name2);
        }
        Long l2 = sDMSFolder2.getId(systemEnvironment);
        Long l3 = sDMSFolder.getParentId(systemEnvironment);
        if (l3 == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03704102217", "The Folder SYSTEM cannot be moved"));
        }
        Long l4 = sDMSFolder.getId(systemEnvironment);
        if (SDMSSchedulingEntityTable.idx_folderId_name.containsKey(systemEnvironment, new SDMSKey(l2, (Comparable)((Object)string)))) {
            throw new DuplicateKeyException(new SDMSMessage(systemEnvironment, "03201290943", "Object with name $1 already exists within $2", (Object)string, (Object)sDMSFolder.pathString(systemEnvironment)));
        }
        if (l2.equals(l4)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03201291020", "A Folder cannot be moved below itself"));
        }
        while ((l = sDMSFolder2.getParentId(systemEnvironment)) != null) {
            if (l.equals(l4)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03201291021", "A Folder cannot be moved below itself"));
            }
            sDMSFolder2 = SDMSFolderTable.getObject(systemEnvironment, l);
        }
        sDMSFolder.set_ParentIdName(systemEnvironment, l2, string);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201290948", "Folder moved"));
    }

    private void renameFolder(SystemEnvironment systemEnvironment, SDMSFolder sDMSFolder) throws SDMSException {
        Long l = sDMSFolder.getParentId(systemEnvironment);
        if (l == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03112161102", "The Folder SYSTEM cannot be renamed"));
        }
        if (SDMSSchedulingEntityTable.idx_folderId_name.containsKey(systemEnvironment, new SDMSKey(l, (Comparable)((Object)this.newName)))) {
            throw new DuplicateKeyException(new SDMSMessage(systemEnvironment, "03112161101", "Object with name $1 already exists", (Object)this.newName));
        }
        if (SDMSFolderTable.idx_parentId_name.containsKey(systemEnvironment, new SDMSKey(l, (Comparable)((Object)this.newName)))) {
            throw new DuplicateKeyException(new SDMSMessage(systemEnvironment, "03112161103", "Object with name $1 already exists", (Object)this.newName));
        }
        sDMSFolder.setName(systemEnvironment, this.newName);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03112161104", "Folder renamed"));
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSProxy sDMSProxy = this.url.resolve(systemEnvironment);
        if (!(sDMSProxy instanceof SDMSFolder)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03111090754", "The object $1 is not a folder", (Object)this.url.toString()));
        }
        SDMSFolder sDMSFolder = (SDMSFolder)this.url.resolve(systemEnvironment);
        if (this.newName == null) {
            this.moveFolder(systemEnvironment, sDMSFolder);
        } else {
            this.renameFolder(systemEnvironment, sDMSFolder);
        }
    }
}

