/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSPool;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.util.PathVector;

public class MovePool
extends Node {
    public static final String __version = "@(#) $Id: MovePool.java,v 2.3.14.3 2013/03/20 06:42:59 ronald Exp $";
    private final ObjectURL url;
    private final PathVector scope_bis;
    private boolean replace;

    public MovePool(ObjectURL objectURL, PathVector pathVector) {
        this.url = objectURL;
        this.scope_bis = pathVector;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        systemEnvironment.checkFeatureAvailability("POOL");
        SDMSPool sDMSPool = (SDMSPool)this.url.resolve(systemEnvironment);
        SDMSScope sDMSScope = SDMSScopeTable.getScope(systemEnvironment, this.scope_bis);
        if (!sDMSScope.checkPrivileges(systemEnvironment, 8L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03603241402", "Insufficient privileges for creating pools in $1", (Object)sDMSScope.getURL(systemEnvironment)));
        }
        sDMSPool.setScopeId(systemEnvironment, sDMSScope.getId(systemEnvironment));
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03603182240", "Pool moved"));
    }
}

