/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventParameter;
import de.independit.scheduler.server.repository.SDMSEventParameterTable;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;

public class ShowEvent
extends ShowCommented {
    public static final String __version = "@(#) $Id: ShowEvent.java,v 2.5.8.2 2013/06/18 09:49:35 ronald Exp $";
    private final String name;
    private SDMSEvent evt;
    private Long evtId;

    public ShowEvent(String string) {
        this.name = string;
        this.txMode = 1;
        this.auditFlag = false;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Comparable comparable;
        this.evt = SDMSEventTable.idx_name_getUnique(systemEnvironment, this.name);
        if (!this.evt.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "034020411707", "Insufficient privileges"));
        }
        this.evtId = this.evt.getId(systemEnvironment);
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("NAME");
        vector.add("OWNER");
        vector.add("SCHEDULING_ENTITY");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PARAMETERS");
        vector.add("PRIVS");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(this.evtId);
        vector2.add(this.evt.getName(systemEnvironment));
        Long l = this.evt.getOwnerId(systemEnvironment);
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l);
        vector2.add(sDMSGroup.getName(systemEnvironment));
        Long l2 = this.evt.getSeId(systemEnvironment);
        if (l2 == null) {
            vector2.add(null);
        } else {
            comparable = SDMSSchedulingEntityTable.getObject(systemEnvironment, l2);
            vector2.add(((SDMSSchedulingEntity)comparable).pathString(systemEnvironment));
        }
        comparable = new Date();
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, this.evt.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        ((Date)comparable).setTime(this.evt.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format((Date)comparable));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, this.evt.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        ((Date)comparable).setTime(this.evt.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format((Date)comparable));
        vector2.add(this.parm_list(systemEnvironment));
        vector2.add(this.evt.getPrivileges(systemEnvironment).toString());
        vector2.add(this.getCommentContainer(systemEnvironment, this.evtId));
        vector2.add(this.getCommentInfoType(systemEnvironment, this.evtId));
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "Event", vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04203161558", "Event shown"));
    }

    private SDMSOutputContainer parm_list(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("KEY");
        vector.add("VALUE");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "List of Event Parameters", vector);
        Vector vector2 = SDMSEventParameterTable.idx_evtId.getVector(systemEnvironment, this.evtId);
        for (SDMSEventParameter sDMSEventParameter : vector2) {
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(sDMSEventParameter.getId(systemEnvironment));
            vector3.add(sDMSEventParameter.getKey(systemEnvironment));
            String string = sDMSEventParameter.getValue(systemEnvironment).substring(1);
            vector3.add(string);
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        return sDMSOutputContainer;
    }
}

