/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateTableGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSExitStateGeneric
extends SDMSObject
implements Cloneable {
    public static final int RESTARTABLE = 1;
    public static final int PENDING = 2;
    public static final int FINAL = 3;
    public static final int UNREACHABLE = 4;
    public static final int nr_id = 1;
    public static final int nr_preference = 2;
    public static final int nr_isFinal = 3;
    public static final int nr_isRestartable = 4;
    public static final int nr_isUnreachable = 5;
    public static final int nr_isBroken = 6;
    public static final int nr_isBatchDefault = 7;
    public static final int nr_isDependencyDefault = 8;
    public static final int nr_espId = 9;
    public static final int nr_esdId = 10;
    public static final int nr_creatorUId = 11;
    public static final int nr_createTs = 12;
    public static final int nr_changerUId = 13;
    public static final int nr_changeTs = 14;
    public static String tableName = "EXIT_STATE";
    protected Integer preference;
    protected Boolean isFinal;
    protected Boolean isRestartable;
    protected Boolean isUnreachable;
    protected Boolean isBroken;
    protected Boolean isBatchDefault;
    protected Boolean isDependencyDefault;
    protected Long espId;
    protected Long esdId;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSExitStateGeneric(SystemEnvironment systemEnvironment, Integer n, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, Boolean bl6, Long l, Long l2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
        super(systemEnvironment, SDMSExitStateTableGeneric.table);
        this.preference = n;
        this.isFinal = bl;
        this.isRestartable = bl2;
        this.isUnreachable = bl3;
        this.isBroken = bl4;
        this.isBatchDefault = bl5;
        this.isDependencyDefault = bl6;
        this.espId = l;
        this.esdId = l2;
        this.creatorUId = l3;
        this.createTs = l4;
        this.changerUId = l5;
        this.changeTs = l6;
    }

    public Integer getPreference(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.preference;
    }

    public void setPreference(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.preference.equals(n)) {
            return;
        }
        SDMSExitStateGeneric sDMSExitStateGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ExitState) Change of system object not allowed"));
        }
        if (sDMSExitStateGeneric.versions.o_v == null || sDMSExitStateGeneric.versions.o_v.size() == 0 || sDMSExitStateGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExitStateGeneric = (SDMSExitStateGeneric)this.change(systemEnvironment);
        }
        sDMSExitStateGeneric.preference = n;
        sDMSExitStateGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSExitStateGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExitStateGeneric != this) {
            sDMSExitStateGeneric.versions.table.index(systemEnvironment, sDMSExitStateGeneric, 0L);
        }
    }

    public Boolean getIsFinal(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isFinal;
    }

    public void setIsFinal(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isFinal.equals(bl)) {
            return;
        }
        SDMSExitStateGeneric sDMSExitStateGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ExitState) Change of system object not allowed"));
        }
        if (sDMSExitStateGeneric.versions.o_v == null || sDMSExitStateGeneric.versions.o_v.size() == 0 || sDMSExitStateGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExitStateGeneric = (SDMSExitStateGeneric)this.change(systemEnvironment);
        }
        sDMSExitStateGeneric.isFinal = bl;
        sDMSExitStateGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSExitStateGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExitStateGeneric != this) {
            sDMSExitStateGeneric.versions.table.index(systemEnvironment, sDMSExitStateGeneric, 0L);
        }
    }

    public Boolean getIsRestartable(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isRestartable;
    }

    public void setIsRestartable(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isRestartable.equals(bl)) {
            return;
        }
        SDMSExitStateGeneric sDMSExitStateGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ExitState) Change of system object not allowed"));
        }
        if (sDMSExitStateGeneric.versions.o_v == null || sDMSExitStateGeneric.versions.o_v.size() == 0 || sDMSExitStateGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExitStateGeneric = (SDMSExitStateGeneric)this.change(systemEnvironment);
        }
        sDMSExitStateGeneric.isRestartable = bl;
        sDMSExitStateGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSExitStateGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExitStateGeneric != this) {
            sDMSExitStateGeneric.versions.table.index(systemEnvironment, sDMSExitStateGeneric, 0L);
        }
    }

    public Boolean getIsUnreachable(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isUnreachable;
    }

    public void setIsUnreachable(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isUnreachable.equals(bl)) {
            return;
        }
        SDMSExitStateGeneric sDMSExitStateGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ExitState) Change of system object not allowed"));
        }
        if (sDMSExitStateGeneric.versions.o_v == null || sDMSExitStateGeneric.versions.o_v.size() == 0 || sDMSExitStateGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExitStateGeneric = (SDMSExitStateGeneric)this.change(systemEnvironment);
        }
        sDMSExitStateGeneric.isUnreachable = bl;
        sDMSExitStateGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSExitStateGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExitStateGeneric != this) {
            sDMSExitStateGeneric.versions.table.index(systemEnvironment, sDMSExitStateGeneric, 0L);
        }
    }

    public Boolean getIsBroken(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isBroken;
    }

    public void setIsBroken(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isBroken.equals(bl)) {
            return;
        }
        SDMSExitStateGeneric sDMSExitStateGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ExitState) Change of system object not allowed"));
        }
        if (sDMSExitStateGeneric.versions.o_v == null || sDMSExitStateGeneric.versions.o_v.size() == 0 || sDMSExitStateGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExitStateGeneric = (SDMSExitStateGeneric)this.change(systemEnvironment);
        }
        sDMSExitStateGeneric.isBroken = bl;
        sDMSExitStateGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSExitStateGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExitStateGeneric != this) {
            sDMSExitStateGeneric.versions.table.index(systemEnvironment, sDMSExitStateGeneric, 0L);
        }
    }

    public Boolean getIsBatchDefault(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isBatchDefault;
    }

    public void setIsBatchDefault(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isBatchDefault.equals(bl)) {
            return;
        }
        SDMSExitStateGeneric sDMSExitStateGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ExitState) Change of system object not allowed"));
        }
        if (sDMSExitStateGeneric.versions.o_v == null || sDMSExitStateGeneric.versions.o_v.size() == 0 || sDMSExitStateGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExitStateGeneric = (SDMSExitStateGeneric)this.change(systemEnvironment);
        }
        sDMSExitStateGeneric.isBatchDefault = bl;
        sDMSExitStateGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSExitStateGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExitStateGeneric != this) {
            sDMSExitStateGeneric.versions.table.index(systemEnvironment, sDMSExitStateGeneric, 0L);
        }
    }

    public Boolean getIsDependencyDefault(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isDependencyDefault;
    }

    public void setIsDependencyDefault(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isDependencyDefault.equals(bl)) {
            return;
        }
        SDMSExitStateGeneric sDMSExitStateGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ExitState) Change of system object not allowed"));
        }
        if (sDMSExitStateGeneric.versions.o_v == null || sDMSExitStateGeneric.versions.o_v.size() == 0 || sDMSExitStateGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExitStateGeneric = (SDMSExitStateGeneric)this.change(systemEnvironment);
        }
        sDMSExitStateGeneric.isDependencyDefault = bl;
        sDMSExitStateGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSExitStateGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExitStateGeneric != this) {
            sDMSExitStateGeneric.versions.table.index(systemEnvironment, sDMSExitStateGeneric, 0L);
        }
    }

    public Long getEspId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.espId;
    }

    public void setEspId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.espId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ExitState) Change of system object not allowed"));
            }
            SDMSExitStateGeneric sDMSExitStateGeneric = (SDMSExitStateGeneric)this.change(systemEnvironment);
            sDMSExitStateGeneric.espId = l;
            sDMSExitStateGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSExitStateGeneric.changeTs = systemEnvironment.txTime();
            sDMSExitStateGeneric.versions.table.index(systemEnvironment, sDMSExitStateGeneric, 5L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getEsdId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.esdId;
    }

    public void setEsdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.esdId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ExitState) Change of system object not allowed"));
            }
            SDMSExitStateGeneric sDMSExitStateGeneric = (SDMSExitStateGeneric)this.change(systemEnvironment);
            sDMSExitStateGeneric.esdId = l;
            sDMSExitStateGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSExitStateGeneric.changeTs = systemEnvironment.txTime();
            sDMSExitStateGeneric.versions.table.index(systemEnvironment, sDMSExitStateGeneric, 6L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSExitStateGeneric sDMSExitStateGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ExitState) Change of system object not allowed"));
        }
        if (sDMSExitStateGeneric.versions.o_v == null || sDMSExitStateGeneric.versions.o_v.size() == 0 || sDMSExitStateGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExitStateGeneric = (SDMSExitStateGeneric)this.change(systemEnvironment);
        }
        sDMSExitStateGeneric.creatorUId = l;
        sDMSExitStateGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSExitStateGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExitStateGeneric != this) {
            sDMSExitStateGeneric.versions.table.index(systemEnvironment, sDMSExitStateGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSExitStateGeneric sDMSExitStateGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ExitState) Change of system object not allowed"));
        }
        if (sDMSExitStateGeneric.versions.o_v == null || sDMSExitStateGeneric.versions.o_v.size() == 0 || sDMSExitStateGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExitStateGeneric = (SDMSExitStateGeneric)this.change(systemEnvironment);
        }
        sDMSExitStateGeneric.createTs = l;
        sDMSExitStateGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSExitStateGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExitStateGeneric != this) {
            sDMSExitStateGeneric.versions.table.index(systemEnvironment, sDMSExitStateGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSExitStateGeneric sDMSExitStateGeneric = this;
        if (sDMSExitStateGeneric.versions.o_v == null || sDMSExitStateGeneric.versions.o_v.size() == 0 || sDMSExitStateGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExitStateGeneric = (SDMSExitStateGeneric)this.change(systemEnvironment);
        }
        sDMSExitStateGeneric.changerUId = l;
        sDMSExitStateGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExitStateGeneric != this) {
            sDMSExitStateGeneric.versions.table.index(systemEnvironment, sDMSExitStateGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSExitStateGeneric sDMSExitStateGeneric = this;
        if (sDMSExitStateGeneric.versions.o_v == null || sDMSExitStateGeneric.versions.o_v.size() == 0 || sDMSExitStateGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExitStateGeneric = (SDMSExitStateGeneric)this.change(systemEnvironment);
        }
        sDMSExitStateGeneric.changeTs = l;
        sDMSExitStateGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSExitStateGeneric != this) {
            sDMSExitStateGeneric.versions.table.index(systemEnvironment, sDMSExitStateGeneric, 0L);
        }
    }

    public SDMSExitStateGeneric set_EspIdEsdId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSExitStateGeneric sDMSExitStateGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(ExitState) Change of system object not allowed"));
            }
            sDMSExitStateGeneric = (SDMSExitStateGeneric)this.change(systemEnvironment);
            sDMSExitStateGeneric.espId = l;
            sDMSExitStateGeneric.esdId = l2;
            sDMSExitStateGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSExitStateGeneric.changeTs = systemEnvironment.txTime();
            sDMSExitStateGeneric.versions.table.index(systemEnvironment, sDMSExitStateGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSExitStateGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSExitState(this);
    }

    protected SDMSExitStateGeneric(Long l, Integer n, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, Boolean bl6, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7, long l8, long l9) {
        this.id = l;
        this.preference = n;
        this.isFinal = bl;
        this.isRestartable = bl2;
        this.isUnreachable = bl3;
        this.isBroken = bl4;
        this.isBatchDefault = bl5;
        this.isDependencyDefault = bl6;
        this.espId = l2;
        this.esdId = l3;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
        this.validFrom = l8;
        this.validTo = l9;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "EXIT_STATE" + string3 + " (ID, " + string2 + "PREFERENCE" + string3 + ", " + string2 + "IS_FINAL" + string3 + ", " + string2 + "IS_RESTARTABLE" + string3 + ", " + string2 + "IS_UNREACHABLE" + string3 + ", " + string2 + "IS_BROKEN" + string3 + ", " + string2 + "IS_BATCH_DEFAULT" + string3 + ", " + string2 + "IS_DEPENDENCY_DEFAULT" + string3 + ", " + string2 + "ESP_ID" + string3 + ", " + string2 + "ESD_ID" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ", VALID_FROM, VALID_TO) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSExitStateGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "ExitState: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setInt(2, this.preference);
            preparedStatement.setInt(3, this.isFinal != false ? 1 : 0);
            preparedStatement.setInt(4, this.isRestartable != false ? 1 : 0);
            preparedStatement.setInt(5, this.isUnreachable != false ? 1 : 0);
            preparedStatement.setInt(6, this.isBroken != false ? 1 : 0);
            preparedStatement.setInt(7, this.isBatchDefault != false ? 1 : 0);
            preparedStatement.setInt(8, this.isDependencyDefault != false ? 1 : 0);
            preparedStatement.setLong(9, this.espId);
            preparedStatement.setLong(10, this.esdId);
            preparedStatement.setLong(11, this.creatorUId);
            preparedStatement.setLong(12, this.createTs);
            preparedStatement.setLong(13, this.changerUId);
            preparedStatement.setLong(14, this.changeTs);
            preparedStatement.setLong(15, systemEnvironment.tx.versionId);
            preparedStatement.setLong(16, Long.MAX_VALUE);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "ExitState: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.closeDBObject(systemEnvironment);
        this.insertDBObject(systemEnvironment);
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        this.closeDBObject(systemEnvironment);
    }

    private void closeDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = systemEnvironment.dbConnection.getMetaData().getDriverName();
                boolean bl = string2.startsWith("PostgreSQL");
                String string3 = SystemEnvironment.SQUOTE;
                String string4 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string3 + "EXIT_STATE" + string4 + " SET VALID_TO = ?,     CHANGE_TS = ?,     CHANGER_U_ID = ? WHERE ID = ?  AND VALID_TO = " + (bl ? "CAST ('9223372036854775807' AS DECIMAL)" : "9223372036854775807");
                SDMSExitStateGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181955", "ExitState : $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, systemEnvironment.tx.versionId);
            preparedStatement.setLong(2, this.changeTs);
            preparedStatement.setLong(3, this.changerUId);
            preparedStatement.setLong(4, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181956", "ExitState: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : ExitState", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "preference : " + this.preference, 2);
        SDMSThread.doTrace(null, "isFinal : " + this.isFinal, 2);
        SDMSThread.doTrace(null, "isRestartable : " + this.isRestartable, 2);
        SDMSThread.doTrace(null, "isUnreachable : " + this.isUnreachable, 2);
        SDMSThread.doTrace(null, "isBroken : " + this.isBroken, 2);
        SDMSThread.doTrace(null, "isBatchDefault : " + this.isBatchDefault, 2);
        SDMSThread.doTrace(null, "isDependencyDefault : " + this.isDependencyDefault, 2);
        SDMSThread.doTrace(null, "espId : " + this.espId, 2);
        SDMSThread.doTrace(null, "esdId : " + this.esdId, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "preference          : " + this.preference + "\n" + string + "isFinal             : " + this.isFinal + "\n" + string + "isRestartable       : " + this.isRestartable + "\n" + string + "isUnreachable       : " + this.isUnreachable + "\n" + string + "isBroken            : " + this.isBroken + "\n" + string + "isBatchDefault      : " + this.isBatchDefault + "\n" + string + "isDependencyDefault : " + this.isDependencyDefault + "\n" + string + "espId               : " + this.espId + "\n" + string + "esdId               : " + this.esdId + "\n" + string + "creatorUId          : " + this.creatorUId + "\n" + string + "createTs            : " + this.createTs + "\n" + string + "changerUId          : " + this.changerUId + "\n" + string + "changeTs            : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

