/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateProfileGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSExitStateProfileTableGeneric
extends SDMSTable {
    public static final String tableName = "EXIT_STATE_PROFILE";
    public static SDMSExitStateProfileTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NAME", "DEFAULT_ESMP_ID", "IS_VALID", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_name;
    public static SDMSIndex idx_defaultEsmpId;

    public SDMSExitStateProfileTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "ExitStateProfile"));
        }
        table = (SDMSExitStateProfileTable)this;
        table = (SDMSExitStateProfileTable)this;
        this.isVersioned = true;
        idx_name = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "name");
        idx_defaultEsmpId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "defaultEsmpId");
    }

    public SDMSExitStateProfile create(SystemEnvironment systemEnvironment, String string, Long l, Boolean bl) throws SDMSException {
        SDMSExitStateProfile sDMSExitStateProfile;
        Long l2 = systemEnvironment.cEnv.uid();
        Long l3 = systemEnvironment.txTime();
        Long l4 = systemEnvironment.cEnv.uid();
        Long l5 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "ExitStateProfile"));
        }
        this.validate(systemEnvironment, string, l, bl, l2, l3, l4, l5);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSExitStateProfileGeneric sDMSExitStateProfileGeneric = new SDMSExitStateProfileGeneric(systemEnvironment, string, l, bl, l2, l3, l4, l5);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSExitStateProfileGeneric.versions, true);
            table.put(systemEnvironment, sDMSExitStateProfileGeneric.id, sDMSExitStateProfileGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSExitStateProfile = (SDMSExitStateProfile)sDMSExitStateProfileGeneric.toProxy(systemEnvironment);
            sDMSExitStateProfile.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSExitStateProfile sDMSExitStateProfile2 = (SDMSExitStateProfile)sDMSExitStateProfileGeneric.toProxy(systemEnvironment);
            sDMSExitStateProfile2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSExitStateProfile)) {
            throw new AccessViolationException(sDMSExitStateProfile.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSExitStateProfile;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSExitStateProfile sDMSExitStateProfile) throws SDMSException {
        return sDMSExitStateProfile.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, Long l, Boolean bl, Long l2, Long l3, Long l4, Long l5) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Boolean bl;
        Long l7;
        String string;
        Long l8;
        try {
            l8 = new Long(resultSet.getLong(1));
            string = resultSet.getString(2);
            l7 = new Long(resultSet.getLong(3));
            if (resultSet.wasNull()) {
                l7 = null;
            }
            bl = new Boolean(resultSet.getInt(4) != 0);
            l6 = new Long(resultSet.getLong(5));
            l5 = new Long(resultSet.getLong(6));
            l4 = new Long(resultSet.getLong(7));
            l3 = new Long(resultSet.getLong(8));
            l2 = resultSet.getLong(9);
            l = resultSet.getLong(10);
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "ExitStateProfile: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSExitStateProfileGeneric(l8, string, l7, bl, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "NAME" + string2 + ", " + string + "DEFAULT_ESMP_ID" + string2 + ", " + string + "IS_VALID" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", VALID_FROM, VALID_TO  FROM " + string + this.tableName() + string2 + " WHERE VALID_TO >= " + (bl ? "CAST ('" + systemEnvironment.lowestActiveVersion + "' AS DECIMAL)" : "" + systemEnvironment.lowestActiveVersion) + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_name.check(((SDMSExitStateProfileGeneric)sDMSObject).name, sDMSObject);
        string = string + "idx_name: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_defaultEsmpId.check(((SDMSExitStateProfileGeneric)sDMSObject).defaultEsmpId, sDMSObject);
        string = string + "idx_defaultEsmpId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_name.put(systemEnvironment, ((SDMSExitStateProfileGeneric)sDMSObject).name, sDMSObject, (1L & l) != 0L);
        idx_defaultEsmpId.put(systemEnvironment, ((SDMSExitStateProfileGeneric)sDMSObject).defaultEsmpId, sDMSObject, (2L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_name.remove(systemEnvironment, ((SDMSExitStateProfileGeneric)sDMSObject).name, sDMSObject);
        idx_defaultEsmpId.remove(systemEnvironment, ((SDMSExitStateProfileGeneric)sDMSObject).defaultEsmpId, sDMSObject);
    }

    public static SDMSExitStateProfile getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSExitStateProfile)table.get(systemEnvironment, l);
    }

    public static SDMSExitStateProfile getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSExitStateProfile)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSExitStateProfile getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSExitStateProfile)table.get(systemEnvironment, l, l2);
    }

    public static SDMSExitStateProfile idx_name_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSExitStateProfile)idx_name.getUnique(systemEnvironment, object);
    }

    public static SDMSExitStateProfile idx_name_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSExitStateProfile)idx_name.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSExitStateProfile idx_name_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSExitStateProfile)idx_name.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

