/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupGeneric;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSGroupTableGeneric
extends SDMSTable {
    public static final String tableName = "GROUPS";
    public static SDMSGroupTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NAME", "DELETE_VERSION", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_name;
    public static SDMSIndex idx_name_deleteVersion;

    public SDMSGroupTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "Group"));
        }
        table = (SDMSGroupTable)this;
        table = (SDMSGroupTable)this;
        this.isVersioned = false;
        idx_name = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "name");
        idx_name_deleteVersion = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "name_deleteVersion");
    }

    public SDMSGroup create(SystemEnvironment systemEnvironment, String string, Long l) throws SDMSException {
        SDMSGroup sDMSGroup;
        Long l2 = systemEnvironment.cEnv.uid();
        Long l3 = systemEnvironment.txTime();
        Long l4 = systemEnvironment.cEnv.uid();
        Long l5 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "Group"));
        }
        this.validate(systemEnvironment, string, l, l2, l3, l4, l5);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSGroupGeneric sDMSGroupGeneric = new SDMSGroupGeneric(systemEnvironment, string, l, l2, l3, l4, l5);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSGroupGeneric.versions, true);
            table.put(systemEnvironment, sDMSGroupGeneric.id, sDMSGroupGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSGroup = (SDMSGroup)sDMSGroupGeneric.toProxy(systemEnvironment);
            sDMSGroup.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSGroup sDMSGroup2 = (SDMSGroup)sDMSGroupGeneric.toProxy(systemEnvironment);
            sDMSGroup2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSGroup)) {
            throw new AccessViolationException(sDMSGroup.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSGroup;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSGroup sDMSGroup) throws SDMSException {
        return sDMSGroup.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, Long l4, Long l5) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        String string;
        Long l8;
        try {
            l8 = new Long(resultSet.getLong(1));
            string = resultSet.getString(2);
            l7 = new Long(resultSet.getLong(3));
            l6 = new Long(resultSet.getLong(4));
            l5 = new Long(resultSet.getLong(5));
            l4 = new Long(resultSet.getLong(6));
            l3 = new Long(resultSet.getLong(7));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "Group: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSGroupGeneric(l8, string, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "NAME" + string2 + ", " + string + "DELETE_VERSION" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_name.check(((SDMSGroupGeneric)sDMSObject).name, sDMSObject);
        string = string + "idx_name: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add((Comparable)((Object)((SDMSGroupGeneric)sDMSObject).name));
        sDMSKey.add(((SDMSGroupGeneric)sDMSObject).deleteVersion);
        bl = idx_name_deleteVersion.check(sDMSKey, sDMSObject);
        string = string + "idx_name_deleteVersion: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_name.put(systemEnvironment, ((SDMSGroupGeneric)sDMSObject).name, sDMSObject, (1L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add((Comparable)((Object)((SDMSGroupGeneric)sDMSObject).name));
        sDMSKey.add(((SDMSGroupGeneric)sDMSObject).deleteVersion);
        idx_name_deleteVersion.put(systemEnvironment, sDMSKey, sDMSObject, (2L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_name.remove(systemEnvironment, ((SDMSGroupGeneric)sDMSObject).name, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add((Comparable)((Object)((SDMSGroupGeneric)sDMSObject).name));
        sDMSKey.add(((SDMSGroupGeneric)sDMSObject).deleteVersion);
        idx_name_deleteVersion.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSGroup getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSGroup)table.get(systemEnvironment, l);
    }

    public static SDMSGroup getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSGroup)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSGroup getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSGroup)table.get(systemEnvironment, l, l2);
    }

    public static SDMSGroup idx_name_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSGroup)idx_name.getUnique(systemEnvironment, object);
    }

    public static SDMSGroup idx_name_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSGroup)idx_name.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSGroup idx_name_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSGroup)idx_name.getUnique(systemEnvironment, object, l);
    }

    public static SDMSGroup idx_name_deleteVersion_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSGroup)idx_name_deleteVersion.getUnique(systemEnvironment, object);
    }

    public static SDMSGroup idx_name_deleteVersion_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSGroup)idx_name_deleteVersion.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSGroup idx_name_deleteVersion_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSGroup)idx_name_deleteVersion.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

