/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSHierarchyInstance;
import de.independit.scheduler.server.repository.SDMSHierarchyInstanceGeneric;
import de.independit.scheduler.server.repository.SDMSHierarchyInstanceTable;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSHierarchyInstanceTableGeneric
extends SDMSTable {
    public static final String tableName = "HIERARCHY_INSTANCE";
    public static SDMSHierarchyInstanceTable table = null;
    public static final String[] columnNames = new String[]{"ID", "PARENT_ID", "CHILD_ID", "SH_ID", "NICE", "CHILD_ESD_ID", "CHILD_ES_PREFERENCE", "SE_VERSION", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_parentId;
    public static SDMSIndex idx_childId;
    public static SDMSIndex idx_parentId_childId;

    public SDMSHierarchyInstanceTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "HierarchyInstance"));
        }
        table = (SDMSHierarchyInstanceTable)this;
        table = (SDMSHierarchyInstanceTable)this;
        this.isVersioned = false;
        idx_parentId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "parentId");
        idx_childId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "childId");
        idx_parentId_childId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "parentId_childId");
    }

    public SDMSHierarchyInstance create(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Integer n, Long l4, Integer n2, Long l5) throws SDMSException {
        SDMSHierarchyInstance sDMSHierarchyInstance;
        Long l6 = systemEnvironment.cEnv.uid();
        Long l7 = systemEnvironment.txTime();
        Long l8 = systemEnvironment.cEnv.uid();
        Long l9 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "HierarchyInstance"));
        }
        this.validate(systemEnvironment, l, l2, l3, n, l4, n2, l5, l6, l7, l8, l9);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSHierarchyInstanceGeneric sDMSHierarchyInstanceGeneric = new SDMSHierarchyInstanceGeneric(systemEnvironment, l, l2, l3, n, l4, n2, l5, l6, l7, l8, l9);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSHierarchyInstanceGeneric.versions, true);
            table.put(systemEnvironment, sDMSHierarchyInstanceGeneric.id, sDMSHierarchyInstanceGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSHierarchyInstance = (SDMSHierarchyInstance)sDMSHierarchyInstanceGeneric.toProxy(systemEnvironment);
            sDMSHierarchyInstance.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSHierarchyInstance sDMSHierarchyInstance2 = (SDMSHierarchyInstance)sDMSHierarchyInstanceGeneric.toProxy(systemEnvironment);
            sDMSHierarchyInstance2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSHierarchyInstance)) {
            throw new AccessViolationException(sDMSHierarchyInstance.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSHierarchyInstance.touchMaster(systemEnvironment);
        return sDMSHierarchyInstance;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSHierarchyInstance sDMSHierarchyInstance) throws SDMSException {
        return sDMSHierarchyInstance.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Integer n, Long l4, Integer n2, Long l5, Long l6, Long l7, Long l8, Long l9) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Integer n;
        Long l8;
        Integer n2;
        Long l9;
        Long l10;
        Long l11;
        Long l12;
        try {
            l12 = new Long(resultSet.getLong(1));
            l11 = new Long(resultSet.getLong(2));
            l10 = new Long(resultSet.getLong(3));
            l9 = new Long(resultSet.getLong(4));
            n2 = new Integer(resultSet.getInt(5));
            l8 = new Long(resultSet.getLong(6));
            if (resultSet.wasNull()) {
                l8 = null;
            }
            n = new Integer(resultSet.getInt(7));
            if (resultSet.wasNull()) {
                n = null;
            }
            l7 = new Long(resultSet.getLong(8));
            l6 = new Long(resultSet.getLong(9));
            l5 = new Long(resultSet.getLong(10));
            l4 = new Long(resultSet.getLong(11));
            l3 = new Long(resultSet.getLong(12));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "HierarchyInstance: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSHierarchyInstanceGeneric(l12, l11, l10, l9, n2, l8, n, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "PARENT_ID" + string2 + ", " + string + "CHILD_ID" + string2 + ", " + string + "SH_ID" + string2 + ", " + string + "NICE" + string2 + ", " + string + "CHILD_ESD_ID" + string2 + ", " + string + "CHILD_ES_PREFERENCE" + string2 + ", " + string + "SE_VERSION" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + "  FROM " + string + this.tableName() + string2 + ",        SME2LOAD  WHERE " + string + this.tableName() + string2 + ".PARENT_ID = SME2LOAD.ID");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_parentId.check(((SDMSHierarchyInstanceGeneric)sDMSObject).parentId, sDMSObject);
        string = string + "idx_parentId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_childId.check(((SDMSHierarchyInstanceGeneric)sDMSObject).childId, sDMSObject);
        string = string + "idx_childId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSHierarchyInstanceGeneric)sDMSObject).parentId);
        sDMSKey.add(((SDMSHierarchyInstanceGeneric)sDMSObject).childId);
        bl = idx_parentId_childId.check(sDMSKey, sDMSObject);
        string = string + "idx_parentId_childId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_parentId.put(systemEnvironment, ((SDMSHierarchyInstanceGeneric)sDMSObject).parentId, sDMSObject, (1L & l) != 0L);
        idx_childId.put(systemEnvironment, ((SDMSHierarchyInstanceGeneric)sDMSObject).childId, sDMSObject, (2L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSHierarchyInstanceGeneric)sDMSObject).parentId);
        sDMSKey.add(((SDMSHierarchyInstanceGeneric)sDMSObject).childId);
        idx_parentId_childId.put(systemEnvironment, sDMSKey, sDMSObject, (4L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_parentId.remove(systemEnvironment, ((SDMSHierarchyInstanceGeneric)sDMSObject).parentId, sDMSObject);
        idx_childId.remove(systemEnvironment, ((SDMSHierarchyInstanceGeneric)sDMSObject).childId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSHierarchyInstanceGeneric)sDMSObject).parentId);
        sDMSKey.add(((SDMSHierarchyInstanceGeneric)sDMSObject).childId);
        idx_parentId_childId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSHierarchyInstance getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSHierarchyInstance)table.get(systemEnvironment, l);
    }

    public static SDMSHierarchyInstance getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSHierarchyInstance)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSHierarchyInstance getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSHierarchyInstance)table.get(systemEnvironment, l, l2);
    }

    public static SDMSHierarchyInstance idx_parentId_childId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSHierarchyInstance)idx_parentId_childId.getUnique(systemEnvironment, object);
    }

    public static SDMSHierarchyInstance idx_parentId_childId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSHierarchyInstance)idx_parentId_childId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSHierarchyInstance idx_parentId_childId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSHierarchyInstance)idx_parentId_childId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

