/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectComment;
import de.independit.scheduler.server.repository.SDMSObjectCommentTableGeneric;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSObjectCommentGeneric
extends SDMSObject
implements Cloneable {
    public static final int SYSTEM = 0;
    public static final int SELECT = 99;
    public static final int DISTRIBUTION = 25;
    public static final int ENVIRONMENT = 1;
    public static final int EXIT_STATE_DEFINITION = 2;
    public static final int EXIT_STATE_PROFILE = 3;
    public static final int EXIT_STATE_MAPPING = 4;
    public static final int EXIT_STATE_TRANSLATION = 5;
    public static final int FOLDER = 6;
    public static final int FOOTPRINT = 7;
    public static final int USER = 8;
    public static final int JOB_DEFINITION = 9;
    public static final int NAMED_RESOURCE = 10;
    public static final int NICE_PROFILE = 31;
    public static final int PARAMETER = 23;
    public static final int POOL = 24;
    public static final int RESOURCE = 11;
    public static final int RESOURCE_STATE_MAPPING = 12;
    public static final int RESOURCE_STATE_DEFINITION = 13;
    public static final int RESOURCE_STATE_PROFILE = 14;
    public static final int SCOPE = 15;
    public static final int TRIGGER = 16;
    public static final int JOB = 17;
    public static final int EVENT = 18;
    public static final int INTERVAL = 19;
    public static final int SCHEDULE = 20;
    public static final int GROUP = 21;
    public static final int SCHEDULED_EVENT = 22;
    public static final int COMMENT = 26;
    public static final int GRANT = 27;
    public static final int RESOURCE_TEMPLATE = 28;
    public static final int WATCH_TYPE = 29;
    public static final int OBJECT_MONITOR = 30;
    public static final int TEXT = 0;
    public static final int URL = 1;
    public static final int nr_id = 1;
    public static final int nr_objectId = 2;
    public static final int nr_objectType = 3;
    public static final int nr_infoType = 4;
    public static final int nr_sequenceNumber = 5;
    public static final int nr_tag = 6;
    public static final int nr_description = 7;
    public static final int nr_creatorUId = 8;
    public static final int nr_createTs = 9;
    public static final int nr_changerUId = 10;
    public static final int nr_changeTs = 11;
    public static String tableName = "OBJECT_COMMENT";
    protected Long objectId;
    protected Integer objectType;
    protected Integer infoType;
    protected Integer sequenceNumber;
    protected String tag;
    protected String description;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSObjectCommentGeneric(SystemEnvironment systemEnvironment, Long l, Integer n, Integer n2, Integer n3, String string, String string2, Long l2, Long l3, Long l4, Long l5) throws SDMSException {
        super(systemEnvironment, SDMSObjectCommentTableGeneric.table);
        this.objectId = l;
        this.objectType = n;
        this.infoType = n2;
        this.sequenceNumber = n3;
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(ObjectComment) Length of $1 exceeds maximum length $2", (Object)"tag", (Object)"64"));
        }
        this.tag = string;
        if (string2 != null && string2.length() > 1900) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(ObjectComment) Length of $1 exceeds maximum length $2", (Object)"description", (Object)"1900"));
        }
        this.description = string2;
        this.creatorUId = l2;
        this.createTs = l3;
        this.changerUId = l4;
        this.changeTs = l5;
    }

    public Long getObjectId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.objectId;
    }

    public void setObjectId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.objectId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectComment) Change of system object not allowed"));
            }
            SDMSObjectCommentGeneric sDMSObjectCommentGeneric = (SDMSObjectCommentGeneric)this.change(systemEnvironment);
            sDMSObjectCommentGeneric.objectId = l;
            sDMSObjectCommentGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSObjectCommentGeneric.changeTs = systemEnvironment.txTime();
            sDMSObjectCommentGeneric.versions.table.index(systemEnvironment, sDMSObjectCommentGeneric, 1L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getObjectType(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.objectType;
    }

    public String getObjectTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getObjectType(systemEnvironment);
        switch (n) {
            case 9: {
                return "JOB_DEFINITION";
            }
            case 2: {
                return "EXIT_STATE_DEFINITION";
            }
            case 3: {
                return "EXIT_STATE_PROFILE";
            }
            case 4: {
                return "EXIT_STATE_MAPPING";
            }
            case 5: {
                return "EXIT_STATE_TRANSLATION";
            }
            case 6: {
                return "FOLDER";
            }
            case 15: {
                return "SCOPE";
            }
            case 10: {
                return "NAMED_RESOURCE";
            }
            case 31: {
                return "NICE_PROFILE";
            }
            case 11: {
                return "RESOURCE";
            }
            case 1: {
                return "ENVIRONMENT";
            }
            case 7: {
                return "FOOTPRINT";
            }
            case 13: {
                return "RESOURCE_STATE_DEFINITION";
            }
            case 14: {
                return "RESOURCE_STATE_PROFILE";
            }
            case 12: {
                return "RESOURCE_STATE_MAPPING";
            }
            case 8: {
                return "USER";
            }
            case 16: {
                return "TRIGGER";
            }
            case 17: {
                return "JOB";
            }
            case 18: {
                return "EVENT";
            }
            case 19: {
                return "INTERVAL";
            }
            case 20: {
                return "SCHEDULE";
            }
            case 22: {
                return "SCHEDULED_EVENT";
            }
            case 21: {
                return "GROUP";
            }
            case 23: {
                return "PARAMETER";
            }
            case 24: {
                return "POOL";
            }
            case 25: {
                return "DISTRIBUTION";
            }
            case 29: {
                return "WATCH_TYPE";
            }
            case 30: {
                return "OBJECT_MONITOR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown ObjectComment.objectType: $1", (Object)this.getObjectType(systemEnvironment)));
    }

    public void setObjectType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.objectType.equals(n)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectComment) Change of system object not allowed"));
            }
            SDMSObjectCommentGeneric sDMSObjectCommentGeneric = (SDMSObjectCommentGeneric)this.change(systemEnvironment);
            sDMSObjectCommentGeneric.objectType = n;
            sDMSObjectCommentGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSObjectCommentGeneric.changeTs = systemEnvironment.txTime();
            sDMSObjectCommentGeneric.versions.table.index(systemEnvironment, sDMSObjectCommentGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getInfoType(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.infoType;
    }

    public String getInfoTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getInfoType(systemEnvironment);
        switch (n) {
            case 0: {
                return "TEXT";
            }
            case 1: {
                return "URL";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown ObjectComment.infoType: $1", (Object)this.getInfoType(systemEnvironment)));
    }

    public void setInfoType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.infoType.equals(n)) {
            return;
        }
        SDMSObjectCommentGeneric sDMSObjectCommentGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectComment) Change of system object not allowed"));
        }
        if (sDMSObjectCommentGeneric.versions.o_v == null || sDMSObjectCommentGeneric.versions.o_v.size() == 0 || sDMSObjectCommentGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectCommentGeneric = (SDMSObjectCommentGeneric)this.change(systemEnvironment);
        }
        sDMSObjectCommentGeneric.infoType = n;
        sDMSObjectCommentGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectCommentGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectCommentGeneric != this) {
            sDMSObjectCommentGeneric.versions.table.index(systemEnvironment, sDMSObjectCommentGeneric, 0L);
        }
    }

    public Integer getSequenceNumber(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.sequenceNumber.equals(n)) {
            return;
        }
        SDMSObjectCommentGeneric sDMSObjectCommentGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectComment) Change of system object not allowed"));
        }
        if (sDMSObjectCommentGeneric.versions.o_v == null || sDMSObjectCommentGeneric.versions.o_v.size() == 0 || sDMSObjectCommentGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectCommentGeneric = (SDMSObjectCommentGeneric)this.change(systemEnvironment);
        }
        sDMSObjectCommentGeneric.sequenceNumber = n;
        sDMSObjectCommentGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectCommentGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectCommentGeneric != this) {
            sDMSObjectCommentGeneric.versions.table.index(systemEnvironment, sDMSObjectCommentGeneric, 0L);
        }
    }

    public String getTag(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.tag;
    }

    public void setTag(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.tag)) {
            return;
        }
        if (string == null && this.tag == null) {
            return;
        }
        SDMSObjectCommentGeneric sDMSObjectCommentGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectComment) Change of system object not allowed"));
        }
        if (sDMSObjectCommentGeneric.versions.o_v == null || sDMSObjectCommentGeneric.versions.o_v.size() == 0 || sDMSObjectCommentGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectCommentGeneric = (SDMSObjectCommentGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(ObjectComment) Length of $1 exceeds maximum length $2", (Object)"tag", (Object)"64"));
        }
        sDMSObjectCommentGeneric.tag = string;
        sDMSObjectCommentGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectCommentGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectCommentGeneric != this) {
            sDMSObjectCommentGeneric.versions.table.index(systemEnvironment, sDMSObjectCommentGeneric, 0L);
        }
    }

    public String getDescription(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.description;
    }

    public void setDescription(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.description.equals(string)) {
            return;
        }
        SDMSObjectCommentGeneric sDMSObjectCommentGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectComment) Change of system object not allowed"));
        }
        if (sDMSObjectCommentGeneric.versions.o_v == null || sDMSObjectCommentGeneric.versions.o_v.size() == 0 || sDMSObjectCommentGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectCommentGeneric = (SDMSObjectCommentGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 1900) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(ObjectComment) Length of $1 exceeds maximum length $2", (Object)"description", (Object)"1900"));
        }
        sDMSObjectCommentGeneric.description = string;
        sDMSObjectCommentGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectCommentGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectCommentGeneric != this) {
            sDMSObjectCommentGeneric.versions.table.index(systemEnvironment, sDMSObjectCommentGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSObjectCommentGeneric sDMSObjectCommentGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectComment) Change of system object not allowed"));
        }
        if (sDMSObjectCommentGeneric.versions.o_v == null || sDMSObjectCommentGeneric.versions.o_v.size() == 0 || sDMSObjectCommentGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectCommentGeneric = (SDMSObjectCommentGeneric)this.change(systemEnvironment);
        }
        sDMSObjectCommentGeneric.creatorUId = l;
        sDMSObjectCommentGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectCommentGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectCommentGeneric != this) {
            sDMSObjectCommentGeneric.versions.table.index(systemEnvironment, sDMSObjectCommentGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSObjectCommentGeneric sDMSObjectCommentGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectComment) Change of system object not allowed"));
        }
        if (sDMSObjectCommentGeneric.versions.o_v == null || sDMSObjectCommentGeneric.versions.o_v.size() == 0 || sDMSObjectCommentGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectCommentGeneric = (SDMSObjectCommentGeneric)this.change(systemEnvironment);
        }
        sDMSObjectCommentGeneric.createTs = l;
        sDMSObjectCommentGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectCommentGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectCommentGeneric != this) {
            sDMSObjectCommentGeneric.versions.table.index(systemEnvironment, sDMSObjectCommentGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSObjectCommentGeneric sDMSObjectCommentGeneric = this;
        if (sDMSObjectCommentGeneric.versions.o_v == null || sDMSObjectCommentGeneric.versions.o_v.size() == 0 || sDMSObjectCommentGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectCommentGeneric = (SDMSObjectCommentGeneric)this.change(systemEnvironment);
        }
        sDMSObjectCommentGeneric.changerUId = l;
        sDMSObjectCommentGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectCommentGeneric != this) {
            sDMSObjectCommentGeneric.versions.table.index(systemEnvironment, sDMSObjectCommentGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSObjectCommentGeneric sDMSObjectCommentGeneric = this;
        if (sDMSObjectCommentGeneric.versions.o_v == null || sDMSObjectCommentGeneric.versions.o_v.size() == 0 || sDMSObjectCommentGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectCommentGeneric = (SDMSObjectCommentGeneric)this.change(systemEnvironment);
        }
        sDMSObjectCommentGeneric.changeTs = l;
        sDMSObjectCommentGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSObjectCommentGeneric != this) {
            sDMSObjectCommentGeneric.versions.table.index(systemEnvironment, sDMSObjectCommentGeneric, 0L);
        }
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSObjectComment(this);
    }

    protected SDMSObjectCommentGeneric(Long l, Long l2, Integer n, Integer n2, Integer n3, String string, String string2, Long l3, Long l4, Long l5, Long l6, long l7, long l8) {
        this.id = l;
        this.objectId = l2;
        this.objectType = n;
        this.infoType = n2;
        this.sequenceNumber = n3;
        this.tag = string;
        this.description = string2;
        this.creatorUId = l3;
        this.createTs = l4;
        this.changerUId = l5;
        this.changeTs = l6;
        this.validFrom = l7;
        this.validTo = l8;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "OBJECT_COMMENT" + string3 + " (ID, " + string2 + "OBJECT_ID" + string3 + ", " + string2 + "OBJECT_TYPE" + string3 + ", " + string2 + "INFO_TYPE" + string3 + ", " + string2 + "SEQUENCE_NUMBER" + string3 + ", " + string2 + "TAG" + string3 + ", " + string2 + "DESCRIPTION" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ", VALID_FROM, VALID_TO) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSObjectCommentGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "ObjectComment: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.objectId);
            preparedStatement.setInt(3, this.objectType);
            preparedStatement.setInt(4, this.infoType);
            preparedStatement.setInt(5, this.sequenceNumber);
            if (this.tag == null) {
                preparedStatement.setNull(6, 12);
            } else {
                preparedStatement.setString(6, this.tag);
            }
            preparedStatement.setString(7, this.description);
            preparedStatement.setLong(8, this.creatorUId);
            preparedStatement.setLong(9, this.createTs);
            preparedStatement.setLong(10, this.changerUId);
            preparedStatement.setLong(11, this.changeTs);
            preparedStatement.setLong(12, systemEnvironment.tx.versionId);
            preparedStatement.setLong(13, Long.MAX_VALUE);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "ObjectComment: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.closeDBObject(systemEnvironment);
        this.insertDBObject(systemEnvironment);
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        this.closeDBObject(systemEnvironment);
    }

    private void closeDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = systemEnvironment.dbConnection.getMetaData().getDriverName();
                boolean bl = string2.startsWith("PostgreSQL");
                String string3 = SystemEnvironment.SQUOTE;
                String string4 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string3 + "OBJECT_COMMENT" + string4 + " SET VALID_TO = ?,     CHANGE_TS = ?,     CHANGER_U_ID = ? WHERE ID = ?  AND VALID_TO = " + (bl ? "CAST ('9223372036854775807' AS DECIMAL)" : "9223372036854775807");
                SDMSObjectCommentGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181955", "ObjectComment : $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, systemEnvironment.tx.versionId);
            preparedStatement.setLong(2, this.changeTs);
            preparedStatement.setLong(3, this.changerUId);
            preparedStatement.setLong(4, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181956", "ObjectComment: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    public static boolean checkObjectType(Integer n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkInfoType(Integer n) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : ObjectComment", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "objectId : " + this.objectId, 2);
        SDMSThread.doTrace(null, "objectType : " + this.objectType, 2);
        SDMSThread.doTrace(null, "infoType : " + this.infoType, 2);
        SDMSThread.doTrace(null, "sequenceNumber : " + this.sequenceNumber, 2);
        SDMSThread.doTrace(null, "tag : " + this.tag, 2);
        SDMSThread.doTrace(null, "description : " + this.description, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "objectId       : " + this.objectId + "\n" + string + "objectType     : " + this.objectType + "\n" + string + "infoType       : " + this.infoType + "\n" + string + "sequenceNumber : " + this.sequenceNumber + "\n" + string + "tag            : " + this.tag + "\n" + string + "description    : " + this.description + "\n" + string + "creatorUId     : " + this.creatorUId + "\n" + string + "createTs       : " + this.createTs + "\n" + string + "changerUId     : " + this.changerUId + "\n" + string + "changeTs       : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

