/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionGeneric;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRepository;
import de.independit.scheduler.server.repository.SDMSTable;
import java.util.HashMap;
import java.util.Vector;

public class SDMSParameterDefinitionProxyGeneric
extends SDMSProxy {
    public static final int REFERENCE = 10;
    public static final int CHILDREFERENCE = 20;
    public static final int CONSTANT = 30;
    public static final int RESULT = 40;
    public static final int PARAMETER = 50;
    public static final int EXPRESSION = 60;
    public static final int IMPORT = 70;
    public static final int DYNAMIC = 80;
    public static final int DYNAMICVALUE = 81;
    public static final int LOCAL_CONSTANT = 90;
    public static final int RESOURCEREFERENCE = 91;
    public static final int NONE = 0;
    public static final int AVG = 61;
    public static final int COUNT = 62;
    public static final int MIN = 63;
    public static final int MAX = 64;
    public static final int SUM = 65;
    public static final long privilegeMask = 0x10000111L;
    public static final int name_size = 64;
    public static final int defaultValue_size = 256;
    public static final int exportName_size = 64;
    private static SDMSTable[] masterTables = null;

    protected SDMSParameterDefinitionProxyGeneric(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    protected static SDMSParameterDefinition getProxy(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) {
        int n = SDMSParameterDefinitionTable.table.tableIndex;
        SDMSProxy sDMSProxy = SDMSRepository.getProxy(n);
        if (sDMSProxy == null) {
            sDMSProxy = new SDMSParameterDefinition(sDMSObject);
        } else {
            sDMSProxy.initProxy(sDMSObject);
        }
        systemEnvironment.tx.addUsedProxy(n, sDMSProxy);
        return (SDMSParameterDefinition)sDMSProxy;
    }

    public Long getSeId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSParameterDefinitionGeneric)this.object).getSeId(systemEnvironment);
    }

    public void setSeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSParameterDefinitionGeneric)this.object).setSeId(systemEnvironment, l);
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSParameterDefinitionGeneric)this.object).getName(systemEnvironment);
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSParameterDefinitionGeneric)this.object).setName(systemEnvironment, string);
    }

    public static int getNameMaxLength() {
        return 64;
    }

    public Integer getType(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSParameterDefinitionGeneric)this.object).getType(systemEnvironment);
    }

    public String getTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSParameterDefinitionGeneric)this.object).getTypeAsString(systemEnvironment);
    }

    public void setType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSParameterDefinitionGeneric)this.object).setType(systemEnvironment, n);
    }

    public Integer getAggFunction(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSParameterDefinitionGeneric)this.object).getAggFunction(systemEnvironment);
    }

    public String getAggFunctionAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSParameterDefinitionGeneric)this.object).getAggFunctionAsString(systemEnvironment);
    }

    public void setAggFunction(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSParameterDefinitionGeneric)this.object).setAggFunction(systemEnvironment, n);
    }

    public String getDefaultValue(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSParameterDefinitionGeneric)this.object).getDefaultValue(systemEnvironment);
    }

    public void setDefaultValue(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSParameterDefinitionGeneric)this.object).setDefaultValue(systemEnvironment, string);
    }

    public static int getDefaultValueMaxLength() {
        return 256;
    }

    public Boolean getIsLocal(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSParameterDefinitionGeneric)this.object).getIsLocal(systemEnvironment);
    }

    public void setIsLocal(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSParameterDefinitionGeneric)this.object).setIsLocal(systemEnvironment, bl);
    }

    public Long getLinkPdId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSParameterDefinitionGeneric)this.object).getLinkPdId(systemEnvironment);
    }

    public void setLinkPdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSParameterDefinitionGeneric)this.object).setLinkPdId(systemEnvironment, l);
    }

    public String getExportName(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSParameterDefinitionGeneric)this.object).getExportName(systemEnvironment);
    }

    public void setExportName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSParameterDefinitionGeneric)this.object).setExportName(systemEnvironment, string);
    }

    public static int getExportNameMaxLength() {
        return 64;
    }

    public Boolean getIsLong(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSParameterDefinitionGeneric)this.object).getIsLong(systemEnvironment);
    }

    public void setIsLong(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSParameterDefinitionGeneric)this.object).setIsLong(systemEnvironment, bl);
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSParameterDefinitionGeneric)this.object).getCreatorUId(systemEnvironment);
    }

    private void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSParameterDefinitionGeneric)this.object).setCreatorUId(systemEnvironment, l);
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSParameterDefinitionGeneric)this.object).getCreateTs(systemEnvironment);
    }

    private void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSParameterDefinitionGeneric)this.object).setCreateTs(systemEnvironment, l);
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSParameterDefinitionGeneric)this.object).getChangerUId(systemEnvironment);
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSParameterDefinitionGeneric)this.object).setChangerUId(systemEnvironment, l);
    }

    protected SDMSParameterDefinition setChangerUIdNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSParameterDefinitionGeneric)this.object).setChangerUId(systemEnvironment, l);
        return (SDMSParameterDefinition)this;
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSParameterDefinitionGeneric)this.object).getChangeTs(systemEnvironment);
    }

    private void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSParameterDefinitionGeneric)this.object).setChangeTs(systemEnvironment, l);
    }

    protected SDMSParameterDefinition setChangeTsNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSParameterDefinitionGeneric)this.object).setChangeTs(systemEnvironment, l);
        return (SDMSParameterDefinition)this;
    }

    public SDMSParameterDefinition set_SeIdName(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        this.checkRead(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181242"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSParameterDefinitionGeneric)this.object).set_SeIdName(systemEnvironment, l, string);
        return (SDMSParameterDefinition)this;
    }

    @Override
    public SDMSKey getSortKey(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSKey sDMSKey = null;
        Long l = this.getId(systemEnvironment);
        if (systemEnvironment.tx.sortKeyMap == null) {
            systemEnvironment.tx.sortKeyMap = new HashMap();
        } else {
            sDMSKey = (SDMSKey)systemEnvironment.tx.sortKeyMap.get(l);
        }
        if (sDMSKey != null) {
            return sDMSKey;
        }
        boolean bl = false;
        sDMSKey = new SDMSKey();
        sDMSKey.add(this.getSeId(systemEnvironment));
        sDMSKey.add((Comparable)((Object)this.getName(systemEnvironment)));
        systemEnvironment.tx.sortKeyMap.put(l, sDMSKey);
        return sDMSKey;
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSObjectCommentTable.dropComment(systemEnvironment, this.getId(systemEnvironment));
        this.touchMaster(systemEnvironment);
        super.delete(systemEnvironment);
    }

    @Override
    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null) & l) == l;
    }

    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l, long l2) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null, l2) & l) == l;
    }

    @Override
    public long getPrivilegeMask() {
        return 0x10000111L;
    }

    @Override
    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, null));
    }

    @Override
    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, vector));
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        long l2;
        SDMSProxy sDMSProxy;
        if (vector == null) {
            Vector vector2 = new Vector();
        } else {
            Vector vector3 = vector;
        }
        long l3 = 0L;
        l3 = l;
        SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULING_ENTITY");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getSeId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "FOLDER");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getSeId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCOPE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getSeId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NAMED_RESOURCE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getSeId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return l3;
    }

    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, null, l));
    }

    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector, long l) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, vector, l));
    }

    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector, long l2) throws SDMSException {
        long l3;
        SDMSProxy sDMSProxy;
        if (vector == null) {
            Vector vector2 = new Vector();
        } else {
            Vector vector3 = vector;
        }
        long l4 = 0L;
        l4 = l;
        SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULING_ENTITY");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getSeId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "FOLDER");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getSeId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCOPE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getSeId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NAMED_RESOURCE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getSeId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return l4;
    }

    @Override
    public SDMSMessage accessViolationMessage(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, string, "Insufficient privileges accessing ParameterDefinition $1", (Object)this.getId(systemEnvironment));
        return sDMSMessage;
    }

    void touchMaster(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSProxy sDMSProxy;
        SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULING_ENTITY");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getSeId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "FOLDER");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getSeId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCOPE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getSeId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NAMED_RESOURCE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getSeId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Override
    protected void touch(SystemEnvironment systemEnvironment) throws SDMSException {
        this.setChangerUIdNoCheck(systemEnvironment, systemEnvironment.cEnv.uid());
        this.setChangeTsNoCheck(systemEnvironment, systemEnvironment.txTime());
    }

    public void print() {
        ((SDMSParameterDefinitionGeneric)this.object).print();
    }
}

