/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPooledResource;
import de.independit.scheduler.server.repository.SDMSPooledResourceGeneric;
import de.independit.scheduler.server.repository.SDMSPooledResourceTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSPooledResourceTableGeneric
extends SDMSTable {
    public static final String tableName = "POOLED_RESOURCE";
    public static SDMSPooledResourceTable table = null;
    public static final String[] columnNames = new String[]{"ID", "P_ID", "R_ID", "IS_POOL", "IS_MANAGED", "NOM_PCT", "FREE_PCT", "MIN_PCT", "MAX_PCT", "ACT_IS_MANAGED", "ACT_NOM_PCT", "ACT_FREE_PCT", "ACT_MIN_PCT", "ACT_MAX_PCT", "TARGET_AMOUNT", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_pId;
    public static SDMSIndex idx_rId;
    public static SDMSIndex idx_pId_rId;

    public SDMSPooledResourceTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "PooledResource"));
        }
        table = (SDMSPooledResourceTable)this;
        table = (SDMSPooledResourceTable)this;
        this.isVersioned = false;
        idx_pId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "pId");
        idx_rId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "rId");
        idx_pId_rId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "pId_rId");
    }

    public SDMSPooledResource create(SystemEnvironment systemEnvironment, Long l, Long l2, Boolean bl, Boolean bl2, Integer n, Integer n2, Integer n3, Integer n4, Boolean bl3, Integer n5, Integer n6, Integer n7, Integer n8, Integer n9) throws SDMSException {
        SDMSPooledResource sDMSPooledResource;
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "PooledResource"));
        }
        this.validate(systemEnvironment, l, l2, bl, bl2, n, n2, n3, n4, bl3, n5, n6, n7, n8, n9, l3, l4, l5, l6);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSPooledResourceGeneric sDMSPooledResourceGeneric = new SDMSPooledResourceGeneric(systemEnvironment, l, l2, bl, bl2, n, n2, n3, n4, bl3, n5, n6, n7, n8, n9, l3, l4, l5, l6);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSPooledResourceGeneric.versions, true);
            table.put(systemEnvironment, sDMSPooledResourceGeneric.id, sDMSPooledResourceGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSPooledResource = (SDMSPooledResource)sDMSPooledResourceGeneric.toProxy(systemEnvironment);
            sDMSPooledResource.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSPooledResource sDMSPooledResource2 = (SDMSPooledResource)sDMSPooledResourceGeneric.toProxy(systemEnvironment);
            sDMSPooledResource2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSPooledResource)) {
            throw new AccessViolationException(sDMSPooledResource.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSPooledResource.touchMaster(systemEnvironment);
        return sDMSPooledResource;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSPooledResource sDMSPooledResource) throws SDMSException {
        return sDMSPooledResource.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Boolean bl, Boolean bl2, Integer n, Integer n2, Integer n3, Integer n4, Boolean bl3, Integer n5, Integer n6, Integer n7, Integer n8, Integer n9, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Integer n;
        Integer n2;
        Integer n3;
        Integer n4;
        Integer n5;
        Boolean bl;
        Integer n6;
        Integer n7;
        Integer n8;
        Integer n9;
        Boolean bl2;
        Boolean bl3;
        Long l7;
        Long l8;
        Long l9;
        try {
            l9 = new Long(resultSet.getLong(1));
            l8 = new Long(resultSet.getLong(2));
            l7 = new Long(resultSet.getLong(3));
            bl3 = new Boolean(resultSet.getInt(4) != 0);
            bl2 = new Boolean(resultSet.getInt(5) != 0);
            n9 = new Integer(resultSet.getInt(6));
            n8 = new Integer(resultSet.getInt(7));
            n7 = new Integer(resultSet.getInt(8));
            n6 = new Integer(resultSet.getInt(9));
            bl = new Boolean(resultSet.getInt(10) != 0);
            n5 = new Integer(resultSet.getInt(11));
            n4 = new Integer(resultSet.getInt(12));
            n3 = new Integer(resultSet.getInt(13));
            n2 = new Integer(resultSet.getInt(14));
            n = new Integer(resultSet.getInt(15));
            l6 = new Long(resultSet.getLong(16));
            l5 = new Long(resultSet.getLong(17));
            l4 = new Long(resultSet.getLong(18));
            l3 = new Long(resultSet.getLong(19));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "PooledResource: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSPooledResourceGeneric(l9, l8, l7, bl3, bl2, n9, n8, n7, n6, bl, n5, n4, n3, n2, n, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "P_ID" + string2 + ", " + string + "R_ID" + string2 + ", " + string + "IS_POOL" + string2 + ", " + string + "IS_MANAGED" + string2 + ", " + string + "NOM_PCT" + string2 + ", " + string + "FREE_PCT" + string2 + ", " + string + "MIN_PCT" + string2 + ", " + string + "MAX_PCT" + string2 + ", " + string + "ACT_IS_MANAGED" + string2 + ", " + string + "ACT_NOM_PCT" + string2 + ", " + string + "ACT_FREE_PCT" + string2 + ", " + string + "ACT_MIN_PCT" + string2 + ", " + string + "ACT_MAX_PCT" + string2 + ", " + string + "TARGET_AMOUNT" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_pId.check(((SDMSPooledResourceGeneric)sDMSObject).pId, sDMSObject);
        string = string + "idx_pId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_rId.check(((SDMSPooledResourceGeneric)sDMSObject).rId, sDMSObject);
        string = string + "idx_rId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSPooledResourceGeneric)sDMSObject).pId);
        sDMSKey.add(((SDMSPooledResourceGeneric)sDMSObject).rId);
        bl = idx_pId_rId.check(sDMSKey, sDMSObject);
        string = string + "idx_pId_rId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_pId.put(systemEnvironment, ((SDMSPooledResourceGeneric)sDMSObject).pId, sDMSObject, (1L & l) != 0L);
        idx_rId.put(systemEnvironment, ((SDMSPooledResourceGeneric)sDMSObject).rId, sDMSObject, (2L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSPooledResourceGeneric)sDMSObject).pId);
        sDMSKey.add(((SDMSPooledResourceGeneric)sDMSObject).rId);
        idx_pId_rId.put(systemEnvironment, sDMSKey, sDMSObject, (4L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_pId.remove(systemEnvironment, ((SDMSPooledResourceGeneric)sDMSObject).pId, sDMSObject);
        idx_rId.remove(systemEnvironment, ((SDMSPooledResourceGeneric)sDMSObject).rId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSPooledResourceGeneric)sDMSObject).pId);
        sDMSKey.add(((SDMSPooledResourceGeneric)sDMSObject).rId);
        idx_pId_rId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSPooledResource getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSPooledResource)table.get(systemEnvironment, l);
    }

    public static SDMSPooledResource getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSPooledResource)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSPooledResource getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSPooledResource)table.get(systemEnvironment, l, l2);
    }

    public static SDMSPooledResource idx_pId_rId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSPooledResource)idx_pId_rId.getUnique(systemEnvironment, object);
    }

    public static SDMSPooledResource idx_pId_rId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSPooledResource)idx_pId_rId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSPooledResource idx_pId_rId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSPooledResource)idx_pId_rId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

