/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.locking.LockingSystem;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.util.PathVector;
import java.util.Vector;

public abstract class SDMSProxy
implements Comparable {
    public static final String __version = "@(#) $Id: SDMSProxy.java,v 2.11.2.2 2013/03/16 11:47:20 dieter Exp $";
    public static final Long ZERO = new Long(0L);
    public SDMSObject object;
    protected boolean lockedExclusive;
    protected boolean current;
    protected SDMSProxy next = null;
    protected boolean fixed = false;

    protected SDMSProxy(SDMSObject sDMSObject) {
        this.object = sDMSObject;
        this.current = false;
        this.lockedExclusive = false;
    }

    protected void initProxy(SDMSObject sDMSObject) {
        this.object = sDMSObject;
    }

    public void fix() {
        this.fixed = true;
    }

    protected void cleanupProxy() {
        this.object = null;
        this.current = false;
        this.lockedExclusive = false;
    }

    protected void checkRead(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.current) {
            if (!this.object.isCurrent) {
                this.object = this.object.versions.get(systemEnvironment);
            }
            if (this.object.isDeleted) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "02110292004", "Accessing a previously deleted object"));
            }
        }
    }

    protected void checkWrite(SystemEnvironment systemEnvironment) throws SDMSException {
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110182335", "Illegal write access in Readonly Transaction"));
        }
        if (!this.current) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "02110292014", "Trying to change object via readonly object reference"));
        }
        if (!this.lockedExclusive) {
            if (SystemEnvironment.maxWriter > 1) {
                LockingSystem.lock(systemEnvironment, this.object.versions, 1);
            }
            this.lockedExclusive = true;
        }
        this.checkRead(systemEnvironment);
    }

    void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        this.objectDelete(systemEnvironment, false);
    }

    public void memDelete(SystemEnvironment systemEnvironment) throws SDMSException {
        this.objectDelete(systemEnvironment, true);
    }

    private void objectDelete(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        if (!this.lockedExclusive) {
            if (SystemEnvironment.maxWriter > 1) {
                LockingSystem.lock(systemEnvironment, this.object.versions, 1);
            }
            this.lockedExclusive = true;
        }
        this.checkRead(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 16L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "03312191407"));
        }
        if (bl) {
            this.object.memDelete(systemEnvironment);
        } else {
            this.object.delete(systemEnvironment);
        }
    }

    public abstract SDMSKey getSortKey(SystemEnvironment var1) throws SDMSException;

    public String toString() {
        return "SDMSProxy (object = " + this.object.toString() + ",current = " + this.current + ", lockedExclusive = " + this.lockedExclusive + ")";
    }

    public long getValidFrom(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return this.object.getValidFrom(systemEnvironment);
    }

    public long getValidTo(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return this.object.getValidTo(systemEnvironment);
    }

    public Long getId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return this.object.getId(systemEnvironment);
    }

    protected abstract void touch(SystemEnvironment var1) throws SDMSException;

    synchronized void release(SystemEnvironment systemEnvironment) throws SDMSException {
        this.object.memDelete(systemEnvironment);
    }

    public Vector getContent(SystemEnvironment systemEnvironment) throws SDMSException {
        return null;
    }

    public void releaseLockToCheckPoint(SystemEnvironment systemEnvironment, int n) throws FatalException {
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.releaseToCheckPoint(systemEnvironment, this.object.versions, n);
        }
    }

    public abstract long getPrivilegeMask();

    public abstract boolean checkPrivileges(SystemEnvironment var1, long var2) throws SDMSException;

    public abstract SDMSPrivilege getPrivileges(SystemEnvironment var1) throws SDMSException;

    public abstract SDMSPrivilege getPrivilegesForGroups(SystemEnvironment var1, Vector var2) throws SDMSException;

    public abstract long getPrivileges(SystemEnvironment var1, long var2, boolean var4, Vector var5) throws SDMSException;

    public abstract SDMSMessage accessViolationMessage(SystemEnvironment var1, String var2) throws SDMSException;

    public void dumpVersions() {
        this.object.dumpVersions();
    }

    public String getURL(SystemEnvironment systemEnvironment) throws SDMSException {
        return "getURL is not supported for this object";
    }

    public String getURLName(SystemEnvironment systemEnvironment) throws SDMSException {
        return "getURLName is not supported for this object";
    }

    public String getSubtypeName(SystemEnvironment systemEnvironment) throws SDMSException {
        return "";
    }

    public int compareTo(Object object) {
        SDMSProxy sDMSProxy = (SDMSProxy)object;
        return this.object.compareTo(sDMSProxy.object);
    }

    public Long getInheritPrivs(SystemEnvironment systemEnvironment) throws SDMSException {
        return ZERO;
    }

    public long addImplicitPrivs(long l) {
        if (l != 0L) {
            l |= 0x10000000L;
        }
        if ((l & 0x10000L) != 0L) {
            l |= 0x1000L;
        }
        return l;
    }

    public Long getParentId(SystemEnvironment systemEnvironment) throws SDMSException {
        return null;
    }

    public SDMSProxy getParent(SystemEnvironment systemEnvironment) throws SDMSException {
        return null;
    }

    public PathVector pathVector(SystemEnvironment systemEnvironment) throws SDMSException {
        return null;
    }

    public Long getOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        return null;
    }
}

