/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSResourceStateMapping;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingGeneric;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSResourceStateMappingTableGeneric
extends SDMSTable {
    public static final String tableName = "RESOURCE_STATE_MAPPING";
    public static SDMSResourceStateMappingTable table = null;
    public static final String[] columnNames = new String[]{"ID", "RSMP_ID", "ESD_ID", "FROM_RSD_ID", "TO_RSD_ID", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_rsmpId;
    public static SDMSIndex idx_esdId;
    public static SDMSIndex idx_fromRsdId;
    public static SDMSIndex idx_toRsdId;
    public static SDMSIndex idx_rsmpId__esdId_fromRsdId;

    public SDMSResourceStateMappingTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "ResourceStateMapping"));
        }
        table = (SDMSResourceStateMappingTable)this;
        table = (SDMSResourceStateMappingTable)this;
        this.isVersioned = true;
        idx_rsmpId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "rsmpId");
        idx_esdId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "esdId");
        idx_fromRsdId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "fromRsdId");
        idx_toRsdId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "toRsdId");
        idx_rsmpId__esdId_fromRsdId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "rsmpId__esdId_fromRsdId");
    }

    public SDMSResourceStateMapping create(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4) throws SDMSException {
        SDMSResourceStateMapping sDMSResourceStateMapping;
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        Long l7 = systemEnvironment.cEnv.uid();
        Long l8 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "ResourceStateMapping"));
        }
        this.validate(systemEnvironment, l, l2, l3, l4, l5, l6, l7, l8);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSResourceStateMappingGeneric sDMSResourceStateMappingGeneric = new SDMSResourceStateMappingGeneric(systemEnvironment, l, l2, l3, l4, l5, l6, l7, l8);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSResourceStateMappingGeneric.versions, true);
            table.put(systemEnvironment, sDMSResourceStateMappingGeneric.id, sDMSResourceStateMappingGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSResourceStateMapping = (SDMSResourceStateMapping)sDMSResourceStateMappingGeneric.toProxy(systemEnvironment);
            sDMSResourceStateMapping.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSResourceStateMapping sDMSResourceStateMapping2 = (SDMSResourceStateMapping)sDMSResourceStateMappingGeneric.toProxy(systemEnvironment);
            sDMSResourceStateMapping2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSResourceStateMapping)) {
            throw new AccessViolationException(sDMSResourceStateMapping.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSResourceStateMapping.touchMaster(systemEnvironment);
        return sDMSResourceStateMapping;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSResourceStateMapping sDMSResourceStateMapping) throws SDMSException {
        return sDMSResourceStateMapping.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7, Long l8) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        Long l9;
        Long l10;
        Long l11;
        try {
            l11 = new Long(resultSet.getLong(1));
            l10 = new Long(resultSet.getLong(2));
            l9 = new Long(resultSet.getLong(3));
            l8 = new Long(resultSet.getLong(4));
            if (resultSet.wasNull()) {
                l8 = null;
            }
            l7 = new Long(resultSet.getLong(5));
            l6 = new Long(resultSet.getLong(6));
            l5 = new Long(resultSet.getLong(7));
            l4 = new Long(resultSet.getLong(8));
            l3 = new Long(resultSet.getLong(9));
            l2 = resultSet.getLong(10);
            l = resultSet.getLong(11);
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "ResourceStateMapping: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSResourceStateMappingGeneric(l11, l10, l9, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "RSMP_ID" + string2 + ", " + string + "ESD_ID" + string2 + ", " + string + "FROM_RSD_ID" + string2 + ", " + string + "TO_RSD_ID" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", VALID_FROM, VALID_TO  FROM " + string + this.tableName() + string2 + " WHERE VALID_TO >= " + (bl ? "CAST ('" + systemEnvironment.lowestActiveVersion + "' AS DECIMAL)" : "" + systemEnvironment.lowestActiveVersion) + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_rsmpId.check(((SDMSResourceStateMappingGeneric)sDMSObject).rsmpId, sDMSObject);
        string = string + "idx_rsmpId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_esdId.check(((SDMSResourceStateMappingGeneric)sDMSObject).esdId, sDMSObject);
        string = string + "idx_esdId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_fromRsdId.check(((SDMSResourceStateMappingGeneric)sDMSObject).fromRsdId, sDMSObject);
        string = string + "idx_fromRsdId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_toRsdId.check(((SDMSResourceStateMappingGeneric)sDMSObject).toRsdId, sDMSObject);
        string = string + "idx_toRsdId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceStateMappingGeneric)sDMSObject).rsmpId);
        sDMSKey.add(((SDMSResourceStateMappingGeneric)sDMSObject).esdId);
        sDMSKey.add(((SDMSResourceStateMappingGeneric)sDMSObject).fromRsdId);
        bl = idx_rsmpId__esdId_fromRsdId.check(sDMSKey, sDMSObject);
        string = string + "idx_rsmpId__esdId_fromRsdId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_rsmpId.put(systemEnvironment, ((SDMSResourceStateMappingGeneric)sDMSObject).rsmpId, sDMSObject, (1L & l) != 0L);
        idx_esdId.put(systemEnvironment, ((SDMSResourceStateMappingGeneric)sDMSObject).esdId, sDMSObject, (2L & l) != 0L);
        idx_fromRsdId.put(systemEnvironment, ((SDMSResourceStateMappingGeneric)sDMSObject).fromRsdId, sDMSObject, (4L & l) != 0L);
        idx_toRsdId.put(systemEnvironment, ((SDMSResourceStateMappingGeneric)sDMSObject).toRsdId, sDMSObject, (8L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceStateMappingGeneric)sDMSObject).rsmpId);
        sDMSKey.add(((SDMSResourceStateMappingGeneric)sDMSObject).esdId);
        sDMSKey.add(((SDMSResourceStateMappingGeneric)sDMSObject).fromRsdId);
        idx_rsmpId__esdId_fromRsdId.put(systemEnvironment, sDMSKey, sDMSObject, (0x10L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_rsmpId.remove(systemEnvironment, ((SDMSResourceStateMappingGeneric)sDMSObject).rsmpId, sDMSObject);
        idx_esdId.remove(systemEnvironment, ((SDMSResourceStateMappingGeneric)sDMSObject).esdId, sDMSObject);
        idx_fromRsdId.remove(systemEnvironment, ((SDMSResourceStateMappingGeneric)sDMSObject).fromRsdId, sDMSObject);
        idx_toRsdId.remove(systemEnvironment, ((SDMSResourceStateMappingGeneric)sDMSObject).toRsdId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceStateMappingGeneric)sDMSObject).rsmpId);
        sDMSKey.add(((SDMSResourceStateMappingGeneric)sDMSObject).esdId);
        sDMSKey.add(((SDMSResourceStateMappingGeneric)sDMSObject).fromRsdId);
        idx_rsmpId__esdId_fromRsdId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSResourceStateMapping getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSResourceStateMapping)table.get(systemEnvironment, l);
    }

    public static SDMSResourceStateMapping getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSResourceStateMapping)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSResourceStateMapping getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSResourceStateMapping)table.get(systemEnvironment, l, l2);
    }

    public static SDMSResourceStateMapping idx_rsmpId__esdId_fromRsdId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSResourceStateMapping)idx_rsmpId__esdId_fromRsdId.getUnique(systemEnvironment, object);
    }

    public static SDMSResourceStateMapping idx_rsmpId__esdId_fromRsdId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSResourceStateMapping)idx_rsmpId__esdId_fromRsdId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSResourceStateMapping idx_rsmpId__esdId_fromRsdId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSResourceStateMapping)idx_rsmpId__esdId_fromRsdId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

