/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSScheduleProxyGeneric;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.timer.TimerDate;
import de.independit.scheduler.server.util.SDMSThread;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SDMSSchedule
extends SDMSScheduleProxyGeneric
implements ThreadFactory {
    public static final String __version = "@(#) $Id: SDMSSchedule.java,v 2.11.2.3 2013/03/16 11:47:21 dieter Exp $";
    SDMSThread thread = null;
    private SDMSInterval interval = null;
    private TimeZone tz = null;

    protected SDMSSchedule(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    @Override
    protected void initProxy(SDMSObject sDMSObject) {
        super.initProxy(sDMSObject);
        this.thread = null;
        this.interval = null;
        this.tz = null;
    }

    public final TimerDate getNextTriggerDate(final SystemEnvironment systemEnvironment, final TimerDate timerDate) throws SDMSException {
        Object object;
        Comparable<Long> comparable;
        if (this.interval == null && (comparable = this.getIntId(systemEnvironment)) != null) {
            this.interval = SDMSIntervalTable.getObject(systemEnvironment, comparable);
            object = this.getTimeZone(systemEnvironment);
            this.tz = TimeZone.getTimeZone((String)object);
        }
        if (this.interval == null) {
            return new TimerDate();
        }
        object = Executors.newFixedThreadPool(1, this);
        Future<TimerDate> future = object.submit(new Callable<TimerDate>(){

            @Override
            public TimerDate call() {
                try {
                    SDMSThread.doTrace(systemEnvironment.cEnv, "SDMSSchedule: minDate = " + timerDate.toString(), 3);
                    long l = System.currentTimeMillis();
                    long l2 = timerDate.getTime();
                    GregorianCalendar gregorianCalendar = SystemEnvironment.newGregorianCalendar();
                    gregorianCalendar.setTimeInMillis(l2);
                    gregorianCalendar.setTimeZone(SDMSSchedule.this.tz);
                    l2 = gregorianCalendar.getTimeInMillis();
                    Long l3 = SDMSSchedule.this.interval.getNextTriggerDate(systemEnvironment, new Long(l2), 0L, SDMSSchedule.this.tz, false);
                    TimerDate timerDate2 = new TimerDate();
                    if (l3 != null) {
                        l2 = l3;
                        gregorianCalendar.setTimeInMillis(l2);
                        gregorianCalendar.setTimeZone(SystemEnvironment.systemTimeZone);
                        timerDate2 = new TimerDate((int)(gregorianCalendar.getTimeInMillis() / 60000L));
                    }
                    l = System.currentTimeMillis() - l;
                    SDMSThread.doTrace(systemEnvironment.cEnv, "SDMSSchedule: runtime = " + l + " ms, result = " + timerDate2.toString(), 3);
                    return timerDate2;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, "02205080756", "Exception ($1)", (Object)exception.toString());
                    SDMSThread.doTrace(systemEnvironment.cEnv, sDMSMessage.toString(), -1);
                    return new TimerDate();
                }
            }
        });
        try {
            comparable = future.get(SystemEnvironment.timerTimeout, TimeUnit.SECONDS);
            object.shutdown();
        }
        catch (TimeoutException timeoutException) {
            object.shutdown();
            SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, "02205080950", "Timeout Exception during calculation of next execution");
            String string = SDMSThread.getHeader(systemEnvironment.cEnv, 1);
            System.err.println(string + sDMSMessage.toString());
            StackTraceElement[] stackTraceElementArray = this.thread.getStackTrace();
            System.err.println(string + "****************** Start Stacktrace *********************");
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                System.err.println(string + stackTraceElementArray[i].toString());
            }
            System.err.println(string + "****************** End Stacktrace   *********************");
            future.cancel(true);
            throw new CommonErrorException(sDMSMessage);
        }
        catch (ExecutionException executionException) {
            object.shutdown();
            throw (SDMSException)executionException.getCause();
        }
        catch (Exception exception) {
            object.shutdown();
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02205080653", "Unexpected Exception ($1) during calculation of next execution", (Object)exception.toString()));
        }
        return comparable;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        final int n = 1000 + ((SDMSThread)Thread.currentThread()).id();
        String string = "getNextTriggerDate from " + ((SDMSThread)Thread.currentThread()).getName();
        this.thread = new SDMSThread(runnable){

            @Override
            public int id() {
                return n;
            }

            @Override
            public void SDMSrun() {
            }
        };
        this.thread.lockThread = (SDMSThread)Thread.currentThread();
        this.thread.setName(string);
        return this.thread;
    }

    public final boolean isReallyActive(SystemEnvironment systemEnvironment) throws SDMSException {
        boolean bl = this.getIsActive(systemEnvironment);
        if (bl) {
            SDMSSchedule sDMSSchedule;
            Long l = this.getParentId(systemEnvironment);
            while (l != null && (bl = (sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, l)).getIsActive(systemEnvironment).booleanValue())) {
                l = sDMSSchedule.getParentId(systemEnvironment);
            }
        }
        return bl;
    }

    @Override
    public String getURLName(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getSeId(systemEnvironment);
        String string = null;
        if (l != null) {
            string = SDMSSchedulingEntityTable.getObject(systemEnvironment, l).pathString(systemEnvironment);
        }
        return this.pathString(systemEnvironment) + (string == null ? "" : " (" + string + ")");
    }

    @Override
    public String getURL(SystemEnvironment systemEnvironment) throws SDMSException {
        return "schedule " + this.getURLName(systemEnvironment);
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        Vector vector2;
        long l2 = 0L;
        Long l3 = this.getSeId(systemEnvironment);
        if (l3 == null) {
            l2 = super.getPrivileges(systemEnvironment, l, bl, vector);
            if (systemEnvironment.cEnv.isUser() && this.getParentId(systemEnvironment) == null) {
                l2 = l2 | 0x10000000L | 2L;
            }
            return l2 & l;
        }
        if (vector == null) {
            vector2 = new Vector();
            if (systemEnvironment.cEnv.isUser()) {
                vector2.addAll(systemEnvironment.cEnv.gid());
            }
        } else {
            vector2 = vector;
        }
        l2 = 0L;
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l3);
        long l4 = sDMSSchedulingEntity.getPrivileges(systemEnvironment, 0x10100000L, false, vector2);
        if ((l4 & 0x100000L) == 0x100000L) {
            Long l5 = this.getOwnerId(systemEnvironment);
            l2 = vector2.contains(l5) || vector2.contains(SDMSObject.adminGId) ? l : 0x10000000L;
        } else if ((l4 & 0x10000000L) == 0x10000000L) {
            l2 |= 0x10000000L;
        }
        l2 = this.addImplicitPrivs(l2) & l;
        return l2 & l;
    }
}

