/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSSmeCounter;
import de.independit.scheduler.server.repository.SDMSSmeCounterTableGeneric;
import de.independit.scheduler.server.util.CheckSum;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class SDMSSmeCounterTable
extends SDMSSmeCounterTableGeneric {
    public static final String __version = "SDMSSmeCounterTable $Revision: 2.3.2.1 $ / @(#) $Id: SDMSSmeCounterTable.java,v 2.3.2.1 2013/03/14 10:25:25 ronald Exp $";

    public SDMSSmeCounterTable(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
    }

    public static void updateCounter(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSSmeCounter sDMSSmeCounter;
        int n = systemEnvironment.tx.smeCtr;
        if (n == 0) {
            return;
        }
        TimeZone timeZone = SystemEnvironment.systemTimeZone;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        Integer n2 = new Integer(gregorianCalendar.get(5));
        Integer n3 = new Integer(gregorianCalendar.get(2) + 1);
        Integer n4 = new Integer(gregorianCalendar.get(1));
        try {
            sDMSSmeCounter = SDMSSmeCounterTable.idx_jahr_monat_tag_getUniqueForUpdate(systemEnvironment, new SDMSKey(n4, n3, n2));
        }
        catch (NotFoundException notFoundException) {
            sDMSSmeCounter = table.create(systemEnvironment, n4, n3, n2, new Integer(0), new Long(0L));
        }
        Integer n5 = sDMSSmeCounter.getAnzahl(systemEnvironment);
        n5 = new Integer(n5 + n);
        Long l = new Long(CheckSum.fastchksum(n4, n3, n2, n5));
        sDMSSmeCounter.setAnzahl(systemEnvironment, n5);
        sDMSSmeCounter.setChecksum(systemEnvironment, l);
        systemEnvironment.tx.smeCtr = new Integer(0);
    }
}

