/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSInstanceValue;
import de.independit.scheduler.server.repository.SDMSInstanceValueTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectInstance;
import de.independit.scheduler.server.repository.SDMSObjectInstanceTable;
import de.independit.scheduler.server.repository.SDMSObjectMonitor;
import de.independit.scheduler.server.repository.SDMSObjectMonitorParameter;
import de.independit.scheduler.server.repository.SDMSObjectMonitorParameterTable;
import de.independit.scheduler.server.repository.SDMSObjectMonitorTable;
import de.independit.scheduler.server.repository.SDMSWatchTypeParameterProxyGeneric;
import java.util.Vector;

public class SDMSWatchTypeParameter
extends SDMSWatchTypeParameterProxyGeneric {
    public static final String __version = "SDMSWatchTypeParameter $Revision / @(#) $Id: SDMSWatchTypeParameter.java,v 2.2.4.1 2013/03/14 10:25:27 ronald Exp $";

    protected SDMSWatchTypeParameter(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    @Override
    public void setType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n == 1 && this.getType(systemEnvironment) != 1 || n != 1 && this.getType(systemEnvironment) == 1) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02108251127", "Cannot change parameter type INFO or VALUE to or from CONFIG"));
        }
        super.setType(systemEnvironment, n);
    }

    @Override
    public void setDefaultValue(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string == null) {
            Long l = this.getWtId(systemEnvironment);
            Vector vector = SDMSObjectMonitorTable.idx_wtId.getVector(systemEnvironment, l);
            for (SDMSObjectMonitor sDMSObjectMonitor : vector) {
                Long l2 = sDMSObjectMonitor.getId(systemEnvironment);
                if (this.getType(systemEnvironment) == 1) {
                    if (SDMSObjectMonitorParameterTable.idx_omId_wtpId.containsKey(systemEnvironment, new SDMSKey(l2, this.getId(systemEnvironment)))) continue;
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02108251050", "Object Type $1 requires a default for config parameter $2", (Object)sDMSObjectMonitor.getName(systemEnvironment), (Object)this.getName(systemEnvironment)));
                }
                Vector vector2 = SDMSObjectInstanceTable.idx_omId.getVector(systemEnvironment, l2);
                for (SDMSObjectInstance sDMSObjectInstance : vector2) {
                    if (sDMSObjectInstance.getRemoveTs(systemEnvironment) != null || SDMSInstanceValueTable.idx_oiId_wtpId.containsKey(systemEnvironment, new SDMSKey(sDMSObjectInstance.getId(systemEnvironment), this.getId(systemEnvironment)))) continue;
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02108251050", "Instance $1 of Object Type $2 requires a default for parameter $3", sDMSObjectInstance.getUniqueName(systemEnvironment), sDMSObjectMonitor.getName(systemEnvironment), this.getName(systemEnvironment)));
                }
            }
        }
        super.setDefaultValue(systemEnvironment, string);
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSObjectMonitorParameterTable.idx_wtpId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSObjectMonitorParameter sDMSObjectMonitorParameter = (SDMSObjectMonitorParameter)vector.get(i);
            sDMSObjectMonitorParameter.delete(systemEnvironment);
        }
        Vector vector2 = SDMSInstanceValueTable.idx_wtpId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSInstanceValue sDMSInstanceValue = (SDMSInstanceValue)vector2.get(i);
            sDMSInstanceValue.delete(systemEnvironment);
        }
        super.delete(systemEnvironment);
    }
}

