/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSAuditTrail;
import de.independit.scheduler.server.repository.SDMSAuditTrailTable;
import de.independit.scheduler.server.repository.SDMSEntityVariable;
import de.independit.scheduler.server.repository.SDMSEntityVariableTable;
import de.independit.scheduler.server.repository.SDMSExitStateDefinition;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedEnvironment;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceAllocation;
import de.independit.scheduler.server.repository.SDMSResourceAllocationTable;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinition;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import de.independit.scheduler.server.repository.SDMSUserProxyGeneric;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.repository.SDMSnpSrvrSRFootprintTable;
import de.independit.scheduler.server.repository.VariableResolver;
import de.independit.scheduler.server.util.SDMSThread;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;

public class SmeVariableResolver
extends VariableResolver {
    public static final String S_JOBID = "JOBID";
    public static final String S_SEID = "SEID";
    public static final String S_MASTERID = "MASTERID";
    public static final String S_KEY = "KEY";
    public static final String S_PID = "PID";
    public static final String S_LOGFILE = "LOGFILE";
    public static final String S_ERRORLOG = "ERRORLOG";
    public static final String S_WORKDIR = "WORKDIR";
    public static final String S_SDMSHOST = "SDMSHOST";
    public static final String S_SDMSPORT = "SDMSPORT";
    public static final String S_JOBNAME = "JOBNAME";
    public static final String S_JOBTAG = "JOBTAG";
    public static final String S_TRNAME = "TRIGGERNAME";
    public static final String S_TRTYPE = "TRIGGERTYPE";
    public static final String S_TRBASE = "TRIGGERBASE";
    public static final String S_TRBASEID = "TRIGGERBASEID";
    public static final String S_TRBASEJOBID = "TRIGGERBASEJOBID";
    public static final String S_TRORIGIN = "TRIGGERORIGIN";
    public static final String S_TRORIGINID = "TRIGGERORIGINID";
    public static final String S_TRORIGINJOBID = "TRIGGERORIGINJOBID";
    public static final String S_TRREASON = "TRIGGERREASON";
    public static final String S_TRREASONID = "TRIGGERREASONID";
    public static final String S_TRREASONJOBID = "TRIGGERREASONJOBID";
    public static final String S_TRSEQ = "TRIGGERSEQNO";
    public static final String S_TROSTATE = "TRIGGEROLDSTATE";
    public static final String S_TRNSTATE = "TRIGGERNEWSTATE";
    public static final String S_TRWARNING = "TRIGGERWARNING";
    public static final String S_SUBMITTS = "SUBMITTIME";
    public static final String S_STARTTS = "STARTTIME";
    public static final String S_EXPRUNTIME = "EXPRUNTIME";
    public static final String S_EXPFINALTIME = "EXPFINALTIME";
    public static final String S_JOBSTATE = "JOBSTATE";
    public static final String S_MERGEDSTATE = "MERGEDSTATE";
    public static final String S_PARENTID = "PARENTID";
    public static final String S_STATE = "STATE";
    public static final String S_ISRESTARTABLE = "ISRESTARTABLE";
    public static final String S_SYNCTS = "SYNCTIME";
    public static final String S_RESOURCETS = "RESOURCETIME";
    public static final String S_RUNNABLETS = "RUNNABLETIME";
    public static final String S_FINISHTS = "FINISHTIME";
    public static final String S_SYSDATE = "SYSDATE";
    public static final String S_WARNING = "LAST_WARNING";
    public static final String S_RERUNSEQ = "RERUNSEQ";
    public static final String S_SCOPENAME = "SCOPENAME";
    public static final String S_IDLE_TIME = "IDLE_TIME";
    public static final String S_DEPENDENCY_WAIT_TIME = "DEPENDENCY_WAIT_TIME";
    public static final String S_SUSPEND_TIME = "SUSPEND_TIME";
    public static final String S_SYNC_TIME = "SYNC_TIME";
    public static final String S_RESOURCE_TIME = "RESOURCE_TIME";
    public static final String S_JOBSERVER_TIME = "JOBSERVER_TIME";
    public static final String S_RESTARTABLE_TIME = "RESTARTABLE_TIME";
    public static final String S_CHILD_WAIT_TIME = "CHILD_WAIT_TIME";
    public static final String S_PROCESS_TIME = "PROCESS_TIME";
    public static final String S_ACTIVE_TIME = "ACTIVE_TIME";
    public static final String S_IDLE_PCT = "IDLE_PCT";
    public static final String S_SUBMITTER = "SUBMITTER";
    public static final String S_SUBMITGROUP = "SUBMITGROUP";
    public static final String S_SEOWNER = "SEOWNER";
    public static final String S_ENVIRONMENT = "ENVIRONMENT";
    public static final int I_JOBID = 1;
    public static final int I_MASTERID = 2;
    public static final int I_KEY = 3;
    public static final int I_PID = 4;
    public static final int I_LOGFILE = 5;
    public static final int I_ERRORLOG = 6;
    public static final int I_SDMSHOST = 7;
    public static final int I_SDMSPORT = 8;
    public static final int I_JOBNAME = 9;
    public static final int I_JOBTAG = 10;
    public static final int I_TRNAME = 11;
    public static final int I_TRTYPE = 12;
    public static final int I_TRORIGIN = 13;
    public static final int I_TRORIGINID = 14;
    public static final int I_TRORIGINJOBID = 15;
    public static final int I_TRREASON = 16;
    public static final int I_TRREASONID = 17;
    public static final int I_TRREASONJOBID = 19;
    public static final int I_TRBASE = 20;
    public static final int I_TRBASEID = 21;
    public static final int I_TRBASEJOBID = 22;
    public static final int I_TRSEQ = 23;
    public static final int I_TROSTATE = 24;
    public static final int I_TRNSTATE = 25;
    public static final int I_SUBMITTS = 26;
    public static final int I_STARTTS = 27;
    public static final int I_EXPRUNTIME = 28;
    public static final int I_JOBSTATE = 29;
    public static final int I_MERGEDSTATE = 30;
    public static final int I_PARENTID = 31;
    public static final int I_STATE = 32;
    public static final int I_ISRESTARTABLE = 33;
    public static final int I_SYNCTS = 34;
    public static final int I_RESOURCETS = 35;
    public static final int I_RUNNABLETS = 36;
    public static final int I_FINISHTS = 37;
    public static final int I_SYSDATE = 38;
    public static final int I_SEID = 39;
    public static final int I_WORKDIR = 40;
    public static final int I_WARNING = 41;
    public static final int I_TRWARNING = 42;
    public static final int I_RERUNSEQ = 43;
    public static final int I_SCOPENAME = 44;
    public static final int I_EXPFINALTIME = 45;
    public static final int I_IDLE_TIME = 46;
    public static final int I_DEPENDENCY_WAIT_TIME = 47;
    public static final int I_SUSPEND_TIME = 48;
    public static final int I_SYNC_TIME = 49;
    public static final int I_RESOURCE_TIME = 50;
    public static final int I_JOBSERVER_TIME = 51;
    public static final int I_RESTARTABLE_TIME = 52;
    public static final int I_CHILD_WAIT_TIME = 53;
    public static final int I_PROCESS_TIME = 54;
    public static final int I_ACTIVE_TIME = 55;
    public static final int I_IDLE_PCT = 56;
    public static final int I_SUBMITTER = 57;
    public static final int I_SUBMITGROUP = 58;
    public static final int I_ENVIRONMENT = 59;
    public static final int I_SEOWNER = 60;
    private static final HashMap specialNames = new HashMap();

    @Override
    protected String getVariableValue(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, String string, boolean bl, String string2, boolean bl2, long l, SDMSScope sDMSScope) throws SDMSException {
        systemEnvironment.tx.txData.remove("ISDEFAULT");
        String string3 = this.getInternalVariableValue(systemEnvironment, sDMSProxy, string, bl, string2, bl2, new Stack(), l, sDMSScope);
        return string3;
    }

    private String getFolderVariableValue(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, String string, SDMSFolder sDMSFolder, long l) throws SDMSException {
        String string2 = null;
        try {
            string2 = sDMSFolder.getVariableValue(systemEnvironment, string, l);
        }
        catch (NotFoundException notFoundException) {
            Long l2 = sDMSSubmittedEntity.getParentId(systemEnvironment);
            if (l2 == null) {
                throw new NotFoundException(new SDMSMessage(systemEnvironment, "03405032240", "Couldn't resolve the variable $1", (Object)string));
            }
            SDMSSubmittedEntity sDMSSubmittedEntity2 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l2);
            long l3 = sDMSSubmittedEntity2.getSeVersion(systemEnvironment);
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity2.getSeId(systemEnvironment), l3);
            SDMSFolder sDMSFolder2 = SDMSFolderTable.getObject(systemEnvironment, sDMSSchedulingEntity.getFolderId(systemEnvironment), l3);
            string2 = this.getFolderVariableValue(systemEnvironment, sDMSSubmittedEntity2, string, sDMSFolder2, l3);
        }
        return string2;
    }

    @Override
    protected String getInternalVariableValue(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, String string, boolean bl, String string2, boolean bl2, Stack stack, long l, SDMSScope sDMSScope) throws SDMSException {
        SDMSEntityVariable sDMSEntityVariable = null;
        SDMSParameterDefinition sDMSParameterDefinition = null;
        SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)sDMSProxy;
        boolean bl3 = SystemEnvironment.warn_variables;
        boolean bl4 = SystemEnvironment.strict_variables;
        if (!string2.equals("DEFAULT")) {
            if (string2.equals("LIBERAL")) {
                bl3 = false;
                bl4 = false;
            } else if (string2.equals("WARN")) {
                bl3 = true;
                bl4 = false;
            } else {
                bl4 = true;
            }
        }
        if (specialNames.containsKey(string) || SystemEnvironment.scopeSysVars.contains(string)) {
            return this.getSpecialValue(systemEnvironment, sDMSSubmittedEntity, string, bl2, sDMSScope);
        }
        try {
            sDMSEntityVariable = SDMSEntityVariableTable.idx_smeId_Name_getUnique(systemEnvironment, new SDMSKey(sDMSSubmittedEntity.getId(systemEnvironment), (Comparable)((Object)string)));
            Long l2 = sDMSEntityVariable.getEvLink(systemEnvironment);
            while (l2 != null) {
                sDMSEntityVariable = SDMSEntityVariableTable.getObject(systemEnvironment, l2);
                l2 = sDMSEntityVariable.getEvLink(systemEnvironment);
            }
            String string3 = sDMSEntityVariable.getValue(systemEnvironment).substring(1);
            return this.parseAndSubstitute(systemEnvironment, sDMSSubmittedEntity, string3, bl, string2, bl2, stack, l, sDMSScope);
        }
        catch (NotFoundException notFoundException) {
            String string4;
            block25: {
                try {
                    long l3 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
                    sDMSParameterDefinition = SDMSParameterDefinitionTable.idx_seId_Name_getUnique(systemEnvironment, new SDMSKey(sDMSSubmittedEntity.getSeId(systemEnvironment), (Comparable)((Object)string)), l3);
                    if (sDMSParameterDefinition.getType(systemEnvironment) != 40 && sDMSParameterDefinition.getType(systemEnvironment) != 60) {
                        bl = false;
                    }
                }
                catch (NotFoundException notFoundException2) {
                    sDMSParameterDefinition = null;
                    if (bl) {
                        return emptyString;
                    }
                    if (bl4) {
                        SDMSThread.doTrace(null, "Couldn't find parameter " + string + " for job " + sDMSSubmittedEntity.getId(systemEnvironment) + " (no import specified)", 1);
                        throw new NotFoundException(new SDMSMessage(systemEnvironment, "03304101030", "Couldn't resolve Parameter $1", (Object)string));
                    }
                    if (!bl3) break block25;
                    SDMSThread.doTrace(null, "Couldn't find parameter " + string + " for job " + sDMSSubmittedEntity.getId(systemEnvironment) + " (no import specified)", 1);
                }
            }
            try {
                string4 = this.getVariableExtendedValue(systemEnvironment, sDMSSubmittedEntity, sDMSSubmittedEntity, string, new HashSet(), bl, string2, bl2, stack, sDMSScope);
            }
            catch (NotFoundException notFoundException3) {
                if (bl) {
                    return emptyString;
                }
                string4 = null;
            }
            Boolean bl5 = (Boolean)systemEnvironment.tx.txData.get("ISDEFAULT");
            boolean bl6 = bl5 == null ? true : bl5;
            if (string4 == null || bl6) {
                String string5;
                long l4 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
                Long l5 = sDMSSubmittedEntity.getScopeId(systemEnvironment);
                SDMSScope sDMSScope2 = sDMSScope;
                if (l5 != null && sDMSScope == null) {
                    sDMSScope2 = SDMSScopeTable.getObject(systemEnvironment, l5);
                }
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l4);
                SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, sDMSSchedulingEntity.getFolderId(systemEnvironment), l4);
                try {
                    try {
                        if (sDMSScope2 == null) {
                            throw new NotFoundException();
                        }
                        string5 = sDMSScope2.getVariableValue(systemEnvironment, string);
                    }
                    catch (NotFoundException notFoundException4) {
                        string5 = this.getFolderVariableValue(systemEnvironment, sDMSSubmittedEntity, string, sDMSFolder, l4);
                    }
                }
                catch (NotFoundException notFoundException5) {
                    if (bl6 && string4 != null) {
                        return string4;
                    }
                    throw notFoundException5;
                }
                return string5;
            }
            return string4;
        }
    }

    private String getVariableValue(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSSubmittedEntity sDMSSubmittedEntity2, String string, HashSet hashSet, boolean bl, String string2, boolean bl2, Stack stack, SDMSScope sDMSScope) throws SDMSException {
        try {
            SDMSEntityVariable sDMSEntityVariable = SDMSEntityVariableTable.idx_smeId_Name_getUnique(systemEnvironment, new SDMSKey(sDMSSubmittedEntity.getId(systemEnvironment), (Comparable)((Object)string)));
            if (sDMSEntityVariable.getIsLocal(systemEnvironment).booleanValue()) {
                return this.getVariableExtendedValue(systemEnvironment, sDMSSubmittedEntity, sDMSSubmittedEntity2, string, hashSet, bl, string2, bl2, stack, sDMSScope);
            }
            Long l = sDMSEntityVariable.getEvLink(systemEnvironment);
            while (l != null) {
                sDMSEntityVariable = SDMSEntityVariableTable.getObject(systemEnvironment, l);
                l = sDMSEntityVariable.getEvLink(systemEnvironment);
            }
            systemEnvironment.tx.txData.put("ISDEFAULT", Boolean.FALSE);
            return this.parseAndSubstitute(systemEnvironment, sDMSSubmittedEntity, sDMSEntityVariable.getValue(systemEnvironment).substring(1), bl, string2, bl2, stack, -1L, sDMSScope);
        }
        catch (NotFoundException notFoundException) {
            String string3 = this.getVariableExtendedValue(systemEnvironment, sDMSSubmittedEntity, sDMSSubmittedEntity2, string, hashSet, bl, string2, bl2, stack, sDMSScope);
            return string3;
        }
    }

    private String getSpecialValue(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, String string, boolean bl, SDMSScope sDMSScope) throws SDMSException {
        Integer n = (Integer)specialNames.get(string);
        if (n != null) {
            int n2 = n;
            switch (n2) {
                case 1: {
                    return sDMSSubmittedEntity.getId(systemEnvironment).toString();
                }
                case 39: {
                    return sDMSSubmittedEntity.getSeId(systemEnvironment).toString();
                }
                case 2: {
                    return sDMSSubmittedEntity.getMasterId(systemEnvironment).toString();
                }
                case 3: {
                    return sDMSSubmittedEntity.getAccessKey(systemEnvironment).toString();
                }
                case 4: {
                    String string2 = sDMSSubmittedEntity.getExtPid(systemEnvironment);
                    if (string2 == null) {
                        return emptyString;
                    }
                    int n3 = string2.indexOf(64);
                    return string2.substring(0, n3);
                }
                case 5: {
                    String string3 = sDMSSubmittedEntity.getLogfile(systemEnvironment);
                    return string3 == null ? emptyString : string3;
                }
                case 6: {
                    String string4 = sDMSSubmittedEntity.getErrlogfile(systemEnvironment);
                    return string4 == null ? emptyString : string4;
                }
                case 40: {
                    String string5 = sDMSSubmittedEntity.getWorkdir(systemEnvironment);
                    return string5 == null ? emptyString : string5;
                }
                case 7: {
                    return SystemEnvironment.hostname;
                }
                case 8: {
                    return emptyString + SystemEnvironment.port;
                }
                case 9: {
                    long l = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
                    SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l);
                    return sDMSSchedulingEntity == null ? emptyString : sDMSSchedulingEntity.pathString(systemEnvironment, l);
                }
                case 10: {
                    String string6 = sDMSSubmittedEntity.getChildTag(systemEnvironment);
                    return string6 == null ? emptyString : string6;
                }
                case 11: {
                    Long l = sDMSSubmittedEntity.getTrId(systemEnvironment);
                    if (l == null) {
                        return emptyString;
                    }
                    SDMSTrigger sDMSTrigger = SDMSTriggerTable.getObject(systemEnvironment, l, sDMSSubmittedEntity.getSeVersion(systemEnvironment));
                    return sDMSTrigger.getName(systemEnvironment);
                }
                case 12: {
                    Long l = sDMSSubmittedEntity.getTrId(systemEnvironment);
                    if (l == null) {
                        return emptyString;
                    }
                    SDMSTrigger sDMSTrigger = SDMSTriggerTable.getObject(systemEnvironment, l, sDMSSubmittedEntity.getSeVersion(systemEnvironment));
                    return sDMSTrigger.getObjectTypeAsString(systemEnvironment);
                }
                case 20: {
                    Long l = sDMSSubmittedEntity.getBaseSmeId(systemEnvironment);
                    if (l == null) {
                        return emptyString;
                    }
                    SDMSSubmittedEntity sDMSSubmittedEntity2 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
                    long l2 = sDMSSubmittedEntity2.getSeVersion(systemEnvironment);
                    SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity2.getSeId(systemEnvironment), l2);
                    return sDMSSchedulingEntity.pathString(systemEnvironment, l2);
                }
                case 21: {
                    Long l = sDMSSubmittedEntity.getBaseSmeId(systemEnvironment);
                    if (l == null) {
                        return emptyString;
                    }
                    SDMSSubmittedEntity sDMSSubmittedEntity3 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
                    return sDMSSubmittedEntity3.getId(systemEnvironment).toString();
                }
                case 22: {
                    Long l = sDMSSubmittedEntity.getBaseSmeId(systemEnvironment);
                    if (l == null) {
                        return emptyString;
                    }
                    return l.toString();
                }
                case 16: {
                    Long l = sDMSSubmittedEntity.getReasonSmeId(systemEnvironment);
                    if (l == null) {
                        return emptyString;
                    }
                    SDMSSubmittedEntity sDMSSubmittedEntity4 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
                    long l3 = sDMSSubmittedEntity4.getSeVersion(systemEnvironment);
                    SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity4.getSeId(systemEnvironment), l3);
                    return sDMSSchedulingEntity.pathString(systemEnvironment, l3);
                }
                case 17: {
                    Long l = sDMSSubmittedEntity.getReasonSmeId(systemEnvironment);
                    if (l == null) {
                        return emptyString;
                    }
                    SDMSSubmittedEntity sDMSSubmittedEntity5 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
                    return sDMSSubmittedEntity5.getId(systemEnvironment).toString();
                }
                case 19: {
                    Long l = sDMSSubmittedEntity.getReasonSmeId(systemEnvironment);
                    if (l == null) {
                        return emptyString;
                    }
                    return l.toString();
                }
                case 13: {
                    Long l = sDMSSubmittedEntity.getFireSmeId(systemEnvironment);
                    if (l == null) {
                        return emptyString;
                    }
                    SDMSSubmittedEntity sDMSSubmittedEntity6 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
                    long l4 = sDMSSubmittedEntity6.getSeVersion(systemEnvironment);
                    SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity6.getSeId(systemEnvironment), l4);
                    return sDMSSchedulingEntity.pathString(systemEnvironment, l4);
                }
                case 14: {
                    Long l = sDMSSubmittedEntity.getFireSmeId(systemEnvironment);
                    if (l == null) {
                        return emptyString;
                    }
                    SDMSSubmittedEntity sDMSSubmittedEntity7 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
                    return sDMSSubmittedEntity7.getId(systemEnvironment).toString();
                }
                case 15: {
                    Long l = sDMSSubmittedEntity.getFireSmeId(systemEnvironment);
                    if (l == null) {
                        return emptyString;
                    }
                    return l.toString();
                }
                case 23: {
                    Integer n4 = sDMSSubmittedEntity.getTrSeq(systemEnvironment);
                    if (n4 == null) {
                        return emptyString;
                    }
                    return n4.toString();
                }
                case 24: {
                    Long l = sDMSSubmittedEntity.getTrId(systemEnvironment);
                    if (l == null) {
                        return emptyString;
                    }
                    SDMSTrigger sDMSTrigger = SDMSTriggerTable.getObject(systemEnvironment, l, sDMSSubmittedEntity.getSeVersion(systemEnvironment));
                    int n5 = sDMSTrigger.getObjectType(systemEnvironment);
                    if (n5 == 0) {
                        return emptyString;
                    }
                    Long l5 = sDMSSubmittedEntity.getTrSdIdOld(systemEnvironment);
                    SDMSResourceStateDefinition sDMSResourceStateDefinition = SDMSResourceStateDefinitionTable.getObject(systemEnvironment, l5, sDMSSubmittedEntity.getSeVersion(systemEnvironment));
                    return sDMSResourceStateDefinition.getName(systemEnvironment);
                }
                case 25: {
                    Long l = sDMSSubmittedEntity.getTrId(systemEnvironment);
                    if (l == null) {
                        return emptyString;
                    }
                    SDMSTrigger sDMSTrigger = SDMSTriggerTable.getObject(systemEnvironment, l, sDMSSubmittedEntity.getSeVersion(systemEnvironment));
                    int n6 = sDMSTrigger.getObjectType(systemEnvironment);
                    if (n6 == 0) {
                        Long l6 = sDMSSubmittedEntity.getTrSdIdNew(systemEnvironment);
                        if (l6 == null) {
                            return emptyString;
                        }
                        SDMSExitStateDefinition sDMSExitStateDefinition = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l6, sDMSSubmittedEntity.getSeVersion(systemEnvironment));
                        return sDMSExitStateDefinition.getName(systemEnvironment);
                    }
                    Long l7 = sDMSSubmittedEntity.getTrSdIdNew(systemEnvironment);
                    SDMSResourceStateDefinition sDMSResourceStateDefinition = SDMSResourceStateDefinitionTable.getObject(systemEnvironment, l7, sDMSSubmittedEntity.getSeVersion(systemEnvironment));
                    return sDMSResourceStateDefinition.getName(systemEnvironment);
                }
                case 42: {
                    Long l = sDMSSubmittedEntity.getWarnLink(systemEnvironment);
                    if (l == null) {
                        return emptyString;
                    }
                    if (!systemEnvironment.checkFeature("AUDITTRAIL")) {
                        return emptyString;
                    }
                    SDMSAuditTrail sDMSAuditTrail = SDMSAuditTrailTable.getObject(systemEnvironment, l);
                    return sDMSAuditTrail.getActionComment(systemEnvironment);
                }
                case 28: {
                    long l = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
                    SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l);
                    Integer n7 = sDMSSchedulingEntity.getExpectedRuntime(systemEnvironment);
                    if (n7 != null) {
                        return n7.toString();
                    }
                    return emptyString;
                }
                case 45: {
                    long l = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
                    SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l);
                    Integer n8 = sDMSSchedulingEntity.getExpectedFinaltime(systemEnvironment);
                    if (n8 != null) {
                        return n8.toString();
                    }
                    return emptyString;
                }
                case 29: {
                    Long l = sDMSSubmittedEntity.getJobEsdId(systemEnvironment);
                    if (l == null) {
                        return emptyString;
                    }
                    SDMSExitStateDefinition sDMSExitStateDefinition = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l, sDMSSubmittedEntity.getSeVersion(systemEnvironment));
                    return sDMSExitStateDefinition.getName(systemEnvironment);
                }
                case 30: {
                    Long l = sDMSSubmittedEntity.getFinalEsdId(systemEnvironment);
                    if (l == null) {
                        return emptyString;
                    }
                    SDMSExitStateDefinition sDMSExitStateDefinition = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l, sDMSSubmittedEntity.getSeVersion(systemEnvironment));
                    return sDMSExitStateDefinition.getName(systemEnvironment);
                }
                case 31: {
                    Long l = sDMSSubmittedEntity.getParentId(systemEnvironment);
                    if (l == null) {
                        return emptyString;
                    }
                    return l.toString();
                }
                case 32: {
                    return sDMSSubmittedEntity.getStateAsString(systemEnvironment);
                }
                case 33: {
                    Boolean bl2 = sDMSSubmittedEntity.getJobIsRestartable(systemEnvironment);
                    if (bl2.booleanValue()) {
                        return "1";
                    }
                    return "0";
                }
                case 26: {
                    Long l = sDMSSubmittedEntity.getSubmitTs(systemEnvironment);
                    if (l != null) {
                        if (bl) {
                            return emptyString + l / 1000L;
                        }
                        return myFormat.format(new Date(l));
                    }
                    return emptyString;
                }
                case 34: {
                    Long l = sDMSSubmittedEntity.getSyncTs(systemEnvironment);
                    if (l != null) {
                        if (bl) {
                            return emptyString + l / 1000L;
                        }
                        return myFormat.format(new Date(l));
                    }
                    return emptyString;
                }
                case 35: {
                    Long l = sDMSSubmittedEntity.getResourceTs(systemEnvironment);
                    if (l != null) {
                        if (bl) {
                            return emptyString + l / 1000L;
                        }
                        return myFormat.format(new Date(l));
                    }
                    return emptyString;
                }
                case 36: {
                    Long l = sDMSSubmittedEntity.getRunnableTs(systemEnvironment);
                    if (l != null) {
                        if (bl) {
                            return emptyString + l / 1000L;
                        }
                        return myFormat.format(new Date(l));
                    }
                    return emptyString;
                }
                case 27: {
                    Long l = sDMSSubmittedEntity.getStartTs(systemEnvironment);
                    if (l != null) {
                        if (bl) {
                            return emptyString + l / 1000L;
                        }
                        return myFormat.format(new Date(l));
                    }
                    return emptyString;
                }
                case 37: {
                    Long l = sDMSSubmittedEntity.getFinishTs(systemEnvironment);
                    if (l != null) {
                        if (bl) {
                            return emptyString + l / 1000L;
                        }
                        return myFormat.format(new Date(l));
                    }
                    return emptyString;
                }
                case 38: {
                    long l = System.currentTimeMillis();
                    if (bl) {
                        return emptyString + l / 1000L;
                    }
                    return myFormat.format(new Date(l));
                }
                case 41: {
                    int n9 = sDMSSubmittedEntity.getWarnCount(systemEnvironment);
                    String string7 = emptyString;
                    if (!systemEnvironment.checkFeature("AUDITTRAIL")) {
                        return emptyString;
                    }
                    if (n9 > 0) {
                        long l = 0L;
                        Vector vector = SDMSAuditTrailTable.idx_objectId.getVector(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment));
                        for (int i = 0; i < vector.size(); ++i) {
                            boolean bl3;
                            SDMSAuditTrail sDMSAuditTrail = (SDMSAuditTrail)vector.get(i);
                            long l8 = sDMSAuditTrail.getId(systemEnvironment);
                            if (l8 <= l || !(bl3 = sDMSAuditTrail.getIsSetWarning(systemEnvironment).booleanValue())) continue;
                            string7 = sDMSAuditTrail.getActionComment(systemEnvironment);
                        }
                    }
                    return string7;
                }
                case 43: {
                    return emptyString + sDMSSubmittedEntity.getRerunSeq(systemEnvironment);
                }
                case 44: {
                    Long l = sDMSSubmittedEntity.getScopeId(systemEnvironment);
                    SDMSScope sDMSScope2 = l != null ? SDMSScopeTable.getObject(systemEnvironment, l) : sDMSScope;
                    return sDMSScope2 == null ? emptyString : sDMSScope2.pathString(systemEnvironment);
                }
                case 46: {
                    return sDMSSubmittedEntity.evaluateTime(systemEnvironment, sDMSSubmittedEntity.getIdleTime(systemEnvironment), sDMSSubmittedEntity.getIdleTs(systemEnvironment), -1).toString();
                }
                case 47: {
                    return sDMSSubmittedEntity.evaluateTime(systemEnvironment, sDMSSubmittedEntity.getDependencyWaitTime(systemEnvironment), sDMSSubmittedEntity.getStatisticTs(systemEnvironment), 1).toString();
                }
                case 48: {
                    return sDMSSubmittedEntity.evaluateTime(systemEnvironment, sDMSSubmittedEntity.getSuspendTime(systemEnvironment), sDMSSubmittedEntity.getStatisticTs(systemEnvironment), 2).toString();
                }
                case 49: {
                    return sDMSSubmittedEntity.evaluateTime(systemEnvironment, sDMSSubmittedEntity.getSyncTime(systemEnvironment), sDMSSubmittedEntity.getStatisticTs(systemEnvironment), 3).toString();
                }
                case 50: {
                    return sDMSSubmittedEntity.evaluateTime(systemEnvironment, sDMSSubmittedEntity.getResourceTime(systemEnvironment), sDMSSubmittedEntity.getStatisticTs(systemEnvironment), 4).toString();
                }
                case 51: {
                    return sDMSSubmittedEntity.evaluateTime(systemEnvironment, sDMSSubmittedEntity.getJobserverTime(systemEnvironment), sDMSSubmittedEntity.getStatisticTs(systemEnvironment), 5).toString();
                }
                case 52: {
                    return sDMSSubmittedEntity.evaluateTime(systemEnvironment, sDMSSubmittedEntity.getRestartableTime(systemEnvironment), sDMSSubmittedEntity.getStatisticTs(systemEnvironment), 6).toString();
                }
                case 53: {
                    return sDMSSubmittedEntity.evaluateTime(systemEnvironment, sDMSSubmittedEntity.getChildWaitTime(systemEnvironment), sDMSSubmittedEntity.getStatisticTs(systemEnvironment), 7).toString();
                }
                case 54: 
                case 55: 
                case 56: {
                    Number number = sDMSSubmittedEntity.evaluateTime(systemEnvironment, sDMSSubmittedEntity.getDependencyWaitTime(systemEnvironment), sDMSSubmittedEntity.getStatisticTs(systemEnvironment), 1);
                    Comparable comparable = sDMSSubmittedEntity.getFinalTs(systemEnvironment);
                    int n10 = comparable != null ? (int)(((Long)comparable - sDMSSubmittedEntity.getSubmitTs(systemEnvironment)) / 1000L) : (int)((systemEnvironment.cEnv.last() - sDMSSubmittedEntity.getSubmitTs(systemEnvironment)) / 1000L);
                    int n11 = n10 - (Integer)number;
                    switch (n2) {
                        case 54: {
                            return new Integer(n11).toString();
                        }
                        case 55: 
                        case 56: {
                            Integer n12 = sDMSSubmittedEntity.evaluateTime(systemEnvironment, sDMSSubmittedEntity.getIdleTime(systemEnvironment), sDMSSubmittedEntity.getIdleTs(systemEnvironment), -1);
                            if (n2 == 55) {
                                return new Integer(n11 - n12).toString();
                            }
                            if (n11 == 0) {
                                return emptyString;
                            }
                            return new Integer(n12 * 100 / n11).toString();
                        }
                    }
                }
                case 57: {
                    Number number = sDMSSubmittedEntity.getCreatorUId(systemEnvironment);
                    Comparable comparable = SDMSUserTable.getObject(systemEnvironment, (Long)number);
                    return ((SDMSUserProxyGeneric)comparable).getName(systemEnvironment);
                }
                case 58: {
                    Long l = sDMSSubmittedEntity.getOwnerId(systemEnvironment);
                    SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l);
                    return sDMSGroup.getName(systemEnvironment);
                }
                case 59: {
                    long l = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
                    SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l);
                    SDMSNamedEnvironment sDMSNamedEnvironment = SDMSNamedEnvironmentTable.getObject(systemEnvironment, sDMSSchedulingEntity.getNeId(systemEnvironment), l);
                    return sDMSNamedEnvironment.getName(systemEnvironment);
                }
                case 60: {
                    long l = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
                    SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l);
                    SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSSchedulingEntity.getOwnerId(systemEnvironment));
                    return sDMSGroup.getName(systemEnvironment);
                }
            }
        } else {
            String string8;
            long l = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
            Long l9 = sDMSSubmittedEntity.getScopeId(systemEnvironment);
            SDMSScope sDMSScope3 = l9 != null ? SDMSScopeTable.getObject(systemEnvironment, l9) : sDMSScope;
            try {
                string8 = sDMSScope3 == null ? emptyString : sDMSScope3.getVariableValue(systemEnvironment, string, l);
            }
            catch (NotFoundException notFoundException) {
                return emptyString;
            }
            return string8;
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "03208090953", "Unknown special Parameter : $1", (Object)string));
    }

    private String getVariableExtendedValue(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSSubmittedEntity sDMSSubmittedEntity2, String string, HashSet hashSet, boolean bl, String string2, boolean bl2, Stack stack, SDMSScope sDMSScope) throws SDMSException {
        SDMSParameterDefinition sDMSParameterDefinition;
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        long l2 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        try {
            sDMSParameterDefinition = SDMSParameterDefinitionTable.idx_seId_Name_getUnique(systemEnvironment, new SDMSKey(sDMSSubmittedEntity.getSeId(systemEnvironment), (Comparable)((Object)string)), l2);
            if (!hashSet.add(new SDMSKey(sDMSSubmittedEntity.getId(systemEnvironment), sDMSParameterDefinition.getId(systemEnvironment)))) {
                Long l3 = sDMSSubmittedEntity.getSeId(systemEnvironment);
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l3, l2);
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03208292044", "Run into a loop while trying to resolve variable $1 of $2", (Object)string, (Object)sDMSSchedulingEntity.pathString(systemEnvironment, l2)));
            }
            if (sDMSParameterDefinition.getIsLocal(systemEnvironment).booleanValue() && !l.equals(sDMSSubmittedEntity2.getId(systemEnvironment))) {
                throw new NotFoundException("local");
            }
        }
        catch (NotFoundException notFoundException) {
            if (bl) {
                return emptyString;
            }
            Long l4 = sDMSSubmittedEntity.getParentId(systemEnvironment);
            if (l4 == null) {
                throw new NotFoundException(new SDMSMessage(systemEnvironment, "03208100013", "Couldn't resolve the variable $1", (Object)string));
            }
            SDMSSubmittedEntity sDMSSubmittedEntity3 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l4);
            return this.getVariableValue(systemEnvironment, sDMSSubmittedEntity3, sDMSSubmittedEntity2, string, hashSet, bl, string2, bl2, stack, sDMSScope);
        }
        int n = sDMSParameterDefinition.getType(systemEnvironment);
        String string3 = sDMSParameterDefinition.getDefaultValue(systemEnvironment);
        switch (n) {
            case 50: {
                Long l5 = sDMSSubmittedEntity.getParentId(systemEnvironment);
                try {
                    if (l5 == null) {
                        throw new NotFoundException(new SDMSMessage(systemEnvironment, "03208091742", "Couldn't resolve the mandatory parameter $1", (Object)string));
                    }
                    SDMSSubmittedEntity sDMSSubmittedEntity4 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l5);
                    return this.getVariableValue(systemEnvironment, sDMSSubmittedEntity4, sDMSSubmittedEntity2, string, hashSet, bl, string2, bl2, stack, sDMSScope);
                }
                catch (NotFoundException notFoundException) {
                    if (string3 != null) {
                        return this.parseAndSubstitute(systemEnvironment, sDMSSubmittedEntity, string3.substring(1), false, string2, bl2, stack, -1L);
                    }
                    throw notFoundException;
                }
            }
            case 70: {
                Long l6 = sDMSSubmittedEntity.getParentId(systemEnvironment);
                try {
                    if (l6 == null) {
                        throw new NotFoundException(new SDMSMessage(systemEnvironment, "03304161119", "Couldn't resolve the import parameter $1", (Object)string));
                    }
                    SDMSSubmittedEntity sDMSSubmittedEntity5 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l6);
                    return this.getVariableValue(systemEnvironment, sDMSSubmittedEntity5, sDMSSubmittedEntity2, string, hashSet, bl, string2, bl2, stack, sDMSScope);
                }
                catch (NotFoundException notFoundException) {
                    if (string3 != null) {
                        return this.parseAndSubstitute(systemEnvironment, sDMSSubmittedEntity, string3.substring(1), false, string2, bl2, stack, -1L);
                    }
                    throw notFoundException;
                }
            }
            case 40: {
                if (string3 == null) {
                    string3 = "=";
                }
                systemEnvironment.tx.txData.put("ISDEFAULT", Boolean.FALSE);
                return this.parseAndSubstitute(systemEnvironment, sDMSSubmittedEntity, string3.substring(1), false, string2, bl2, stack, -1L);
            }
            case 30: {
                systemEnvironment.tx.txData.put("ISDEFAULT", Boolean.FALSE);
                return this.parseAndSubstitute(systemEnvironment, sDMSSubmittedEntity, string3.substring(1), false, string2, bl2, stack, -1L);
            }
            case 10: {
                SDMSParameterDefinition sDMSParameterDefinition2 = SDMSParameterDefinitionTable.getObject(systemEnvironment, sDMSParameterDefinition.getLinkPdId(systemEnvironment), l2);
                Long l7 = sDMSParameterDefinition2.getSeId(systemEnvironment);
                String string4 = sDMSParameterDefinition2.getName(systemEnvironment);
                SDMSSubmittedEntity sDMSSubmittedEntity6 = l7.equals(sDMSSubmittedEntity.getSeId(systemEnvironment)) ? sDMSSubmittedEntity : sDMSSubmittedEntity.getNearestSubmittedEntity(systemEnvironment, l7, false, false, true);
                if (sDMSSubmittedEntity6 == null) {
                    throw new NotFoundException(new SDMSMessage(systemEnvironment, "03304161131", "Couldn't resolve reference $1", (Object)SDMSSchedulingEntityTable.getObject(systemEnvironment, l7, l2).pathString(systemEnvironment)));
                }
                return this.getVariableValue(systemEnvironment, sDMSSubmittedEntity6, sDMSSubmittedEntity2, string4, hashSet, bl, string2, bl2, stack, sDMSScope);
            }
            case 20: {
                SDMSParameterDefinition sDMSParameterDefinition3 = SDMSParameterDefinitionTable.getObject(systemEnvironment, sDMSParameterDefinition.getLinkPdId(systemEnvironment), l2);
                Long l8 = sDMSParameterDefinition3.getSeId(systemEnvironment);
                String string5 = sDMSParameterDefinition3.getName(systemEnvironment);
                SDMSSubmittedEntity sDMSSubmittedEntity7 = sDMSSubmittedEntity.getChildSubmittedEntity(systemEnvironment, l8, null, sDMSSubmittedEntity, false);
                if (sDMSSubmittedEntity7 == null) {
                    throw new NotFoundException(new SDMSMessage(systemEnvironment, "03304161134", "Couldn't resolve child reference $1", (Object)SDMSSchedulingEntityTable.getObject(systemEnvironment, l8, l2).pathString(systemEnvironment)));
                }
                return this.getVariableValue(systemEnvironment, sDMSSubmittedEntity7, sDMSSubmittedEntity2, string5, hashSet, bl, string2, bl2, stack, sDMSScope);
            }
            case 91: {
                SDMSResource sDMSResource;
                SDMSParameterDefinition sDMSParameterDefinition4 = SDMSParameterDefinitionTable.getObject(systemEnvironment, sDMSParameterDefinition.getLinkPdId(systemEnvironment), l2);
                Long l9 = sDMSParameterDefinition4.getSeId(systemEnvironment);
                String string6 = sDMSParameterDefinition4.getName(systemEnvironment);
                HashMap hashMap = null;
                if (sDMSScope == null) {
                    Vector vector = SDMSResourceAllocationTable.idx_smeId_nrId.getVector(systemEnvironment, new SDMSKey(l, l9));
                    if (vector.size() > 1) {
                        throw new NotFoundException(new SDMSMessage(systemEnvironment, "03409222313", "Couldn't resolve reference $1 unambigiously", (Object)SDMSNamedResourceTable.getObject(systemEnvironment, l9, l2).pathString(systemEnvironment)));
                    }
                    if (vector.size() == 0) {
                        Comparable comparable;
                        Long l10 = sDMSSubmittedEntity.getScopeId(systemEnvironment);
                        if (l10 == null) {
                            throw new NotFoundException(new SDMSMessage(systemEnvironment, "03711081546", "Couldn't resolve reference $1 unambigiously", (Object)SDMSNamedResourceTable.getObject(systemEnvironment, l9, l2).pathString(systemEnvironment)));
                        }
                        try {
                            comparable = SDMSnpSrvrSRFootprintTable.idx_sId_getUnique(systemEnvironment, l10);
                            hashMap = comparable.getFp(systemEnvironment);
                        }
                        catch (NotFoundException notFoundException) {
                            SDMSScope sDMSScope2 = SDMSScopeTable.getObject(systemEnvironment, l10);
                            hashMap = SystemEnvironment.sched.getScopeFootprint(systemEnvironment, sDMSScope2);
                        }
                        comparable = (Long)hashMap.get(l9);
                        sDMSResource = SDMSResourceTable.getObject(systemEnvironment, (Long)comparable);
                    } else {
                        SDMSResourceAllocation sDMSResourceAllocation = (SDMSResourceAllocation)vector.get(0);
                        sDMSResource = SDMSResourceTable.getObject(systemEnvironment, sDMSResourceAllocation.getRId(systemEnvironment));
                    }
                } else {
                    Comparable comparable;
                    try {
                        comparable = SDMSnpSrvrSRFootprintTable.idx_sId_getUnique(systemEnvironment, sDMSScope.getId(systemEnvironment));
                        hashMap = comparable.getFp(systemEnvironment);
                    }
                    catch (NotFoundException notFoundException) {
                        hashMap = SystemEnvironment.sched.getScopeFootprint(systemEnvironment, sDMSScope);
                    }
                    comparable = (Long)hashMap.get(l9);
                    if (comparable == null) {
                        throw new NotFoundException(new SDMSMessage(systemEnvironment, "03711091158", "Couldn't resolve reference $1 unambigiously", (Object)SDMSNamedResourceTable.getObject(systemEnvironment, l9, l2).pathString(systemEnvironment)));
                    }
                    sDMSResource = SDMSResourceTable.getObject(systemEnvironment, (Long)comparable);
                }
                return sDMSResource.getVariableValue(systemEnvironment, string6, sDMSSubmittedEntity);
            }
            case 60: {
                int n2;
                double d = 0.0;
                double d2 = Double.MIN_VALUE;
                double d3 = Double.MAX_VALUE;
                int n3 = 0;
                Vector vector = SDMSSubmittedEntityTable.idx_parentId.getVector(systemEnvironment, l);
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    String string7;
                    SDMSSubmittedEntity sDMSSubmittedEntity8 = (SDMSSubmittedEntity)vector.get(n2);
                    try {
                        Long l11 = sDMSSubmittedEntity2.getId(systemEnvironment);
                        Long l12 = sDMSSubmittedEntity8.getId(systemEnvironment);
                        String string8 = string3.substring(1);
                        if (l11 != null && l11.equals(l12) && string.equals(string8)) {
                            Long l13 = sDMSSubmittedEntity2.getSeId(systemEnvironment);
                            long l14 = sDMSSubmittedEntity2.getSeVersion(systemEnvironment);
                            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l13, l14);
                            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03805140836", "Run into a loop while trying to resolve variable $1 of job $2", (Object)string8, (Object)sDMSSchedulingEntity.pathString(systemEnvironment, l14)));
                        }
                        string7 = l11 != null && l11.equals(l12) && sDMSParameterDefinition != null ? this.getVariableValue(systemEnvironment, sDMSSubmittedEntity8, sDMSSubmittedEntity2, string8, hashSet, true, string2, bl2, stack, sDMSScope) : sDMSSubmittedEntity8.getVariableValue(systemEnvironment, string8, true, "LIBERAL", bl2, sDMSScope);
                    }
                    catch (NotFoundException notFoundException) {
                        continue;
                    }
                    try {
                        double d4 = Double.parseDouble(string7);
                        d += d4;
                        ++n3;
                        if (d2 < d4) {
                            d2 = d4;
                        }
                        if (!(d3 > d4)) continue;
                        d3 = d4;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                systemEnvironment.tx.txData.put("ISDEFAULT", Boolean.FALSE);
                n2 = sDMSParameterDefinition.getAggFunction(systemEnvironment);
                switch (n2) {
                    case 61: {
                        return n3 == 0 ? emptyString : new Double(d / (double)n3).toString();
                    }
                    case 62: {
                        return new Integer(n3).toString();
                    }
                    case 63: {
                        return new Double(d3).toString();
                    }
                    case 64: {
                        return new Double(d2).toString();
                    }
                    case 65: {
                        return new Double(d).toString();
                    }
                }
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "03208100006", "Fall through while resolving a parameter $1 of $2", (Object)string, (Object)SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), sDMSSubmittedEntity.getSeVersion(systemEnvironment)).pathString(systemEnvironment, sDMSSubmittedEntity.getSeVersion(systemEnvironment))));
    }

    static {
        specialNames.put(S_JOBID, new Integer(1));
        specialNames.put(S_SEID, new Integer(39));
        specialNames.put(S_MASTERID, new Integer(2));
        specialNames.put(S_KEY, new Integer(3));
        specialNames.put(S_PID, new Integer(4));
        specialNames.put(S_LOGFILE, new Integer(5));
        specialNames.put(S_ERRORLOG, new Integer(6));
        specialNames.put(S_WORKDIR, new Integer(40));
        specialNames.put(S_SDMSHOST, new Integer(7));
        specialNames.put(S_SDMSPORT, new Integer(8));
        specialNames.put(S_JOBNAME, new Integer(9));
        specialNames.put(S_JOBTAG, new Integer(10));
        specialNames.put(S_TRNAME, new Integer(11));
        specialNames.put(S_TRTYPE, new Integer(12));
        specialNames.put(S_TRORIGIN, new Integer(13));
        specialNames.put(S_TRORIGINID, new Integer(14));
        specialNames.put(S_TRORIGINJOBID, new Integer(15));
        specialNames.put(S_TRREASON, new Integer(16));
        specialNames.put(S_TRREASONID, new Integer(17));
        specialNames.put(S_TRREASONJOBID, new Integer(19));
        specialNames.put(S_TRBASE, new Integer(20));
        specialNames.put(S_TRBASEID, new Integer(21));
        specialNames.put(S_TRBASEJOBID, new Integer(22));
        specialNames.put(S_TRSEQ, new Integer(23));
        specialNames.put(S_TROSTATE, new Integer(24));
        specialNames.put(S_TRNSTATE, new Integer(25));
        specialNames.put(S_TRWARNING, new Integer(42));
        specialNames.put(S_SUBMITTS, new Integer(26));
        specialNames.put(S_STARTTS, new Integer(27));
        specialNames.put(S_EXPRUNTIME, new Integer(28));
        specialNames.put(S_EXPFINALTIME, new Integer(45));
        specialNames.put(S_JOBSTATE, new Integer(29));
        specialNames.put(S_MERGEDSTATE, new Integer(30));
        specialNames.put(S_PARENTID, new Integer(31));
        specialNames.put(S_STATE, new Integer(32));
        specialNames.put(S_ISRESTARTABLE, new Integer(33));
        specialNames.put(S_SYNCTS, new Integer(34));
        specialNames.put(S_RESOURCETS, new Integer(35));
        specialNames.put(S_RUNNABLETS, new Integer(36));
        specialNames.put(S_FINISHTS, new Integer(37));
        specialNames.put(S_SYSDATE, new Integer(38));
        specialNames.put(S_WARNING, new Integer(41));
        specialNames.put(S_RERUNSEQ, new Integer(43));
        specialNames.put(S_SCOPENAME, new Integer(44));
        specialNames.put(S_IDLE_TIME, new Integer(46));
        specialNames.put(S_SUSPEND_TIME, new Integer(48));
        specialNames.put(S_DEPENDENCY_WAIT_TIME, new Integer(47));
        specialNames.put(S_SYNC_TIME, new Integer(49));
        specialNames.put(S_RESOURCE_TIME, new Integer(50));
        specialNames.put(S_JOBSERVER_TIME, new Integer(51));
        specialNames.put(S_RESTARTABLE_TIME, new Integer(52));
        specialNames.put(S_CHILD_WAIT_TIME, new Integer(53));
        specialNames.put(S_PROCESS_TIME, new Integer(54));
        specialNames.put(S_ACTIVE_TIME, new Integer(55));
        specialNames.put(S_IDLE_PCT, new Integer(56));
        specialNames.put(S_SUBMITTER, new Integer(57));
        specialNames.put(S_SUBMITGROUP, new Integer(58));
        specialNames.put(S_ENVIRONMENT, new Integer(59));
        specialNames.put(S_SEOWNER, new Integer(60));
    }
}

