/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.util.SDMSThread;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Stack;

public abstract class VariableResolver {
    public static final String __version = "@(#) $Id: VariableResolver.java,v 2.5.4.1 2013/03/14 10:25:28 ronald Exp $";
    protected static final SimpleDateFormat myFormat = new SimpleDateFormat("yyyyMMddHHmmss", SystemEnvironment.systemLocale);
    protected static final String emptyString = new String("");
    protected static final char[] validChars;
    protected static final char[] eValidChars;

    public String parseAndSubstitute(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, String string, boolean bl, String string2, boolean bl2, Stack stack, long l) throws SDMSException {
        return this.parseAndSubstitute(systemEnvironment, sDMSProxy, string, bl, string2, bl2, stack, l, null);
    }

    public String parseAndSubstitute(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, String string, boolean bl, String string2, boolean bl2, Stack stack, long l, SDMSScope sDMSScope) throws SDMSException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = "BICSUITE_PRAGMA_VPFX:".length();
        boolean bl3 = string.indexOf("BICSUITE_PRAGMA_PBS") != -1;
        int n2 = string.indexOf("BICSUITE_PRAGMA_VPFX:");
        char c = '$';
        if (n2 != -1) {
            c = string.charAt(n2 + n);
            string = string.substring(0, n2 + n) + "\\" + string.substring(n2 + n);
        }
        char[] cArray = string.toCharArray();
        boolean bl4 = false;
        for (int i = 0; i < cArray.length; ++i) {
            char c2 = cArray[i];
            if (bl4 && bl3 && c2 != c) {
                stringBuffer.append('\\');
                bl4 = false;
            }
            if (bl4) {
                if (!bl3 && c2 != '\\' && c2 != c) {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c2);
                bl4 = false;
                continue;
            }
            if (c2 == c) {
                int n3 = this.readVar(systemEnvironment, sDMSProxy, cArray, i, bl, string2, bl2, stringBuffer, stack, l, sDMSScope);
                if (n3 == i) {
                    stringBuffer.append(c2);
                    continue;
                }
                i = n3;
                continue;
            }
            if (c2 == '\\') {
                bl4 = true;
                continue;
            }
            stringBuffer.append(c2);
        }
        if (bl4) {
            stringBuffer.append('\\');
        }
        return stringBuffer.toString();
    }

    private int readVar(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, char[] cArray, int n, boolean bl, String string, boolean bl2, StringBuffer stringBuffer, Stack stack, long l, SDMSScope sDMSScope) throws SDMSException {
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = n + 1;
        boolean bl3 = false;
        boolean bl4 = false;
        int n3 = cArray.length;
        Long l2 = sDMSProxy.getId(systemEnvironment);
        char[] cArray2 = validChars;
        if (cArray[n2] == '{') {
            bl3 = true;
            if (cArray[++n2] == '\'') {
                ++n2;
                bl4 = true;
                cArray2 = eValidChars;
            }
        }
        while (n2 < n3 && (bl3 || Arrays.binarySearch(cArray2, cArray[n2]) >= 0)) {
            if (bl3 && (!bl4 && cArray[n2] == '}' || bl4 && cArray[n2] == '\'')) {
                if (bl4) {
                    if (n2 >= n3 - 1) {
                        SDMSThread.doTrace(systemEnvironment.cEnv, "Error parsing parameter value of " + l2 + ", unterminated Parameter reference", 1);
                        if (SystemEnvironment.parameterSyntaxHandling == 0) {
                            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03303071558", "Syntax error: unterminated Parameter reference"));
                        }
                        return n;
                    }
                    if (cArray[n2 + 1] == '}') {
                        ++n2;
                    } else {
                        SDMSThread.doTrace(systemEnvironment.cEnv, "Error parsing parameter value of " + l2 + ", unexpected character '" + cArray[n2 + 1] + "'", 1);
                        if (SystemEnvironment.parameterSyntaxHandling == 0) {
                            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03303071558", "Syntax error: unexpected character '" + cArray[n2 + 1] + "', expected a closing curly brace"));
                        }
                        return n;
                    }
                }
                ++n2;
                break;
            }
            if (bl3 && Arrays.binarySearch(cArray2, cArray[n2]) < 0) {
                SDMSThread.doTrace(systemEnvironment.cEnv, "Error parsing parameter value of " + l2 + ", unexpected character '" + cArray[n2] + "'", 1);
                if (SystemEnvironment.parameterSyntaxHandling == 0) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03303071558", "Syntax error: invalid character '" + cArray[n2] + "' in parameter name"));
                }
                return n;
            }
            stringBuffer2.append(cArray[n2]);
            ++n2;
        }
        --n2;
        String string2 = bl4 ? stringBuffer2.toString() : stringBuffer2.toString().toUpperCase();
        SDMSKey sDMSKey = new SDMSKey(l2, (Comparable)((Object)string2));
        if (stack.search(sDMSKey) >= 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603010059", "Run into a loop while trying to resolve variable $1", (Object)string2));
        }
        stack.push(sDMSKey);
        boolean bl5 = true;
        Boolean bl6 = (Boolean)systemEnvironment.tx.txData.get("ISDEFAULT");
        systemEnvironment.tx.txData.remove("ISDEFAULT");
        try {
            String string3 = this.getInternalVariableValue(systemEnvironment, sDMSProxy, string2, bl, string, bl2, stack, l, sDMSScope);
            stringBuffer.append(string3);
        }
        catch (SDMSException sDMSException) {
            if (SystemEnvironment.unresolvedParameterHandling == 0) {
                throw sDMSException;
            }
            bl5 = false;
        }
        if (bl6 != null) {
            systemEnvironment.tx.txData.put("ISDEFAULT", bl6);
        }
        stack.pop();
        if (!bl5 && SystemEnvironment.unresolvedParameterHandling == 2) {
            return n;
        }
        return n2;
    }

    protected String getInternalVariableValue(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, String string, boolean bl, String string2, boolean bl2, Stack stack, long l) throws SDMSException {
        return this.getInternalVariableValue(systemEnvironment, sDMSProxy, string, bl, string2, bl2, stack, l, null);
    }

    protected abstract String getInternalVariableValue(SystemEnvironment var1, SDMSProxy var2, String var3, boolean var4, String var5, boolean var6, Stack var7, long var8, SDMSScope var10) throws SDMSException;

    public String getVariableValue(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, String string, boolean bl, String string2, boolean bl2, SDMSScope sDMSScope) throws SDMSException {
        return this.getVariableValue(systemEnvironment, sDMSProxy, string, bl, string2, bl2, -1L, sDMSScope);
    }

    public String getVariableValue(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, String string, long l) throws SDMSException {
        return this.getVariableValue(systemEnvironment, sDMSProxy, string, false, "DEFAULT", false, l, null);
    }

    public String getVariableValue(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, String string) throws SDMSException {
        return this.getVariableValue(systemEnvironment, sDMSProxy, string, false, "DEFAULT", false, -1L, null);
    }

    public String getVariableValue(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, String string, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        return this.getVariableValue(systemEnvironment, sDMSProxy, string, false, "DEFAULT", false, -1L, null, sDMSSubmittedEntity);
    }

    protected abstract String getVariableValue(SystemEnvironment var1, SDMSProxy var2, String var3, boolean var4, String var5, boolean var6, long var7, SDMSScope var9) throws SDMSException;

    protected String getVariableValue(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, String string, boolean bl, String string2, boolean bl2, long l, SDMSScope sDMSScope, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        return this.getVariableValue(systemEnvironment, sDMSProxy, string, bl, string2, bl2, l, sDMSScope);
    }

    static {
        char[] cArray = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '@', '_', '#', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        char[] cArray2 = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '@', '_', '#', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '!', '%', '&', '(', ')', '*', '+', ',', '-', '/', ';', '<', '=', '>', '?', '|'};
        Arrays.sort(cArray);
        Arrays.sort(cArray2);
        validChars = cArray;
        eValidChars = cArray2;
    }
}

