-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SUBMITTED_ENTITY_STATS (
    ID                             bigint NOT NULL
    , SME_ID                         bigint          NOT NULL
    , RERUN_SEQ                      integer         NOT NULL
    , SCOPE_ID                       bigint              NULL
    , JOB_ESD_ID                     bigint              NULL
    , EXIT_CODE                      integer             NULL
    , COMMANDLINE                    varchar(512)        NULL
    , WORKDIR                        varchar(512)        NULL
    , LOGFILE                        varchar(512)        NULL
    , ERRLOGFILE                     varchar(512)        NULL
    , EXTPID                         varchar(32)         NULL
    , SYNC_TS                        bigint              NULL
    , RESOURCE_TS                    bigint              NULL
    , RUNNABLE_TS                    bigint              NULL
    , START_TS                       bigint              NULL
    , FINISH_TS                      bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_SUBMITTED_ENTITY_STATS
ON SUBMITTED_ENTITY_STATS(ID);
CREATE VIEW SCI_SUBMITTED_ENTITY_STATS AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , RERUN_SEQ                      AS RERUN_SEQ
    , SCOPE_ID                       AS SCOPE_ID
    , JOB_ESD_ID                     AS JOB_ESD_ID
    , EXIT_CODE                      AS EXIT_CODE
    , COMMANDLINE                    AS COMMANDLINE
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , ERRLOGFILE                     AS ERRLOGFILE
    , EXTPID                         AS EXTPID
    , timestamp('1970-01-01-00.00.00') + int(mod(SYNC_TS, 1125899906842624)/1000) seconds AS SYNC_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(RESOURCE_TS, 1125899906842624)/1000) seconds AS RESOURCE_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(RUNNABLE_TS, 1125899906842624)/1000) seconds AS RUNNABLE_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(START_TS, 1125899906842624)/1000) seconds AS START_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(FINISH_TS, 1125899906842624)/1000) seconds AS FINISH_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM SUBMITTED_ENTITY_STATS;
CREATE TABLE ARC_SUBMITTED_ENTITY_STATS (
    ID                             bigint NOT NULL
    , SME_ID                         bigint           NULL
    , RERUN_SEQ                      integer          NULL
    , SCOPE_ID                       bigint           NULL
    , JOB_ESD_ID                     bigint           NULL
    , EXIT_CODE                      integer          NULL
    , COMMANDLINE                    varchar(512)     NULL
    , WORKDIR                        varchar(512)     NULL
    , LOGFILE                        varchar(512)     NULL
    , ERRLOGFILE                     varchar(512)     NULL
    , EXTPID                         varchar(32)      NULL
    , SYNC_TS                        bigint           NULL
    , RESOURCE_TS                    bigint           NULL
    , RUNNABLE_TS                    bigint           NULL
    , START_TS                       bigint           NULL
    , FINISH_TS                      bigint           NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
