-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE POOLED_RESOURCE (
    ID                             bigint NOT NULL
    , P_ID                           bigint          NOT NULL
    , R_ID                           bigint          NOT NULL
    , IS_POOL                        integer         NOT NULL
    , IS_MANAGED                     integer         NOT NULL
    , NOM_PCT                        int8            NOT NULL
    , FREE_PCT                       int8            NOT NULL
    , MIN_PCT                        int8            NOT NULL
    , MAX_PCT                        int8            NOT NULL
    , ACT_IS_MANAGED                 integer         NOT NULL
    , ACT_NOM_PCT                    int8            NOT NULL
    , ACT_FREE_PCT                   int8            NOT NULL
    , ACT_MIN_PCT                    int8            NOT NULL
    , ACT_MAX_PCT                    int8            NOT NULL
    , TARGET_AMOUNT                  int8            NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_POOLED_RESOURCE
ON POOLED_RESOURCE(ID);
CREATE VIEW SCI_POOLED_RESOURCE (ID,P_ID,R_ID,IS_POOL,IS_MANAGED,NOM_PCT,FREE_PCT,MIN_PCT,MAX_PCT,ACT_IS_MANAGED,ACT_NOM_PCT,ACT_FREE_PCT,ACT_MIN_PCT,ACT_MAX_PCT,TARGET_AMOUNT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , P_ID                           AS P_ID
    , R_ID                           AS R_ID
    , DECODE (IS_POOL, 1, 'TRUE', 0, 'FALSE') AS IS_POOL
    , DECODE (IS_MANAGED, 1, 'TRUE', 0, 'FALSE') AS IS_MANAGED
    , NOM_PCT                        AS NOM_PCT
    , FREE_PCT                       AS FREE_PCT
    , MIN_PCT                        AS MIN_PCT
    , MAX_PCT                        AS MAX_PCT
    , DECODE (ACT_IS_MANAGED, 1, 'TRUE', 0, 'FALSE') AS ACT_IS_MANAGED
    , ACT_NOM_PCT                    AS ACT_NOM_PCT
    , ACT_FREE_PCT                   AS ACT_FREE_PCT
    , ACT_MIN_PCT                    AS ACT_MIN_PCT
    , ACT_MAX_PCT                    AS ACT_MAX_PCT
    , TARGET_AMOUNT                  AS TARGET_AMOUNT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM POOLED_RESOURCE;
