-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SCHEDULING_ENTITY (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , FOLDER_ID                      bigint          NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , TYPE                           int8            NOT NULL
    , RUN_PROGRAM                    lvarchar(512)       NULL
    , RERUN_PROGRAM                  lvarchar(512)       NULL
    , KILL_PROGRAM                   lvarchar(512)       NULL
    , WORKDIR                        lvarchar(512)       NULL
    , LOGFILE                        lvarchar(512)       NULL
    , TRUNC_LOG                      integer             NULL
    , ERRLOGFILE                     lvarchar(512)       NULL
    , TRUNC_ERRLOG                   integer             NULL
    , EXPECTED_RUNTIME               int8                NULL
    , EXPECTED_FINALTIME             int8                NULL
    , GET_EXPECTED_RUNTIME           lvarchar(32)        NULL
    , PRIORITY                       int8            NOT NULL
    , MIN_PRIORITY                   int8                NULL
    , AGING_AMOUNT                   int8                NULL
    , AGING_BASE                     int8                NULL
    , SUBMIT_SUSPENDED               integer         NOT NULL
    , RESUME_AT                      lvarchar(20)        NULL
    , RESUME_IN                      int8                NULL
    , RESUME_BASE                    int8                NULL
    , MASTER_SUBMITTABLE             integer         NOT NULL
    , TIMEOUT_AMOUNT                 int8                NULL
    , TIMEOUT_BASE                   int8                NULL
    , TIMEOUT_STATE_ID               bigint              NULL
    , SAME_NODE                      integer             NULL
    , GANG_SCHEDULE                  integer             NULL
    , DEPENDENCY_OPERATION           int8            NOT NULL
    , ESMP_ID                        bigint              NULL
    , ESP_ID                         bigint              NULL
    , QA_ID                          bigint              NULL
    , NE_ID                          bigint              NULL
    , FP_ID                          bigint              NULL
    , INHERIT_PRIVS                  bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_SCHEDULING_ENTITY
ON SCHEDULING_ENTITY(ID);
CREATE VIEW SCI_C_SCHEDULING_ENTITY (ID,NAME,FOLDER_ID,OWNER_ID,TYPE,RUN_PROGRAM,RERUN_PROGRAM,KILL_PROGRAM,WORKDIR,LOGFILE,TRUNC_LOG,ERRLOGFILE,TRUNC_ERRLOG,EXPECTED_RUNTIME,EXPECTED_FINALTIME,GET_EXPECTED_RUNTIME,PRIORITY,MIN_PRIORITY,AGING_AMOUNT,AGING_BASE,SUBMIT_SUSPENDED,RESUME_AT,RESUME_IN,RESUME_BASE,MASTER_SUBMITTABLE,TIMEOUT_AMOUNT,TIMEOUT_BASE,TIMEOUT_STATE_ID,DEPENDENCY_OPERATION,ESMP_ID,ESP_ID,NE_ID,FP_ID,INHERIT_PRIVS,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , FOLDER_ID                      AS FOLDER_ID
    , OWNER_ID                       AS OWNER_ID
    , DECODE (TYPE, 1, 'JOB', 2, 'BATCH', 3, 'MILESTONE') AS TYPE
    , RUN_PROGRAM                    AS RUN_PROGRAM
    , RERUN_PROGRAM                  AS RERUN_PROGRAM
    , KILL_PROGRAM                   AS KILL_PROGRAM
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , DECODE (TRUNC_LOG, 0, 'NOTRUNC', 1, 'TRUNC') AS TRUNC_LOG
    , ERRLOGFILE                     AS ERRLOGFILE
    , DECODE (TRUNC_ERRLOG, 0, 'NOTRUNC', 1, 'TRUNC') AS TRUNC_ERRLOG
    , EXPECTED_RUNTIME               AS EXPECTED_RUNTIME
    , EXPECTED_FINALTIME             AS EXPECTED_FINALTIME
    , GET_EXPECTED_RUNTIME           AS GET_EXPECTED_RUNTIME
    , PRIORITY                       AS PRIORITY
    , MIN_PRIORITY                   AS MIN_PRIORITY
    , AGING_AMOUNT                   AS AGING_AMOUNT
    , DECODE (AGING_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS AGING_BASE
    , DECODE (SUBMIT_SUSPENDED, 1, 'SUSPEND', 0, 'NOSUSPEND') AS SUBMIT_SUSPENDED
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MASTER_SUBMITTABLE, 1, 'MASTER', 0, 'NOMASTER') AS MASTER_SUBMITTABLE
    , TIMEOUT_AMOUNT                 AS TIMEOUT_AMOUNT
    , DECODE (TIMEOUT_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS TIMEOUT_BASE
    , TIMEOUT_STATE_ID               AS TIMEOUT_STATE_ID
    , DECODE (DEPENDENCY_OPERATION, 1, 'AND', 2, 'OR') AS DEPENDENCY_OPERATION
    , ESMP_ID                        AS ESMP_ID
    , ESP_ID                         AS ESP_ID
    , NE_ID                          AS NE_ID
    , FP_ID                          AS FP_ID
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SCHEDULING_ENTITY
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_SCHEDULING_ENTITY (ID,NAME,FOLDER_ID,OWNER_ID,TYPE,RUN_PROGRAM,RERUN_PROGRAM,KILL_PROGRAM,WORKDIR,LOGFILE,TRUNC_LOG,ERRLOGFILE,TRUNC_ERRLOG,EXPECTED_RUNTIME,EXPECTED_FINALTIME,GET_EXPECTED_RUNTIME,PRIORITY,MIN_PRIORITY,AGING_AMOUNT,AGING_BASE,SUBMIT_SUSPENDED,RESUME_AT,RESUME_IN,RESUME_BASE,MASTER_SUBMITTABLE,TIMEOUT_AMOUNT,TIMEOUT_BASE,TIMEOUT_STATE_ID,DEPENDENCY_OPERATION,ESMP_ID,ESP_ID,NE_ID,FP_ID,INHERIT_PRIVS,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , FOLDER_ID                      AS FOLDER_ID
    , OWNER_ID                       AS OWNER_ID
    , DECODE (TYPE, 1, 'JOB', 2, 'BATCH', 3, 'MILESTONE') AS TYPE
    , RUN_PROGRAM                    AS RUN_PROGRAM
    , RERUN_PROGRAM                  AS RERUN_PROGRAM
    , KILL_PROGRAM                   AS KILL_PROGRAM
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , DECODE (TRUNC_LOG, 0, 'NOTRUNC', 1, 'TRUNC') AS TRUNC_LOG
    , ERRLOGFILE                     AS ERRLOGFILE
    , DECODE (TRUNC_ERRLOG, 0, 'NOTRUNC', 1, 'TRUNC') AS TRUNC_ERRLOG
    , EXPECTED_RUNTIME               AS EXPECTED_RUNTIME
    , EXPECTED_FINALTIME             AS EXPECTED_FINALTIME
    , GET_EXPECTED_RUNTIME           AS GET_EXPECTED_RUNTIME
    , PRIORITY                       AS PRIORITY
    , MIN_PRIORITY                   AS MIN_PRIORITY
    , AGING_AMOUNT                   AS AGING_AMOUNT
    , DECODE (AGING_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS AGING_BASE
    , DECODE (SUBMIT_SUSPENDED, 1, 'SUSPEND', 0, 'NOSUSPEND') AS SUBMIT_SUSPENDED
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MASTER_SUBMITTABLE, 1, 'MASTER', 0, 'NOMASTER') AS MASTER_SUBMITTABLE
    , TIMEOUT_AMOUNT                 AS TIMEOUT_AMOUNT
    , DECODE (TIMEOUT_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS TIMEOUT_BASE
    , TIMEOUT_STATE_ID               AS TIMEOUT_STATE_ID
    , DECODE (DEPENDENCY_OPERATION, 1, 'AND', 2, 'OR') AS DEPENDENCY_OPERATION
    , ESMP_ID                        AS ESMP_ID
    , ESP_ID                         AS ESP_ID
    , NE_ID                          AS NE_ID
    , FP_ID                          AS FP_ID
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM SCHEDULING_ENTITY;
