-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SUBMITTED_ENTITY_STATS (
    ID                             bigint NOT NULL
    , SME_ID                         bigint          NOT NULL
    , RERUN_SEQ                      int8            NOT NULL
    , SCOPE_ID                       bigint              NULL
    , JOB_ESD_ID                     bigint              NULL
    , EXIT_CODE                      int8                NULL
    , COMMANDLINE                    lvarchar(512)       NULL
    , WORKDIR                        lvarchar(512)       NULL
    , LOGFILE                        lvarchar(512)       NULL
    , ERRLOGFILE                     lvarchar(512)       NULL
    , EXTPID                         lvarchar(32)        NULL
    , SYNC_TS                        bigint              NULL
    , RESOURCE_TS                    bigint              NULL
    , RUNNABLE_TS                    bigint              NULL
    , START_TS                       bigint              NULL
    , FINISH_TS                      bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_SUBMITTED_ENTITY_STATS
ON SUBMITTED_ENTITY_STATS(ID);
CREATE VIEW SCI_SUBMITTED_ENTITY_STATS (ID,SME_ID,RERUN_SEQ,SCOPE_ID,JOB_ESD_ID,EXIT_CODE,COMMANDLINE,WORKDIR,LOGFILE,ERRLOGFILE,EXTPID,SYNC_TS,RESOURCE_TS,RUNNABLE_TS,START_TS,FINISH_TS,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , RERUN_SEQ                      AS RERUN_SEQ
    , SCOPE_ID                       AS SCOPE_ID
    , JOB_ESD_ID                     AS JOB_ESD_ID
    , EXIT_CODE                      AS EXIT_CODE
    , COMMANDLINE                    AS COMMANDLINE
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , ERRLOGFILE                     AS ERRLOGFILE
    , EXTPID                         AS EXTPID
    , dbinfo ('utc_to_datetime', round(mod(SYNC_TS, 1125899906842624)/1000)) AS SYNC_TS
    , dbinfo ('utc_to_datetime', round(mod(RESOURCE_TS, 1125899906842624)/1000)) AS RESOURCE_TS
    , dbinfo ('utc_to_datetime', round(mod(RUNNABLE_TS, 1125899906842624)/1000)) AS RUNNABLE_TS
    , dbinfo ('utc_to_datetime', round(mod(START_TS, 1125899906842624)/1000)) AS START_TS
    , dbinfo ('utc_to_datetime', round(mod(FINISH_TS, 1125899906842624)/1000)) AS FINISH_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SUBMITTED_ENTITY_STATS;
CREATE TABLE ARC_SUBMITTED_ENTITY_STATS (
    ID                             bigint NOT NULL
    , SME_ID                         bigint           NULL
    , RERUN_SEQ                      int8             NULL
    , SCOPE_ID                       bigint           NULL
    , JOB_ESD_ID                     bigint           NULL
    , EXIT_CODE                      int8             NULL
    , COMMANDLINE                    lvarchar(512)    NULL
    , WORKDIR                        lvarchar(512)    NULL
    , LOGFILE                        lvarchar(512)    NULL
    , ERRLOGFILE                     lvarchar(512)    NULL
    , EXTPID                         lvarchar(32)     NULL
    , SYNC_TS                        bigint           NULL
    , RESOURCE_TS                    bigint           NULL
    , RUNNABLE_TS                    bigint           NULL
    , START_TS                       bigint           NULL
    , FINISH_TS                      bigint           NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
