-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE WATCH_TYPE_PARAMETER (
    ID                             decimal(20) NOT NULL
    , NAME                           varchar(64)     NOT NULL
    , DEFAULTVALUE                   varchar(256)    WITH NULL
    , WT_ID                          decimal(20)     NOT NULL
    , IS_SUBMIT_PAR                  integer         NOT NULL
    , TYPE                           integer         NOT NULL
    , CREATOR_U_ID                   decimal(20)     NOT NULL
    , CREATE_TS                      decimal(20)     NOT NULL
    , CHANGER_U_ID                   decimal(20)     NOT NULL
    , CHANGE_TS                      decimal(20)     NOT NULL
);\g
CREATE UNIQUE INDEX PK_WATCH_TYPE_PARAMETER
ON WATCH_TYPE_PARAMETER(ID) WITH STRUCTURE = BTREE;\g
CREATE VIEW SCI_WATCH_TYPE_PARAMETER AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DEFAULTVALUE                   AS DEFAULTVALUE
    , WT_ID                          AS WT_ID
    , CASE IS_SUBMIT_PAR WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS IS_SUBMIT_PAR
    , CASE TYPE WHEN 1 THEN 'CONFIG' WHEN 2 THEN 'VALUE' WHEN 3 THEN 'INFO' END AS TYPE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , '01-JAN-1970 00:00:00 GMT' + date(char(decimal((CREATE_TS- decimal(CREATE_TS/1125899906842624, 18, 0)*1125899906842624)/1000, 18, 0)) + ' secs') AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , '01-JAN-1970 00:00:00 GMT' + date(char(decimal((CHANGE_TS- decimal(CHANGE_TS/1125899906842624, 18, 0)*1125899906842624)/1000, 18, 0)) + ' secs') AS CHANGE_TS
  FROM WATCH_TYPE_PARAMETER;\g
