-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE `RESOURCE_VARIABLE` (
    `ID`                           decimal(20) NOT NULL
    , `PD_ID`                        decimal(20)     NOT NULL
    , `R_ID`                         decimal(20)     NOT NULL
    , `VALUE`                        varchar(256)    NOT NULL
    , `CREATOR_U_ID`                 decimal(20)     NOT NULL
    , `CREATE_TS`                    decimal(20)     NOT NULL
    , `CHANGER_U_ID`                 decimal(20)     NOT NULL
    , `CHANGE_TS`                    decimal(20)     NOT NULL
) ENGINE = INNODB;
CREATE UNIQUE INDEX PK_RESOURCE_VARIABLE
ON `RESOURCE_VARIABLE`(`ID`);
CREATE VIEW SCI_RESOURCE_VARIABLE AS
SELECT 
    ID 
    , `PD_ID`                        AS `PD_ID`
    , `R_ID`                         AS `R_ID`
    , `VALUE`                        AS `VALUE`
    , `CREATOR_U_ID`                 AS `CREATOR_U_ID`
    , from_unixtime((`CREATE_TS` & ~1125899906842624)/1000) AS `CREATE_TS`
    , `CHANGER_U_ID`                 AS `CHANGER_U_ID`
    , from_unixtime((`CHANGE_TS` & ~1125899906842624)/1000) AS `CHANGE_TS`
  FROM `RESOURCE_VARIABLE`;
