-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE NICE_PROFILE (
    ID                             NUMBER (38) PRIMARY KEY
    , NAME                           VARCHAR2 (64 CHAR)   NOT NULL
    , IS_ACTIVE                      NUMBER (1)           NOT NULL
    , ACTIVE_TS                      NUMBER (38)              NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_NICE_PROFILE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS IS_ACTIVE
    , ACTIVE_TS                      AS ACTIVE_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM NICE_PROFILE;
