-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SCHEDULED_EVENT (
    ID                             NUMBER (38) PRIMARY KEY
    , OWNER_ID                       NUMBER (38)          NOT NULL
    , SCE_ID                         NUMBER (38)          NOT NULL
    , EVT_ID                         NUMBER (38)          NOT NULL
    , ACTIVE                         NUMBER (1)           NOT NULL
    , BROKEN                         NUMBER (1)           NOT NULL
    , ERROR_CODE                     VARCHAR2 (32 CHAR)       NULL
    , ERROR_MSG                      VARCHAR2 (256 CHAR)      NULL
    , LAST_START_TIME                NUMBER (38)              NULL
    , NEXT_START_TIME                NUMBER (38)              NULL
    , NEXT_IS_TRIGGER                NUMBER (1)               NULL
    , BACKLOG_HANDLING               NUMBER (38)          NOT NULL
    , SUSPEND_LIMIT                  NUMBER (38)              NULL
    , SUSPEND_LIMIT_MULTIPLIER       NUMBER (38)              NULL
    , IS_CALENDAR                    NUMBER (1)           NOT NULL
    , CALENDAR_HORIZON               NUMBER (38)              NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_SCHEDULED_EVENT AS
SELECT 
    ID 
    , OWNER_ID                       AS OWNER_ID
    , SCE_ID                         AS SCE_ID
    , EVT_ID                         AS EVT_ID
    , DECODE (ACTIVE, 1, 'ACTIVE', 0, 'INACTIVE') AS ACTIVE
    , DECODE (BROKEN, 1, 'BROKEN', 0, 'NOBROKEN') AS BROKEN
    , ERROR_CODE                     AS ERROR_CODE
    , ERROR_MSG                      AS ERROR_MSG
    , pkg_time.gmt2local(LAST_START_TIME) AS LAST_START_TIME
    , pkg_time.gmt2local(NEXT_START_TIME) AS NEXT_START_TIME
    , DECODE (NEXT_IS_TRIGGER, 1, 'TRUE', 0, 'FALSE') AS NEXT_IS_TRIGGER
    , DECODE (BACKLOG_HANDLING, 0, 'NONE', 1, 'LAST', 2, 'ALL') AS BACKLOG_HANDLING
    , DECODE (SUSPEND_LIMIT, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS SUSPEND_LIMIT
    , SUSPEND_LIMIT_MULTIPLIER       AS SUSPEND_LIMIT_MULTIPLIER
    , DECODE (IS_CALENDAR, 1, 'ACTIVE', 0, 'INACTIVE') AS IS_CALENDAR
    , CALENDAR_HORIZON               AS CALENDAR_HORIZON
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM SCHEDULED_EVENT;
