/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.jobserver;

import de.independit.scheduler.jobserver.ProcessInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

class Libjni {
    public static final String copyright = "Copyright (c) 2002-2017";
    public static final String company = "independIT Integrative Technologies GmbH";
    public static final String version = "2.10";
    public static final String protocol = "1.1";
    public static final Boolean alive = new Boolean(true);
    public static final Boolean dead = new Boolean(false);
    private static final String unixEnv = "/bin/sh -c env";
    private static final String winEnv = "CMD.EXE /C SET";
    private static final String unixNull = "/dev/null";
    private static final String winNull = "NUL";
    private static final char BOOTTIME_NONE = 'N';
    private static final char BOOTTIME_SYSTEM = 'S';
    private static final char BOOTTIME_FILE = 'F';
    public static final int OS_WIN = 0;
    public static final int OS_LINUX = 1;
    public static final int OS_UNIX = 2;
    public static final int OS_MAC = 3;
    public static final int OS_AIX = 4;
    public static final int OS_DONTKNOW = -1;
    private char boottimeHow;
    private String os = System.getProperty("os.name").toLowerCase();
    private int osType = this.os.contains("mac") ? 3 : (this.os.contains("nix") ? 2 : (this.os.contains("sunos") ? 2 : (this.os.contains("nux") ? 1 : (this.os.contains("aix") ? 4 : (this.os.contains("win") ? 0 : -1)))));

    public Libjni() {
        this.boottimeHow = (char)78;
    }

    public static String getVersion() {
        return version;
    }

    public static String getCopyright() {
        return copyright;
    }

    public static String getCompany() {
        return company;
    }

    public static String getProtocol() {
        return protocol;
    }

    public int getPid() {
        try {
            return Integer.parseInt(ProcessInfo.getPid());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getBoottime(char c) {
        return "0";
    }

    public Boolean isAlive(String string) {
        long l;
        int n = 0;
        int n2 = 0;
        while (string.charAt(n2) != '@') {
            ++n2;
        }
        try {
            l = Long.parseLong(string.substring(n, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        n = n2 + 1;
        char c = string.charAt(n);
        n2 = ++n;
        while (string.charAt(n2) != '+') {
            ++n2;
        }
        String string2 = string.substring(n, n2);
        n = n2 + 1;
        String string3 = string.substring(n);
        if (!string2.equals(this.getBoottime(c))) {
            return dead;
        }
        if (!string3.equals(this.getProcessStartTime(l))) {
            return dead;
        }
        return alive;
    }

    public final String getEnvCmd() {
        if (this.osType == 0) {
            return winEnv;
        }
        if (this.osType != -1) {
            return unixEnv;
        }
        return null;
    }

    public String chdir(String string) {
        return null;
    }

    public boolean setBoottimeHow(char c) {
        if (this.boottimeHow == 'N' || this.boottimeHow == 'S' || this.boottimeHow == 'F') {
            this.boottimeHow = c;
            return true;
        }
        return false;
    }

    public char getBoottimeHow() {
        return this.boottimeHow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String linuxProcessStartTime(long l) {
        int n;
        String string = "/proc/" + l + "/stat";
        File file = new File(string);
        String string2 = null;
        BufferedReader bufferedReader = null;
        if (!file.canRead()) {
            return null;
        }
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            String string3 = null;
            return string3;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        int n2 = 2;
        int n3 = string2.length();
        for (n = n3 - 1; n >= 0 && string2.charAt(n) != ')'; --n) {
        }
        if (n < 0) {
            return null;
        }
        ++n;
        while (n < n3 && n2 < 22) {
            if (string2.charAt(n) == ' ') {
                ++n2;
            }
            ++n;
        }
        int n4 = n++;
        while (string2.charAt(n) != ' ') {
            ++n;
        }
        String string4 = string2.substring(n4, n);
        return string4;
    }

    private String solarisProcessStartTime(long l) {
        return "0";
    }

    private String windowsProcessStartTime(long l) {
        return "0";
    }

    public String getProcessStartTime(long l) {
        if (this.osType == 1) {
            return this.linuxProcessStartTime(l);
        }
        if (this.osType == 2) {
            return this.solarisProcessStartTime(l);
        }
        if (this.osType == 0) {
            return this.windowsProcessStartTime(l);
        }
        return null;
    }
}

