/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server;

import de.independit.scheduler.server.DoNotify;
import de.independit.scheduler.server.InternalSession;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.util.SyncFifo;
import java.util.HashMap;
import java.util.Vector;

public class NotifierThread
extends InternalSession {
    public static final String name = "Notifier";
    public static final Integer ZERO = new Integer(0);
    private HashMap<Long, Integer> jsToNotify;

    public NotifierThread(SystemEnvironment systemEnvironment, SyncFifo syncFifo) throws SDMSException {
        super(name);
        this.NR = 1234325;
        this.initThread(systemEnvironment, syncFifo, this.NR, name, SystemEnvironment.notifyDelay * 1000);
    }

    public synchronized void initNotifierThread(SystemEnvironment systemEnvironment) throws SDMSException {
        this.jsToNotify = new HashMap();
    }

    @Override
    protected Node getNode(int n) {
        return new DoNotify();
    }

    public synchronized void addJobServerToNotify(Long l) {
        Integer n = this.jsToNotify.get(l);
        if (n == null) {
            this.jsToNotify.put(l, ZERO);
        }
    }

    public synchronized void removeFromPingList(Long l) {
        this.jsToNotify.remove(l);
    }

    public synchronized Integer getFromPingList(Long l) {
        return this.jsToNotify.get(l);
    }

    private synchronized void incPingList(Long l) {
        Integer n = this.jsToNotify.get(l);
        if (n != null) {
            this.jsToNotify.put(l, new Integer(n + 1));
        }
    }

    private synchronized Vector getJobServerList() {
        Vector<Long> vector = new Vector<Long>();
        vector.addAll(this.jsToNotify.keySet());
        return vector;
    }

    protected void doNotify(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = this.getJobServerList();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Long l = (Long)vector.get(i);
            try {
                Integer n = this.getFromPingList(l);
                if (n == null || n >= 5) continue;
                SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, l);
                NotifierThread.doTrace(null, "Notifying " + sDMSScope.pathString(systemEnvironment) + " (" + sDMSScope.getId(systemEnvironment) + ")", 3);
                sDMSScope.notify(systemEnvironment);
                this.incPingList(l);
                continue;
            }
            catch (NotFoundException notFoundException) {
                this.removeFromPingList(l);
            }
        }
    }
}

