/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSPooledResource;
import de.independit.scheduler.server.repository.SDMSSysResource;

class ResourceInfo {
    public SDMSSysResource r;
    public SDMSPooledResource pr;
    public int targetAmount;
    public int targetFreeAmount;
    public int freeAmount;
    public int amount;
    public int min_pct;
    public int max_pct;
    public int nom_pct;
    public int free_pct;
    public int amountReceived;

    public ResourceInfo() {
        this.r = null;
        this.pr = null;
        this.targetAmount = 0;
        this.targetFreeAmount = 0;
        this.freeAmount = 0;
        this.amount = 0;
        this.min_pct = 0;
        this.max_pct = 0;
        this.nom_pct = 0;
        this.free_pct = 0;
        this.amountReceived = 0;
    }

    public ResourceInfo(SystemEnvironment systemEnvironment, SDMSSysResource sDMSSysResource, SDMSPooledResource sDMSPooledResource) throws SDMSException {
        this.init(systemEnvironment, sDMSSysResource, sDMSPooledResource);
    }

    public ResourceInfo init(SystemEnvironment systemEnvironment, SDMSSysResource sDMSSysResource, SDMSPooledResource sDMSPooledResource) throws SDMSException {
        this.r = sDMSSysResource;
        this.pr = sDMSPooledResource;
        this.min_pct = this.pr.getActMinPct(systemEnvironment);
        this.max_pct = this.pr.getActMaxPct(systemEnvironment);
        this.nom_pct = this.pr.getActNomPct(systemEnvironment);
        this.free_pct = this.pr.getActFreePct(systemEnvironment);
        this.freeAmount = this.r.getFreeAmount(systemEnvironment);
        this.amount = this.r.getAmount(systemEnvironment);
        this.targetAmount = 0;
        this.targetFreeAmount = 0;
        return this;
    }
}

