/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.DumpEventGeneric;
import de.independit.scheduler.server.dump.DumpGrant;
import de.independit.scheduler.server.dump.DumpGroup;
import de.independit.scheduler.server.dump.DumpScheduledEvent;
import de.independit.scheduler.server.dump.DumpSchedulingEntity;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.IntervalUtil;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventParameter;
import de.independit.scheduler.server.repository.SDMSEventParameterTable;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import java.util.Collections;
import java.util.Vector;

class DumpEvent
extends DumpEventGeneric {
    public static final String __version = "@(#) $Id: DumpEvent.java,v 2.6.14.1 2013/03/14 10:24:11 ronald Exp $";
    private Long seId;
    String jobDefinition;
    private Integer type;
    private String seName;
    private Vector parmList;
    private String group;

    DumpEvent(SystemEnvironment systemEnvironment, SDMSEvent sDMSEvent) throws SDMSException {
        super(systemEnvironment, sDMSEvent);
    }

    private final void loadParameters(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSEventParameterTable.idx_evtId.getVector(systemEnvironment, this.eId);
        if (vector.isEmpty()) {
            return;
        }
        int n = vector.size();
        this.parmList = new Vector(n);
        for (int i = 0; i < n; ++i) {
            SDMSEventParameter sDMSEventParameter = (SDMSEventParameter)vector.get(i);
            String string = DumpEvent.quotedString(sDMSEventParameter.getKey(systemEnvironment));
            String string2 = sDMSEventParameter.getValue(systemEnvironment).substring(1);
            String string3 = string2.matches("\\d+") ? string2 : DumpEvent.quotedString(string2);
            this.parmList.add(string + " = " + string3);
        }
        Collections.sort(this.parmList, Compare.Lexically);
    }

    private final void collectSubmit(SystemEnvironment systemEnvironment) throws SDMSException {
        this.seId = this.e.getSeId(systemEnvironment);
        this.seName = DumpSchedulingEntity.getDumpedName(systemEnvironment, this.seId);
        this.loadParameters(systemEnvironment);
    }

    private final void loadJobDefinition(SystemEnvironment systemEnvironment) throws SDMSException {
        if (IntervalUtil.matchesQuotedIdName(this.getName())) {
            this.jobDefinition = this.seName;
            this.comments.setJobDefinition(this.jobDefinition);
        }
    }

    private final void collectScheduledEvents(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSScheduledEventTable.idx_evtId.getVector(systemEnvironment, this.eId);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSScheduledEvent sDMSScheduledEvent = (SDMSScheduledEvent)vector.get(i);
            Long l = sDMSScheduledEvent.getId(systemEnvironment);
            DumpScheduledEvent.getDumpedName(systemEnvironment, l);
        }
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        this.collectSubmit(systemEnvironment);
        this.loadJobDefinition(systemEnvironment);
        Long l = this.e.getOwnerId(systemEnvironment);
        this.group = DumpGroup.getDumpedName(systemEnvironment, l);
        this.collectScheduledEvents(systemEnvironment);
        DumpGrant.getDumpedList(systemEnvironment, this.eId);
    }

    @Override
    final void render(String string) {
        DumpEvent.println(string + " event " + this.getName());
        if (this.jobDefinition != null) {
            DumpEvent.println("\t\t(" + this.jobDefinition + ')');
        }
        DumpEvent.println("\twith");
        DumpEvent.print("\t\taction = submit " + this.seName);
        if (this.parmList != null) {
            DumpEvent.println("\n\t\t\twith");
            DumpEvent.println("\t\t\t\tparameters = (");
            DumpEvent.print("\t\t\t\t\t" + DumpEvent.join(",\n\t\t\t\t\t", this.parmList) + ')');
        }
        DumpEvent.println(',');
        DumpEvent.println("\t\tgroup = " + this.group + ';');
    }
}

