/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.DumpExitStateDefinition;
import de.independit.scheduler.server.dump.DumpExitStateTranslationProfileGeneric;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSExitStateTranslation;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfile;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationTable;
import java.util.Collections;
import java.util.Vector;

class DumpExitStateTranslationProfile
extends DumpExitStateTranslationProfileGeneric {
    public static final String __version = "@(#) $Id: DumpExitStateTranslationProfile.java,v 2.3.14.1 2013/03/14 10:24:12 ronald Exp $";
    private Vector translationDefs;

    DumpExitStateTranslationProfile(SystemEnvironment systemEnvironment, SDMSExitStateTranslationProfile sDMSExitStateTranslationProfile) throws SDMSException {
        super(systemEnvironment, sDMSExitStateTranslationProfile);
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSExitStateTranslationTable.idx_estpId.getVector(systemEnvironment, this.estpId);
        int n = vector.size();
        this.translationDefs = new Vector(n);
        for (int i = 0; i < n; ++i) {
            SDMSExitStateTranslation sDMSExitStateTranslation = (SDMSExitStateTranslation)vector.get(i);
            Long l = sDMSExitStateTranslation.getFromEsdId(systemEnvironment);
            String string = DumpExitStateDefinition.getDumpedName(systemEnvironment, l);
            Long l2 = sDMSExitStateTranslation.getToEsdId(systemEnvironment);
            String string2 = DumpExitStateDefinition.getDumpedName(systemEnvironment, l2);
            this.translationDefs.add(string + "\n\t\t\t\tto " + string2);
        }
        Collections.sort(this.translationDefs, Compare.ObjectNames);
    }

    @Override
    final void render(String string) {
        DumpExitStateTranslationProfile.println(string + " exit_state_translation " + this.getName());
        DumpExitStateTranslationProfile.println("\twith");
        DumpExitStateTranslationProfile.println("\t\ttranslations = (");
        DumpExitStateTranslationProfile.println("\t\t\t" + DumpExitStateTranslationProfile.join(",\n\t\t\t", this.translationDefs) + ");");
    }
}

