/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.DumpGrant;
import de.independit.scheduler.server.dump.DumpNamedEnvironmentGeneric;
import de.independit.scheduler.server.dump.DumpNamedResource;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSEnvironment;
import de.independit.scheduler.server.repository.SDMSEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSNamedEnvironment;
import java.util.Collections;
import java.util.Vector;

class DumpNamedEnvironment
extends DumpNamedEnvironmentGeneric {
    public static final String __version = "@(#) $Id: DumpNamedEnvironment.java,v 2.3.14.1 2013/03/14 10:24:13 ronald Exp $";
    private Vector nrList;

    DumpNamedEnvironment(SystemEnvironment systemEnvironment, SDMSNamedEnvironment sDMSNamedEnvironment) throws SDMSException {
        super(systemEnvironment, sDMSNamedEnvironment);
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSEnvironmentTable.idx_neId.getVector(systemEnvironment, this.neId);
        int n = vector.size();
        this.nrList = new Vector(n);
        for (int i = 0; i < n; ++i) {
            SDMSEnvironment sDMSEnvironment = (SDMSEnvironment)vector.get(i);
            Long l = sDMSEnvironment.getNrId(systemEnvironment);
            this.nrList.add(DumpNamedResource.getDumpedName(systemEnvironment, l));
        }
        Collections.sort(this.nrList, Compare.Lexically);
        DumpGrant.getDumpedList(systemEnvironment, this.neId);
    }

    @Override
    final void render(String string) {
        DumpNamedEnvironment.print(string + " environment " + this.getName());
        if (!this.nrList.isEmpty()) {
            DumpNamedEnvironment.println("\n\twith");
            DumpNamedEnvironment.println("\t\tresources = (");
            DumpNamedEnvironment.print("\t\t\t" + DumpNamedEnvironment.join(",\n\t\t\t", this.nrList) + ')');
        }
        DumpNamedEnvironment.println(';');
    }
}

