/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Dump;
import de.independit.scheduler.server.dump.DumpFolder;
import de.independit.scheduler.server.dump.DumpGrant;
import de.independit.scheduler.server.dump.DumpGroup;
import de.independit.scheduler.server.dump.DumpNamedResource;
import de.independit.scheduler.server.dump.DumpResourceGeneric;
import de.independit.scheduler.server.dump.DumpResourceStateDefinition;
import de.independit.scheduler.server.dump.DumpScope;
import de.independit.scheduler.server.dump.DumpTrigger;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceVariable;
import de.independit.scheduler.server.repository.SDMSResourceVariableTable;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import java.util.Vector;

class DumpResource
extends DumpResourceGeneric {
    public static final String __version = "@(#) $Id: DumpResource.java,v 2.8.14.1 2013/03/14 10:24:13 ronald Exp $";
    Long nrId;
    Long scopeId;
    private String nrName;
    private String containerName;
    private Vector resourceDefs;
    private Vector parmList;

    DumpResource(SystemEnvironment systemEnvironment, SDMSResource sDMSResource) throws SDMSException {
        super(systemEnvironment, sDMSResource);
    }

    @Override
    final String initialize(SystemEnvironment systemEnvironment) throws SDMSException {
        super.initialize(systemEnvironment);
        this.nrId = this.r.getNrId(systemEnvironment);
        this.scopeId = this.r.getScopeId(systemEnvironment);
        this.nrName = DumpNamedResource.getDumpedName(systemEnvironment, this.nrId);
        try {
            this.containerName = DumpScope.getDumpedName(systemEnvironment, this.scopeId);
        }
        catch (NotFoundException notFoundException) {
            this.containerName = DumpFolder.getDumpedName(systemEnvironment, this.scopeId);
        }
        return this.nrName + "\n\tin " + this.containerName;
    }

    private final void loadTrigger(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, this.rId);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSTrigger sDMSTrigger = (SDMSTrigger)vector.get(i);
            Long l = sDMSTrigger.getId(systemEnvironment);
            DumpTrigger.getDumpedName(systemEnvironment, l);
        }
    }

    private final Vector loadParameters(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = SDMSResourceVariableTable.idx_rId.getVector(systemEnvironment, this.r.getId(systemEnvironment));
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            SDMSResourceVariable sDMSResourceVariable = (SDMSResourceVariable)vector2.get(i);
            try {
                SDMSParameterDefinition sDMSParameterDefinition = SDMSParameterDefinitionTable.getObject(systemEnvironment, sDMSResourceVariable.getPdId(systemEnvironment));
                String string = Dump.quotedName(sDMSParameterDefinition.getId(systemEnvironment), sDMSParameterDefinition.getName(systemEnvironment)) + " = " + Dump.quotedString(sDMSResourceVariable.getValue(systemEnvironment).substring(1));
                vector.add(string);
                continue;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return vector.isEmpty() ? null : vector;
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n;
        this.resourceDefs = new Vector();
        Long l = this.r.getRsdId(systemEnvironment);
        if (l != null) {
            this.resourceDefs.add("state = " + DumpResourceStateDefinition.getDumpedName(systemEnvironment, l));
        }
        if ((n = this.r.getAmount(systemEnvironment)) == null) {
            this.resourceDefs.add("amount = infinite");
        } else {
            this.resourceDefs.add("amount = " + n);
        }
        Integer n2 = this.r.getRequestableAmount(systemEnvironment);
        if (n2 == null) {
            this.resourceDefs.add("requestable_amount = infinite");
        } else {
            this.resourceDefs.add("requestable_amount = " + n2);
        }
        Boolean bl = this.r.getIsOnline(systemEnvironment);
        if (bl != null) {
            this.resourceDefs.add(bl != false ? "online" : "offline");
        }
        Long l2 = this.r.getOwnerId(systemEnvironment);
        this.resourceDefs.add("group = " + DumpGroup.getDumpedName(systemEnvironment, l2));
        this.parmList = this.loadParameters(systemEnvironment);
        this.loadTrigger(systemEnvironment);
        DumpGrant.getDumpedList(systemEnvironment, this.rId);
    }

    @Override
    final void render(String string) {
        if (this.parmList != null) {
            DumpResource.println("alter existing resource " + this.nrName);
            DumpResource.println("\tin " + this.containerName);
            DumpResource.println("\twith");
            DumpResource.println("\t\tparameters = none;");
            DumpResource.println();
        }
        DumpResource.println(string + " resource " + this.nrName);
        DumpResource.println("\tin " + this.containerName);
        DumpResource.println("\twith");
        DumpResource.println("\t\t" + DumpResource.join(",\n\t\t", this.resourceDefs) + ',');
        DumpResource.println("\t\tparameters = " + (this.parmList == null ? "none" : "(\n\t\t\t" + DumpResource.join(",\n\t\t\t", this.parmList) + ")") + ";");
    }
}

