/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ChownChecker;
import de.independit.scheduler.server.parser.IntervalUtil;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.util.PathVector;
import java.util.TimeZone;

public class AlterSchedule
extends Node {
    public static final String __version = "@(#) $Id: AlterSchedule.java,v 2.10.2.1 2013/03/14 10:24:22 ronald Exp $";
    private final ObjectURL obj;
    private final WithHash with;
    private Boolean active;
    private final boolean noerr;

    public AlterSchedule(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.obj = objectURL;
        this.with = withHash == null ? new WithHash() : withHash;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Comparable comparable;
        Object object;
        SDMSSchedule sDMSSchedule;
        this.obj.resolve(systemEnvironment);
        Long l = this.obj.seId;
        PathVector pathVector = this.obj.path;
        String string = (String)pathVector.remove(pathVector.size() - 1);
        if (pathVector.size() == 0) {
            if (!systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03709291504", "Insufficient privileges"));
            }
            sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, SDMSObject.rootScId);
        } else {
            object = SDMSScheduleTable.pathToId(systemEnvironment, pathVector);
            comparable = new SDMSKey((Comparable)object, (Comparable)((Object)string));
            try {
                sDMSSchedule = SDMSScheduleTable.idx_parentId_name_getUnique(systemEnvironment, comparable);
            }
            catch (NotFoundException notFoundException) {
                if (this.noerr) {
                    this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311130102", "No Schedule altered"));
                    return;
                }
                throw notFoundException;
            }
        }
        this.active = !this.with.containsKey("ACTIVE") ? null : (Boolean)this.with.get("ACTIVE");
        object = (String)this.with.get("INTERVAL");
        if (object != null) {
            comparable = SDMSIntervalTable.idx_name_objId_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)IntervalUtil.mapIdName((String)object, l)), null));
            sDMSSchedule.setIntId(systemEnvironment, ((SDMSProxy)comparable).getId(systemEnvironment));
        } else if (this.with.containsKey("INTERVAL")) {
            sDMSSchedule.setIntId(systemEnvironment, null);
        }
        if (this.active != null) {
            boolean bl = sDMSSchedule.getIsActive(systemEnvironment);
            if (this.active != bl) {
                sDMSSchedule.setIsActive(systemEnvironment, this.active);
            }
        }
        if (this.with.containsKey("GROUP")) {
            String string2 = (String)this.with.get("GROUP");
            Long l2 = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)string2), new Long(0L))).getId(systemEnvironment);
            ChownChecker.check(systemEnvironment, l2);
            sDMSSchedule.setOwnerId(systemEnvironment, l2);
        }
        if (this.with.containsKey("INHERIT")) {
            Long l3 = (Long)this.with.get("INHERIT");
            if (l3 == null) {
                l3 = new Long(0L);
            }
            long l4 = l3;
            if ((sDMSSchedule.getPrivilegeMask() & l4) != l4) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202061132", "Incompatible grant"));
            }
            sDMSSchedule.setInheritPrivs(systemEnvironment, l3);
        }
        if (this.with.containsKey("TIME")) {
            TimeZone timeZone;
            String string3 = (String)this.with.get("TIME");
            if (!string3.equals((timeZone = TimeZone.getTimeZone(string3)).getID())) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207031502", "Time zone " + string3 + " unknown"));
            }
            sDMSSchedule.setTimeZone(systemEnvironment, string3);
        }
        SystemEnvironment.timer.notifyChange(systemEnvironment, sDMSSchedule, 2);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04207260120", "Schedule altered"));
    }
}

