/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ManipTrigger;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.parser.WithItem;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObjectMonitor;
import de.independit.scheduler.server.repository.SDMSObjectMonitorTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerParameter;
import de.independit.scheduler.server.repository.SDMSTriggerParameterProxyGeneric;
import de.independit.scheduler.server.repository.SDMSTriggerParameterTable;
import de.independit.scheduler.server.repository.SDMSTriggerState;
import de.independit.scheduler.server.repository.SDMSTriggerStateTable;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.util.Vector;

public class AlterTrigger
extends ManipTrigger {
    protected String name;
    protected WithHash with;
    protected WithItem fireObj;
    protected boolean noerr;
    protected Long submitOwnerId;
    protected Long fireId;
    protected Long checkFireId;
    protected int fireType;
    protected SDMSSchedulingEntity fireSe = null;
    protected SDMSNamedResource fireNr = null;
    protected SDMSResource fireR = null;
    protected SDMSNamedResource fireNR = null;
    protected SDMSObjectMonitor fireOm = null;
    private ObjectURL url;

    public AlterTrigger(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.name = null;
        this.with = withHash;
        this.fireObj = null;
        this.url = objectURL;
        this.isInverse = (Boolean)objectURL.triggerInverse.value;
        this.noerr = bl;
    }

    public AlterTrigger(String string, Long l, int n, WithHash withHash, Boolean bl) {
        this.name = string;
        this.with = withHash;
        this.fireObj = null;
        this.fireId = l;
        this.fireType = n;
        this.url = null;
        this.isInverse = (Boolean)this.with.get("INVERSE");
        this.noerr = bl;
    }

    private void checkWith(SystemEnvironment systemEnvironment, SDMSTrigger sDMSTrigger) throws SDMSException {
        Object object;
        Object object2;
        Long l;
        String string;
        int n = sDMSTrigger.getObjectType(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = null;
        if (this.with.containsKey("RERUN")) {
            if (this.with.containsKey("SUBMIT")) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03108190858", "Submit and Rerun cannot be specified both"));
            }
            this.action = new Integer(1);
            this.iaction = 1;
            if (n != 0) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03108111304", "Rerun triggers are valid for jobs only"));
            }
        } else {
            this.action = sDMSTrigger.getAction(systemEnvironment);
            this.iaction = this.action;
        }
        Boolean bl = this.isMaster = (Boolean)this.with.get("MASTER");
        if (this.isMaster != null) {
            if (n != 0 && n != 3 && !this.isMaster.booleanValue()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206202334", "Only master submits allowed for resource triggers"));
            }
            if (this.iaction == 1 && this.isMaster.booleanValue()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03108091455", "Master option not valid for rerun triggers"));
            }
        } else {
            bl = sDMSTrigger.getIsMaster(systemEnvironment);
        }
        if (this.isInverse.booleanValue()) {
            if (!bl.booleanValue()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "036231301", "Master option mandatory for inverse triggers"));
            }
            if (this.iaction == 1) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "036231302", "Inverse option not valid for rerun triggers"));
            }
            if (n != 0) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "036231303", "Inverse option only valid for job triggers"));
            }
        }
        Long l2 = null;
        this.folderpath = (Vector)this.with.get("SUBMIT");
        if (this.folderpath != null && this.iaction == 0) {
            string = (String)this.folderpath.remove(this.folderpath.size() - 1);
            sDMSSchedulingEntity = SDMSSchedulingEntityTable.get(systemEnvironment, this.folderpath, string);
            if (this.isInverse.booleanValue()) {
                this.checkFireId = this.fireId = sDMSSchedulingEntity.getId(systemEnvironment);
                this.seId = sDMSTrigger.getSeId(systemEnvironment);
            } else {
                if (!sDMSSchedulingEntity.checkPrivileges(systemEnvironment, 0x100000L)) {
                    throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03402131605", "Submit privilege on $1 missing", (Object)sDMSSchedulingEntity.pathString(systemEnvironment)));
                }
                this.seId = sDMSSchedulingEntity.getId(systemEnvironment);
                this.fireId = sDMSTrigger.getFireId(systemEnvironment);
                l2 = this.seId;
            }
        } else if (this.folderpath == null && this.with.containsKey("RERUN")) {
            this.fireId = this.seId = sDMSTrigger.getFireId(systemEnvironment);
            l2 = this.seId;
        } else {
            this.seId = null;
            l2 = sDMSTrigger.getSeId(systemEnvironment);
        }
        this.active = this.with.containsKey("ACTIVE") ? (Boolean)this.with.get("ACTIVE") : sDMSTrigger.getIsActive(systemEnvironment);
        if (this.iaction == 1 && SDMSSchedulingEntityTable.getObject(systemEnvironment, l2).getType(systemEnvironment) != 1) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03108111251", "Rerun triggers are valid for jobs only"));
        }
        this.isSuspend = (Boolean)this.with.get("SUSPEND");
        if (this.isSuspend == null) {
            this.isSuspend = sDMSTrigger.getIsSuspend(systemEnvironment);
        }
        this.resumeObj = this.with.get("RESUME");
        if (!this.isSuspend.booleanValue() && this.resumeObj != null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03108111218", "Resume without suspend clause doesn't make sense"));
        }
        if (!this.isSuspend.booleanValue()) {
            this.resumeAt = null;
            this.resumeIn = null;
            this.resumeBase = null;
        } else {
            this.analyzeResumeObj(systemEnvironment);
        }
        string = (String)this.with.get("GROUP");
        if (string != null) {
            if (this.iaction == 1) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03108111234", "Group clause is not allowed for rerun triggers"));
            }
            if (!bl.booleanValue()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402180855", "Group clause is not allowed for child triggers"));
            }
            l = this.submitOwnerId = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)string), new Long(0L))).getId(systemEnvironment);
        } else {
            this.submitOwnerId = null;
            l = sDMSTrigger.getSubmitOwnerId(systemEnvironment);
        }
        this.triggertype = (Integer)this.with.get("TRIGGERTYPE");
        int n2 = 0;
        if (this.triggertype != null) {
            n2 = this.triggertype;
            if (n != 0) {
                if (n == 3) {
                    systemEnvironment.checkFeatureAvailability("OBJECTMONITOR_TRIGGER");
                } else {
                    systemEnvironment.checkFeatureAvailability("RESOURCE_TRIGGER");
                }
                if (n2 != 0) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206200913", "Triggertype must be Immediate for resource and object monitor triggers"));
                }
            } else {
                if (n2 == 5 || n2 == 6) {
                    systemEnvironment.checkFeatureAvailability("ASYNC_TRIGGERS");
                }
                if (n2 != 2 && n2 != 0 && n2 != 1) {
                    systemEnvironment.checkFeatureAvailability("EXTENDED_TRIGGERS");
                }
                if (this.fireSe.getType(systemEnvironment) == 3 && n2 != 3 && !bl.booleanValue()) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03209201516", "Triggertype must be AFTER FINAL for non-master triggers on milestones"));
                }
                if (!(n2 != 5 && n2 != 6 || this.with.containsKey("CHECK"))) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03508030807", "Asynchroneous triggers must define a check interval"));
                }
                if (n2 != 0 && this.iaction == 1) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03108111248", "Only immediate local triggers can be used for automatic restarts"));
                }
            }
        } else {
            n2 = sDMSTrigger.getType(systemEnvironment);
        }
        if (n == 0) {
            this.isWarnOnLimit = (Boolean)this.with.get("WARN");
            if (this.with.containsKey("LIMIT")) {
                object2 = (String)this.with.get("LIMIT");
                if (object2 == null) {
                    this.limitState = null;
                } else {
                    try {
                        object = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, object2);
                        this.limitState = ((SDMSProxy)object).getId(systemEnvironment);
                    }
                    catch (NotFoundException notFoundException) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03509181338", "Specified exit state " + (String)object2 + " not found"));
                    }
                    object = this.fireSe.getEspId(systemEnvironment);
                    try {
                        SDMSExitState sDMSExitState = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, new SDMSKey((Comparable)object, this.limitState));
                    }
                    catch (NotFoundException notFoundException) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03310101439", "Specified exit state " + (String)object2 + " not found in exit state profile"));
                    }
                }
            }
        } else {
            this.isWarnOnLimit = null;
        }
        this.condition = (String)this.with.get("CONDITION");
        if (this.condition == null) {
            this.condition = sDMSTrigger.getCondition(systemEnvironment);
        }
        this.maxRetry = (Integer)this.with.get("SUBMITCOUNT");
        if (this.maxRetry != null && n != 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206202335", "Retry Count doesn't make sense for resource triggers"));
        }
        if (n == 0) {
            this.rscstate = null;
            this.state = (Vector)this.with.get("STATUS");
            if (this.with.containsKey("RSCSTATUS")) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206200920", "Only job states are allowed for job triggers"));
            }
        } else if (n != 3) {
            this.state = null;
            this.rscstate = (Vector)this.with.get("RSCSTATUS");
            if (this.with.containsKey("STATUS") && this.with.get("STATUS") != null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206202332", "Only resource states are allowed for resource triggers"));
            }
        }
        if (this.with.containsKey("CHECK")) {
            this.check = (WithHash)this.with.get("CHECK");
            if (this.condition == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03508030809", "Asynchroneous triggers are only valid in combination with a condition"));
            }
            if (n2 != 5 && n2 != 6) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03508030810", "Check periods are only valid for asynchroneous triggers"));
            }
            this.checkAmount = (Integer)this.check.get("MULT");
            this.checkBase = (Integer)this.check.get("INTERVAL");
        } else {
            this.checkAmount = null;
            this.checkBase = null;
        }
        object2 = null;
        if (n == 3) {
            if (this.with.containsKey("EVENT")) {
                this.isCreate = Boolean.FALSE;
                this.isDelete = Boolean.FALSE;
                this.isChange = Boolean.FALSE;
                object = (Vector)this.with.get("EVENT");
                block9: for (int i = 0; i < ((Vector)object).size(); ++i) {
                    Integer n3 = (Integer)((Vector)object).get(i);
                    switch (n3) {
                        case 0: {
                            this.isCreate = Boolean.TRUE;
                            continue block9;
                        }
                        case 1: {
                            this.isChange = Boolean.TRUE;
                            continue block9;
                        }
                        case 2: {
                            this.isDelete = Boolean.TRUE;
                        }
                    }
                }
            }
            this.isGroup = sDMSTrigger.getIsGroup(systemEnvironment);
            if (this.with.containsKey("ISGROUPED")) {
                this.isGroup = (Boolean)this.with.get("ISGROUPED");
            }
            this.mainSeId = sDMSTrigger.getMainSeId(systemEnvironment);
            this.parentSeId = sDMSTrigger.getParentSeId(systemEnvironment);
            if (this.with.containsKey("MAIN") && this.with.get("MAIN") != null) {
                if (!this.isGroup.booleanValue()) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03109082216", "Main Scheduling Entity option is only valid for Object Monitor group Triggers"));
                }
                this.folderpath = (Vector)this.with.get("MAIN");
                object2 = SDMSSchedulingEntityTable.get(systemEnvironment, this.folderpath, null);
                if (!((SDMSSchedulingEntityProxyGeneric)object2).checkPrivileges(systemEnvironment, 0x100000L)) {
                    throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03109082217", "Submit privilege on $1 missing", (Object)((SDMSSchedulingEntity)object2).pathString(systemEnvironment)));
                }
                this.mainSeId = ((SDMSProxy)object2).getId(systemEnvironment);
            } else if (this.with.containsKey("MAIN") && this.with.get("MAIN") == null) {
                this.mainSeId = null;
            }
            if (this.with.containsKey("PARENT") && this.with.get("PARENT") != null) {
                if (!this.isGroup.booleanValue()) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03109082218", "Parent Scheduling Entity option is only valid for Object Monitor group Triggers"));
                }
                if (this.mainSeId == null) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03109082219", "Parent Scheduling Entity option is only valid if the main option is specified"));
                }
                this.folderpath = (Vector)this.with.get("PARENT");
                object = SDMSSchedulingEntityTable.get(systemEnvironment, this.folderpath, null);
                if (!((SDMSSchedulingEntityProxyGeneric)object).checkPrivileges(systemEnvironment, 0x100000L)) {
                    throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03109082220", "Submit privilege on $1 missing", (Object)((SDMSSchedulingEntity)object).pathString(systemEnvironment)));
                }
                this.parentSeId = ((SDMSProxy)object).getId(systemEnvironment);
            } else if (this.with.containsKey("PARENT") && this.with.get("PARENT") == null) {
                this.parentSeId = null;
            }
            if (!this.isGroup.booleanValue()) {
                this.mainSeId = null;
                this.parentSeId = null;
            }
        }
        if (bl.booleanValue()) {
            if (!this.with.containsKey("GROUP") && l == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402180659", "Group clause is mandatory for master triggers"));
            }
            if (this.isMaster != null || this.seId != null) {
                if (sDMSSchedulingEntity == null) {
                    sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l2);
                }
                if (object2 == null && !sDMSSchedulingEntity.getMasterSubmittable(systemEnvironment).booleanValue() || object2 != null && !((SDMSSchedulingEntityProxyGeneric)object2).getMasterSubmittable(systemEnvironment).booleanValue()) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402180838", "Master trigger defined for non master submittable job"));
                }
            }
            if (this.isMaster != null || this.submitOwnerId != null || this.seId != null) {
                if (sDMSSchedulingEntity == null) {
                    sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l2);
                }
                sDMSSchedulingEntity.checkSubmitForGroup(systemEnvironment, l);
            }
        }
    }

    private void getFireId(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.fireObj == null) {
            switch (this.fireType) {
                case 0: {
                    this.fireSe = SDMSSchedulingEntityTable.getObject(systemEnvironment, this.fireId);
                    break;
                }
                case 1: {
                    this.fireR = SDMSResourceTable.getObject(systemEnvironment, this.fireId);
                    break;
                }
                case 2: {
                    this.fireNR = SDMSNamedResourceTable.getObject(systemEnvironment, this.fireId);
                    break;
                }
                case 3: {
                    this.fireOm = SDMSObjectMonitorTable.getObject(systemEnvironment, this.fireId);
                }
            }
            return;
        }
        if (this.fireObj.key.equals("JOB")) {
            Vector vector = (Vector)this.fireObj.value;
            String string = (String)vector.remove(vector.size() - 1);
            this.fireSe = SDMSSchedulingEntityTable.get(systemEnvironment, vector, string);
            this.fireId = this.fireSe.getId(systemEnvironment);
        } else if (this.fireObj.key.equals("RESOURCE")) {
            Long l;
            Vector vector = (Vector)this.fireObj.value;
            SDMSThread.doTrace(systemEnvironment.cEnv, "Objectpath : " + vector.toString(), 3);
            Object e = vector.remove(vector.size() - 1);
            SDMSThread.doTrace(systemEnvironment.cEnv, "Object in doubt : " + e.toString(), 3);
            Vector vector2 = (Vector)e;
            try {
                l = SDMSScopeTable.pathToId(systemEnvironment, vector);
            }
            catch (NotFoundException notFoundException) {
                l = SDMSFolderTable.pathToId(systemEnvironment, vector);
            }
            Long l2 = SDMSNamedResourceTable.getNamedResource(systemEnvironment, vector2).getId(systemEnvironment);
            this.fireR = SDMSResourceTable.idx_nrId_scopeId_getUnique(systemEnvironment, new SDMSKey(l2, l));
            this.fireId = this.fireR.getId(systemEnvironment);
        } else if (this.fireObj.key.equals("NAMED_RESOURCE")) {
            Vector vector = (Vector)this.fireObj.value;
            this.fireNR = SDMSNamedResourceTable.getNamedResource(systemEnvironment, vector);
            this.fireId = this.fireNr.getId(systemEnvironment);
        } else if (this.fireObj.key.equals("OBJECT")) {
            String string = (String)this.fireObj.value;
            this.fireOm = SDMSObjectMonitorTable.idx_name_getUnique(systemEnvironment, string);
            this.fireId = this.fireOm.getId(systemEnvironment);
        }
    }

    private void diffParameters(SystemEnvironment systemEnvironment, SDMSTrigger sDMSTrigger) throws SDMSException {
        String string;
        Long l = sDMSTrigger.getId(systemEnvironment);
        Vector vector = SDMSTriggerParameterTable.idx_triggerId.getVector(systemEnvironment, l);
        WithHash withHash = (WithHash)this.with.get("PARAMETERS");
        if (withHash == null) {
            withHash = new WithHash();
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object object = (SDMSTriggerParameter)vector.get(i);
            string = ((SDMSTriggerParameterProxyGeneric)object).getName(systemEnvironment);
            if (withHash.containsKey(string)) {
                String string2;
                String string3 = ((SDMSTriggerParameter)object).getExpression(systemEnvironment);
                if (!string3.equals(string2 = (String)withHash.get(string))) {
                    sDMSTrigger.checkParameterExpressionSyntax(systemEnvironment, string2);
                    ((SDMSTriggerParameter)object).setExpression(systemEnvironment, string2);
                }
                withHash.remove(string);
                continue;
            }
            ((SDMSTriggerParameterProxyGeneric)object).delete(systemEnvironment);
        }
        for (Object object : withHash.keySet()) {
            string = (String)withHash.get(object);
            sDMSTrigger.checkParameterExpressionSyntax(systemEnvironment, string);
            SDMSTriggerParameterTable.table.create(systemEnvironment, (String)object, string, l);
        }
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        int n;
        Vector vector;
        SDMSTrigger sDMSTrigger = null;
        try {
            if (this.url == null) {
                this.getFireId(systemEnvironment);
                vector = this.isInverse != false ? SDMSTriggerTable.idx_seId_name.getVector(systemEnvironment, new SDMSKey(this.fireId, (Comparable)((Object)this.name))) : SDMSTriggerTable.idx_fireId_name.getVector(systemEnvironment, new SDMSKey(this.fireId, (Comparable)((Object)this.name)));
                if (vector.size() == 0) {
                    throw new NotFoundException();
                }
                for (n = 0; n < vector.size() && !(sDMSTrigger = (SDMSTrigger)vector.get(n)).getIsInverse(systemEnvironment).equals(this.isInverse); ++n) {
                }
                if (n == vector.size()) {
                    throw new NotFoundException();
                }
            } else {
                sDMSTrigger = (SDMSTrigger)this.url.resolve(systemEnvironment);
                if (sDMSTrigger == null) {
                    throw new NotFoundException(new SDMSMessage(systemEnvironment, "03906060937", "Couldn't resolve the trigger"));
                }
                this.fireId = sDMSTrigger.getFireId(systemEnvironment);
                this.fireType = sDMSTrigger.getObjectType(systemEnvironment);
                switch (this.fireType) {
                    case 0: {
                        this.fireSe = SDMSSchedulingEntityTable.getObject(systemEnvironment, this.fireId);
                        break;
                    }
                    case 3: {
                        this.fireOm = SDMSObjectMonitorTable.getObject(systemEnvironment, this.fireId);
                        break;
                    }
                    case 1: {
                        this.fireR = SDMSResourceTable.getObject(systemEnvironment, this.fireId);
                        break;
                    }
                    case 2: {
                        this.fireNR = SDMSNamedResourceTable.getObject(systemEnvironment, this.fireId);
                    }
                }
            }
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311130107", "No Trigger altered"));
                return;
            }
            throw notFoundException;
        }
        Long l = sDMSTrigger.getId(systemEnvironment);
        this.fireId = sDMSTrigger.getFireId(systemEnvironment);
        this.seId = sDMSTrigger.getSeId(systemEnvironment);
        this.checkWith(systemEnvironment, sDMSTrigger);
        if (this.isInverse.booleanValue()) {
            if (this.fireId != null) {
                sDMSTrigger.setFireId(systemEnvironment, this.fireId);
            }
        } else if (this.seId != null) {
            sDMSTrigger.setSeId(systemEnvironment, this.seId);
        }
        if (this.triggertype != null) {
            sDMSTrigger.setType(systemEnvironment, this.triggertype);
        }
        sDMSTrigger.setAction(systemEnvironment, this.action);
        sDMSTrigger.setIsActive(systemEnvironment, this.active);
        if (this.isMaster != null) {
            sDMSTrigger.setIsMaster(systemEnvironment, this.isMaster);
        }
        if (this.isSuspend != null) {
            sDMSTrigger.setIsSuspend(systemEnvironment, this.isSuspend);
        }
        sDMSTrigger.setResumeAt(systemEnvironment, this.resumeAt);
        sDMSTrigger.setResumeIn(systemEnvironment, this.resumeIn);
        sDMSTrigger.setResumeBase(systemEnvironment, this.resumeBase);
        if (this.isWarnOnLimit != null) {
            sDMSTrigger.setIsWarnOnLimit(systemEnvironment, this.isWarnOnLimit);
        }
        if (this.with.containsKey("LIMIT")) {
            sDMSTrigger.setLimitState(systemEnvironment, this.limitState);
        }
        if (this.maxRetry != null) {
            sDMSTrigger.setMaxRetry(systemEnvironment, this.maxRetry);
        }
        if (this.with.containsKey("CONDITION")) {
            sDMSTrigger.setCondition(systemEnvironment, this.condition);
        }
        sDMSTrigger.checkConditionSyntax(systemEnvironment);
        if (this.with.containsKey("CHECK")) {
            sDMSTrigger.setCheckAmount(systemEnvironment, this.checkAmount);
            sDMSTrigger.setCheckBase(systemEnvironment, this.checkBase);
        }
        this.checkUniqueness(systemEnvironment, this.name, this.fireId, this.seId, this.isInverse == null ? sDMSTrigger.getIsInverse(systemEnvironment) : this.isInverse);
        if (this.isInverse != null) {
            sDMSTrigger.setIsInverse(systemEnvironment, this.isInverse);
        }
        if (this.isMaster == null) {
            this.isMaster = sDMSTrigger.getIsMaster(systemEnvironment);
        }
        if (this.isMaster.booleanValue()) {
            if (this.submitOwnerId != null) {
                sDMSTrigger.setSubmitOwnerId(systemEnvironment, this.submitOwnerId);
            } else {
                sDMSTrigger.setSubmitOwnerId(systemEnvironment, null);
            }
        }
        if (sDMSTrigger.getObjectType(systemEnvironment) == 0) {
            Comparable comparable;
            if (this.state != null || this.state == null && this.with.containsKey("STATUS")) {
                vector = SDMSTriggerStateTable.idx_triggerId.getVector(systemEnvironment, l);
                for (n = 0; n < vector.size(); ++n) {
                    comparable = (SDMSTriggerState)vector.get(n);
                    comparable.delete(systemEnvironment);
                }
            }
            if (this.state != null) {
                for (int i = 0; i < this.state.size(); ++i) {
                    String string = (String)this.state.get(i);
                    comparable = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, string).getId(systemEnvironment);
                    SDMSTriggerStateTable.table.create(systemEnvironment, l, null, (Long)comparable);
                }
            }
            if (sDMSTrigger.getType(systemEnvironment) != 3) {
                SDMSSchedulingHierarchyTable.checkHierarchyCycles(systemEnvironment, sDMSTrigger.getFireId(systemEnvironment));
            }
        } else if (sDMSTrigger.getObjectType(systemEnvironment) == 1 || sDMSTrigger.getObjectType(systemEnvironment) == 2) {
            Comparable comparable;
            if (this.rscstate != null || this.rscstate == null && this.with.containsKey("STATUS")) {
                vector = SDMSTriggerStateTable.idx_triggerId.getVector(systemEnvironment, l);
                for (n = 0; n < vector.size(); ++n) {
                    comparable = (SDMSTriggerState)vector.get(n);
                    comparable.delete(systemEnvironment);
                }
            }
            if (this.rscstate != null) {
                for (int i = 0; i < this.rscstate.size(); ++i) {
                    WithItem withItem = (WithItem)this.rscstate.get(i);
                    comparable = withItem.key != null ? SDMSResourceStateDefinitionTable.idx_name_getUnique(systemEnvironment, withItem.key).getId(systemEnvironment) : null;
                    Long l2 = withItem.value != null ? SDMSResourceStateDefinitionTable.idx_name_getUnique(systemEnvironment, withItem.value).getId(systemEnvironment) : null;
                    SDMSTriggerStateTable.table.create(systemEnvironment, l, (Long)comparable, l2);
                }
            }
        } else if (sDMSTrigger.getObjectType(systemEnvironment) == 3) {
            if (this.with.containsKey("EVENT")) {
                sDMSTrigger.setIsCreate(systemEnvironment, this.isCreate);
                sDMSTrigger.setIsChange(systemEnvironment, this.isChange);
                sDMSTrigger.setIsDelete(systemEnvironment, this.isDelete);
            }
            sDMSTrigger.setIsGroup(systemEnvironment, this.isGroup);
            sDMSTrigger.setMainSeId(systemEnvironment, this.mainSeId);
            sDMSTrigger.setParentSeId(systemEnvironment, this.parentSeId);
        }
        if (this.with.containsKey("PARAMETERS")) {
            this.diffParameters(systemEnvironment, sDMSTrigger);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03206191441", "Trigger altered"));
    }
}

