/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSPool;
import de.independit.scheduler.server.repository.SDMSPoolDistConfig;
import de.independit.scheduler.server.repository.SDMSPoolDistConfigTable;
import de.independit.scheduler.server.repository.SDMSPoolDistribution;
import de.independit.scheduler.server.repository.SDMSPoolDistributionTable;
import de.independit.scheduler.server.repository.SDMSPooledResource;
import de.independit.scheduler.server.repository.SDMSPooledResourceTable;
import java.util.Vector;

public class CopyDistribution
extends Node {
    public static final String __version = "@(#) $Id: CopyDistribution.java,v 2.1.14.3 2013/03/20 06:42:57 ronald Exp $";
    private final ObjectURL url;
    private final String name;

    public CopyDistribution(ObjectURL objectURL, String string) {
        this.url = objectURL;
        this.name = string;
    }

    private void copyDefault(SystemEnvironment systemEnvironment, ObjectURL objectURL, String string) throws SDMSException {
        SDMSPool sDMSPool = (SDMSPool)objectURL.resolve(systemEnvironment);
        Long l = sDMSPool.getId(systemEnvironment);
        SDMSPoolDistribution sDMSPoolDistribution = SDMSPoolDistributionTable.table.create(systemEnvironment, string, l);
        Long l2 = sDMSPoolDistribution.getId(systemEnvironment);
        Vector vector = SDMSPooledResourceTable.idx_pId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSPooledResource sDMSPooledResource = (SDMSPooledResource)vector.get(i);
            SDMSPoolDistConfigTable.table.create(systemEnvironment, l2, sDMSPooledResource.getId(systemEnvironment), sDMSPooledResource.getIsManaged(systemEnvironment), sDMSPooledResource.getNomPct(systemEnvironment), sDMSPooledResource.getFreePct(systemEnvironment), sDMSPooledResource.getMinPct(systemEnvironment), sDMSPooledResource.getMaxPct(systemEnvironment));
        }
    }

    private void copyDist(SystemEnvironment systemEnvironment, ObjectURL objectURL, String string) throws SDMSException {
        SDMSPoolDistribution sDMSPoolDistribution = (SDMSPoolDistribution)objectURL.resolve(systemEnvironment);
        Long l = sDMSPoolDistribution.getId(systemEnvironment);
        SDMSPoolDistribution sDMSPoolDistribution2 = SDMSPoolDistributionTable.table.create(systemEnvironment, string, sDMSPoolDistribution.getPId(systemEnvironment));
        Long l2 = sDMSPoolDistribution2.getId(systemEnvironment);
        Vector vector = SDMSPoolDistConfigTable.idx_pldId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSPoolDistConfig sDMSPoolDistConfig = (SDMSPoolDistConfig)vector.get(i);
            SDMSPoolDistConfigTable.table.create(systemEnvironment, l2, sDMSPoolDistConfig.getPrId(systemEnvironment), sDMSPoolDistConfig.getIsManaged(systemEnvironment), sDMSPoolDistConfig.getNomPct(systemEnvironment), sDMSPoolDistConfig.getFreePct(systemEnvironment), sDMSPoolDistConfig.getMinPct(systemEnvironment), sDMSPoolDistConfig.getMaxPct(systemEnvironment));
        }
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        systemEnvironment.checkFeatureAvailability("POOL");
        if (this.name.toUpperCase().equals("DEFAULT")) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603241431", "The name default is reserved within the context of distributions"));
        }
        if (this.url.name != null) {
            if (this.url.name.toUpperCase().equals("DEFAULT")) {
                this.copyDefault(systemEnvironment, this.url.master, this.name);
            } else {
                this.copyDist(systemEnvironment, this.url, this.name);
            }
        } else {
            this.copyDist(systemEnvironment, this.url, this.name);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03603241414", "Distribution copied"));
    }
}

