/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.AlterComment;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import java.util.Vector;

public class CreateComment
extends Node {
    private int type;
    private ObjectURL obj;
    private WithHash with;
    private boolean replace;

    public CreateComment(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.with = withHash;
        this.obj = objectURL;
        this.replace = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n;
        String string = null;
        String string2 = null;
        if (!(this.with.containsKey("TEXT") ^ this.with.containsKey("URL"))) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04411111628", "Must specify exactly one of TEXT or URL"));
        }
        this.obj.resolve(systemEnvironment);
        if (this.with.containsKey("URL")) {
            n = new Integer(1);
            string2 = (String)this.with.get("URL");
            string = null;
        } else {
            n = new Integer(0);
        }
        Vector vector = SDMSObjectCommentTable.idx_objectId.getVector(systemEnvironment, this.obj.objId);
        if (vector.size() != 0) {
            if (this.replace) {
                AlterComment alterComment = new AlterComment(this.obj, this.with, Boolean.FALSE);
                alterComment.setEnv(this.env);
                alterComment.go(systemEnvironment);
                this.result = alterComment.result;
                return;
            }
            throw new DuplicateKeyException(new SDMSMessage(systemEnvironment, "03510061519", "Comment already exists"));
        }
        if (n == 1) {
            SDMSObjectCommentTable.table.create(systemEnvironment, this.obj.objId, this.obj.objType, n, new Integer(1), string, string2);
        } else {
            vector = (Vector)this.with.get("TEXT");
            for (int i = 0; i < vector.size(); ++i) {
                Vector vector2 = (Vector)vector.get(i);
                string = (String)vector2.get(0);
                string2 = (String)vector2.get(1);
                SDMSObjectCommentTable.table.create(systemEnvironment, this.obj.objId, this.obj.objType, n, new Integer(i + 1), string, string2);
            }
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03209241404", "Comment created"));
    }
}

