/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.AlterEnvironment;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithItem;
import de.independit.scheduler.server.repository.SDMSEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSNamedEnvironment;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import java.util.Vector;

public class CreateEnvironment
extends Node {
    public static final String __version = "@(#) $Id: CreateEnvironment.java,v 2.5.14.1 2013/03/14 10:24:25 ronald Exp $";
    private String name;
    private Vector resourceList;
    private boolean replace;

    public CreateEnvironment(String string, Vector vector, Boolean bl) {
        this.name = string;
        this.resourceList = vector;
        this.replace = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSNamedEnvironment sDMSNamedEnvironment;
        try {
            sDMSNamedEnvironment = SDMSNamedEnvironmentTable.table.create(systemEnvironment, this.name);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            if (this.replace) {
                AlterEnvironment alterEnvironment = new AlterEnvironment(new ObjectURL(new Integer(350), this.name), this.resourceList, Boolean.FALSE);
                alterEnvironment.setEnv(this.env);
                alterEnvironment.go(systemEnvironment);
                this.result = alterEnvironment.result;
                return;
            }
            throw duplicateKeyException;
        }
        if (this.resourceList == null) {
            this.resourceList = new Vector();
        }
        Long l = sDMSNamedEnvironment.getId(systemEnvironment);
        for (int i = 0; i < this.resourceList.size(); ++i) {
            WithItem withItem = (WithItem)this.resourceList.get(i);
            SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getNamedResource(systemEnvironment, (Vector)((Object)withItem.key));
            String string = (String)withItem.value;
            if (string != null && string.trim().equals("")) {
                string = null;
            }
            if (sDMSNamedResource.getUsage(systemEnvironment) != 1) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03201222223", "Resource $1 must be STATIC", (Object)sDMSNamedResource.getName(systemEnvironment)));
            }
            SDMSEnvironmentTable.table.create(systemEnvironment, l, sDMSNamedResource.getId(systemEnvironment), string);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201222251", "Environment created"));
    }
}

