/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.AlterExitStateTranslation;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.StatusTranslation;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfile;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationTable;
import java.util.Vector;

public class CreateExitStateTranslation
extends Node {
    public static final String __version = "@(#) $Id: CreateExitStateTranslation.java,v 2.4.2.2 2013/03/15 14:36:20 ronald Exp $";
    private String name;
    private Vector trans;
    private boolean replace;

    public CreateExitStateTranslation(String string, Vector vector, Boolean bl) {
        this.name = string;
        this.trans = vector;
        this.replace = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSExitStateTranslationProfile sDMSExitStateTranslationProfile;
        systemEnvironment.checkFeatureAvailability("EXIT_STATE_TRANSLATION");
        try {
            sDMSExitStateTranslationProfile = SDMSExitStateTranslationProfileTable.table.create(systemEnvironment, this.name);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            if (this.replace) {
                AlterExitStateTranslation alterExitStateTranslation = new AlterExitStateTranslation(new ObjectURL(new Integer(364), this.name), this.trans, Boolean.FALSE);
                alterExitStateTranslation.setEnv(this.env);
                alterExitStateTranslation.go(systemEnvironment);
                this.result = alterExitStateTranslation.result;
                return;
            }
            throw duplicateKeyException;
        }
        Long l = sDMSExitStateTranslationProfile.getId(systemEnvironment);
        for (StatusTranslation statusTranslation : this.trans) {
            Long l2 = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, statusTranslation.sfrom).getId(systemEnvironment);
            Long l3 = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, statusTranslation.sto).getId(systemEnvironment);
            try {
                SDMSExitStateTranslationTable.table.create(systemEnvironment, l, l2, l3);
            }
            catch (DuplicateKeyException duplicateKeyException) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03110101313", "Exit State $1 is translated twice", (Object)statusTranslation.sfrom));
            }
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03204112202", "Exit State Translation created"));
    }
}

