/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.AlterScheduledEvent;
import de.independit.scheduler.server.parser.IntervalUtil;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.io.Serializable;
import java.util.HashMap;

public class CreateScheduledEvent
extends Node {
    public static final String __version = "@(#) $Id: CreateScheduledEvent.java,v 2.8.4.1 2013/03/14 10:24:27 ronald Exp $";
    private final ObjectURL obj;
    private final Boolean active;
    private final WithHash with;
    private final boolean replace;

    public CreateScheduledEvent(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.obj = objectURL;
        this.with = withHash;
        this.active = !this.with.containsKey("ACTIVE") ? Boolean.TRUE : (Boolean)this.with.get("ACTIVE");
        this.replace = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSScheduledEvent sDMSScheduledEvent;
        Serializable serializable;
        Object object;
        Long l;
        try {
            this.obj.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        Long l2 = this.env.uid();
        SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, l2);
        if (!this.with.containsKey("GROUP")) {
            l = sDMSUser.getDefaultGId(systemEnvironment);
        } else {
            object = (String)this.with.get("GROUP");
            l = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)object, new Long(0L))).getId(systemEnvironment);
            if (!SDMSMemberTable.idx_gId_uId.containsKey(systemEnvironment, new SDMSKey(l, l2)) && !SDMSMemberTable.idx_gId_uId.containsKey(systemEnvironment, new SDMSKey(SDMSObject.adminGId, l2))) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03312162143", "User $1 does not belong to Group $2", (Object)sDMSUser.getName(systemEnvironment), object));
            }
        }
        object = this.with.containsKey("BACKLOG_HANDLING") ? (Integer)this.with.get("BACKLOG_HANDLING") : new Integer(1);
        Integer n = null;
        Integer n2 = null;
        if (this.with.containsKey("SUSPEND_LIMIT") && (serializable = (WithHash)this.with.get("SUSPEND_LIMIT")) != null) {
            n = (Integer)((HashMap)serializable).get("INTERVAL");
            n2 = IntervalUtil.getMultiplier(systemEnvironment, (WithHash)serializable);
        }
        serializable = this.with.containsKey("CALENDAR") ? (Boolean)this.with.get("CALENDAR") : Boolean.FALSE;
        Integer n3 = (Integer)this.with.get("HORIZON");
        try {
            sDMSScheduledEvent = SDMSScheduledEventTable.table.create(systemEnvironment, l, this.obj.sceId, this.obj.evtId, this.active, Boolean.FALSE, null, null, null, null, null, (Integer)object, n, n2, (Boolean)serializable, n3);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            if (this.replace) {
                AlterScheduledEvent alterScheduledEvent = new AlterScheduledEvent(this.obj, this.with, Boolean.FALSE);
                alterScheduledEvent.setEnv(this.env);
                alterScheduledEvent.go(systemEnvironment);
                this.result = alterScheduledEvent.result;
                return;
            }
            throw duplicateKeyException;
        }
        SystemEnvironment.timer.notifyChange(systemEnvironment, sDMSScheduledEvent, 1);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04207261913", "Scheduled Event created"));
    }
}

