/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSObjectMonitor;
import de.independit.scheduler.server.repository.SDMSObjectMonitorTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSWatchType;
import de.independit.scheduler.server.repository.SDMSWatchTypeTable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class ListObjectMonitor
extends Node {
    public static final String __version = "@(#) $Id: ListObjectMonitor.java,v 2.2.4.4 2013/06/18 09:49:33 ronald Exp $";

    public ListObjectMonitor() {
        this.txMode = 1;
        this.auditFlag = false;
        this.cmdtype |= 4;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        systemEnvironment.checkFeatureAvailability("OBJECT_MONITOR");
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("NAME");
        vector.add("OWNER");
        vector.add("WATCH_TYPE");
        vector.add("RECREATE");
        vector.add("WATCHER");
        vector.add("PRIVS");
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "List of Object Types", vector);
        Iterator iterator = SDMSObjectMonitorTable.table.iterator(systemEnvironment);
        while (iterator.hasNext()) {
            SDMSProxy sDMSProxy;
            SDMSObjectMonitor sDMSObjectMonitor = (SDMSObjectMonitor)iterator.next();
            if (!sDMSObjectMonitor.checkPrivileges(systemEnvironment, 0x10000000L)) continue;
            Vector<Object> vector2 = new Vector<Object>();
            vector2.add(sDMSObjectMonitor.getId(systemEnvironment));
            vector2.add(sDMSObjectMonitor.getName(systemEnvironment));
            SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSObjectMonitor.getOwnerId(systemEnvironment));
            vector2.add(sDMSGroup.getName(systemEnvironment));
            SDMSWatchType sDMSWatchType = SDMSWatchTypeTable.getObject(systemEnvironment, sDMSObjectMonitor.getWtId(systemEnvironment));
            vector2.add(sDMSWatchType.getName(systemEnvironment));
            vector2.add(sDMSObjectMonitor.getRecreateHandlingAsString(systemEnvironment));
            Long l = sDMSObjectMonitor.getWatchSeId(systemEnvironment);
            if (l != null) {
                sDMSProxy = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSObjectMonitor.getWatchSeId(systemEnvironment));
                vector2.add(((SDMSSchedulingEntity)sDMSProxy).pathVector(systemEnvironment));
            } else {
                vector2.add(null);
            }
            vector2.add(sDMSObjectMonitor.getPrivileges(systemEnvironment).toString());
            if (systemEnvironment.cEnv.isJob() && !((SDMSSubmittedEntityProxyGeneric)(sDMSProxy = SDMSSubmittedEntityTable.getObject(systemEnvironment, systemEnvironment.cEnv.uid()))).getSeId(systemEnvironment).equals(l)) continue;
            sDMSOutputContainer.addData(systemEnvironment, vector2);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "02108241006", "$1 Object Type(s) found", (Object)new Integer(sDMSOutputContainer.lines)));
    }
}

