/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ScheduleUtil;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Vector;

public class ListSchedule
extends Node {
    public static final String __version = "@(#) $Id: ListSchedule.java,v 2.6.2.2 2013/06/18 09:49:33 ronald Exp $";
    private final Vector path;
    private final HashSet expandIds;

    public ListSchedule(Vector vector) {
        this.path = vector;
        this.expandIds = null;
        this.txMode = 1;
        this.auditFlag = false;
    }

    public ListSchedule(Vector vector, HashSet hashSet) {
        this.path = vector;
        this.expandIds = hashSet;
        this.txMode = 1;
        this.auditFlag = false;
    }

    private final void expand_subs(SystemEnvironment systemEnvironment, Long l, SDMSOutputContainer sDMSOutputContainer) throws SDMSException {
        Vector vector = SDMSScheduleTable.idx_parentId.getVector(systemEnvironment, l);
        for (SDMSSchedule sDMSSchedule : vector) {
            Long l2 = sDMSSchedule.getId(systemEnvironment);
            Vector<Object> vector2 = new Vector<Object>();
            vector2.add(l2);
            vector2.add(sDMSSchedule.pathVector(systemEnvironment));
            Long l3 = sDMSSchedule.getOwnerId(systemEnvironment);
            SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l3);
            vector2.add(sDMSGroup.getName(systemEnvironment));
            vector2.add(ScheduleUtil.getIvalName(systemEnvironment, sDMSSchedule));
            vector2.add(sDMSSchedule.getTimeZone(systemEnvironment));
            vector2.add(sDMSSchedule.getIsActive(systemEnvironment));
            vector2.add(new Boolean(sDMSSchedule.isReallyActive(systemEnvironment)));
            vector2.add(sDMSSchedule.getPrivileges(systemEnvironment).toString());
            sDMSOutputContainer.addData(systemEnvironment, vector2);
            if (this.expandIds != null && !this.expandIds.contains(l2) || !sDMSSchedule.checkPrivileges(systemEnvironment, 0x10000000L)) continue;
            this.expand_subs(systemEnvironment, l2, sDMSOutputContainer);
        }
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Serializable serializable;
        SDMSSchedule sDMSSchedule;
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("NAME");
        vector.add("OWNER");
        vector.add("INTERVAL");
        vector.add("TIME_ZONE");
        vector.add("ACTIVE");
        vector.add("EFF_ACTIVE");
        vector.add("PRIVS");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "List of Schedules", vector);
        if (this.path != null) {
            sDMSSchedule = SDMSScheduleTable.getSchedule(systemEnvironment, this.path);
        } else {
            serializable = new SDMSKey(null, (Comparable)((Object)"ROOT"));
            sDMSSchedule = SDMSScheduleTable.idx_parentId_name_getUnique(systemEnvironment, serializable);
        }
        if (!sDMSSchedule.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03402131453", "Insufficient privileges"));
        }
        serializable = sDMSSchedule.getId(systemEnvironment);
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(serializable);
        vector2.add(sDMSSchedule.pathVector(systemEnvironment));
        Long l = sDMSSchedule.getOwnerId(systemEnvironment);
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l);
        vector2.add(sDMSGroup.getName(systemEnvironment));
        vector2.add(ScheduleUtil.getIvalName(systemEnvironment, sDMSSchedule));
        vector2.add(sDMSSchedule.getTimeZone(systemEnvironment));
        vector2.add(sDMSSchedule.getIsActive(systemEnvironment));
        vector2.add(new Boolean(sDMSSchedule.isReallyActive(systemEnvironment)));
        vector2.add(sDMSSchedule.getPrivileges(systemEnvironment).toString());
        sDMSOutputContainer.addData(systemEnvironment, vector2);
        if (this.expandIds == null || this.expandIds.size() > 0) {
            this.expand_subs(systemEnvironment, (Long)serializable, sDMSOutputContainer);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04207252340", "$1 Schedule(s) found", (Object)new Integer(sDMSOutputContainer.lines)));
    }
}

