/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Formatter;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.ScopeConfig;
import de.independit.scheduler.server.parser.ScopeLister;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import java.util.HashSet;
import java.util.Vector;

public class ListScope
extends Node
implements Formatter {
    public static final String __version = "@(#) $Id: ListScope.java,v 2.10.2.2 2013/06/18 09:49:34 ronald Exp $";
    ObjectURL url;
    HashSet expandIds;

    public ListScope(ObjectURL objectURL) {
        this.url = objectURL;
        this.expandIds = new HashSet();
        this.txMode = 1;
        this.auditFlag = false;
    }

    public ListScope(ObjectURL objectURL, HashSet hashSet) {
        this.url = objectURL;
        this.expandIds = hashSet;
        this.txMode = 1;
        this.auditFlag = false;
    }

    @Override
    public Vector fillHeadInfo() {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("NAME");
        vector.add("OWNER");
        vector.add("TYPE");
        vector.add("IS_TERMINATE");
        vector.add("HAS_ALTERED_CONFIG");
        vector.add("IS_SUSPENDED");
        vector.add("IS_ENABLED");
        vector.add("IS_REGISTERED");
        vector.add("IS_CONNECTED");
        vector.add("STATE");
        vector.add("PID");
        vector.add("NODE");
        vector.add("IDLE");
        vector.add("NOPDELAY");
        vector.add("ERRMSG");
        vector.add("SUBSCOPES");
        vector.add("RESOURCES");
        vector.add("PRIVS");
        vector.add("IDPATH");
        return vector;
    }

    @Override
    public Vector fillVector(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, HashSet hashSet) throws SDMSException {
        Vector vector = new Vector();
        this.fillVector(systemEnvironment, (SDMSScope)sDMSProxy, vector);
        return vector;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        ScopeLister scopeLister = new ScopeLister(this.url, this.expandIds);
        scopeLister.setTitle(new SDMSMessage(systemEnvironment, "03207191656", "List of Scopes"));
        scopeLister.setFormatter(this);
        SDMSOutputContainer sDMSOutputContainer = scopeLister.list(systemEnvironment);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201281436", "$1 Object(s) found", (Object)new Integer(sDMSOutputContainer.lines)));
    }

    private void fillVector(SystemEnvironment systemEnvironment, SDMSScope sDMSScope, Vector vector) throws SDMSException {
        vector.add(sDMSScope.getId(systemEnvironment));
        vector.add(sDMSScope.pathVector(systemEnvironment));
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSScope.getOwnerId(systemEnvironment));
        vector.add(sDMSGroup.getName(systemEnvironment));
        vector.add(sDMSScope.getTypeAsString(systemEnvironment));
        vector.add(sDMSScope.getIsTerminate(systemEnvironment));
        vector.add(sDMSScope.getHasAlteredConfig(systemEnvironment));
        vector.add(sDMSScope.getIsSuspended(systemEnvironment));
        vector.add(sDMSScope.getIsEnabled(systemEnvironment));
        vector.add(sDMSScope.getIsRegistered(systemEnvironment));
        vector.add(new Boolean(sDMSScope.isConnected(systemEnvironment)));
        vector.add(sDMSScope.getStateAsString(systemEnvironment));
        vector.add(sDMSScope.getPid(systemEnvironment));
        vector.add(sDMSScope.getNode(systemEnvironment));
        vector.add(new Long(sDMSScope.getIdle(systemEnvironment)));
        vector.add(ScopeConfig.getItem(systemEnvironment, sDMSScope, "NOPDELAY"));
        vector.add(sDMSScope.getErrmsg(systemEnvironment));
        Vector vector2 = SDMSScopeTable.idx_parentId.getVector(systemEnvironment, sDMSScope.getId(systemEnvironment));
        Vector vector3 = SDMSResourceTable.idx_scopeId.getVector(systemEnvironment, sDMSScope.getId(systemEnvironment));
        vector.add(new Integer(vector2.size()));
        vector.add(new Integer(vector3.size()));
        vector.add(sDMSScope.getPrivileges(systemEnvironment).toString());
        vector.add(sDMSScope.idPathVector(systemEnvironment));
    }
}

