/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.WithItem;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSGroupProxyGeneric;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObjectCommentProxyGeneric;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSObjectMonitor;
import de.independit.scheduler.server.repository.SDMSObjectMonitorTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerParameter;
import de.independit.scheduler.server.repository.SDMSTriggerParameterTable;
import de.independit.scheduler.server.repository.SDMSTriggerState;
import de.independit.scheduler.server.repository.SDMSTriggerStateProxyGeneric;
import de.independit.scheduler.server.repository.SDMSTriggerStateTable;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class ListTrigger
extends Node {
    public static final String __version = "@(#) $Id: ListTrigger.java,v 2.22.4.3 2013/06/18 09:49:34 ronald Exp $";
    private String name;
    private Vector path;
    private WithItem fireObj;
    private boolean reverse;

    public ListTrigger(Vector vector, boolean bl) {
        this.fireObj = null;
        if (vector != null) {
            this.name = (String)vector.remove(vector.size() - 1);
            this.path = vector;
        } else {
            this.name = null;
            this.path = null;
        }
        this.txMode = 1;
        this.reverse = bl;
        this.auditFlag = false;
    }

    public ListTrigger(WithItem withItem) {
        this.name = null;
        this.path = null;
        this.fireObj = withItem;
        this.txMode = 1;
    }

    private Long getFireId(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = null;
        if (this.fireObj.key.equals("JOB")) {
            Vector vector = (Vector)this.fireObj.value;
            String string = (String)vector.remove(vector.size() - 1);
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.get(systemEnvironment, vector, string);
            if (!sDMSSchedulingEntity.checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03407230019", "Insufficient privileges"));
            }
            l = sDMSSchedulingEntity.getId(systemEnvironment);
        } else if (this.fireObj.key.equals("RESOURCE")) {
            Long l2;
            Vector vector = (Vector)this.fireObj.value;
            Vector vector2 = (Vector)vector.remove(vector.size() - 1);
            try {
                l2 = SDMSScopeTable.pathToId(systemEnvironment, vector);
            }
            catch (NotFoundException notFoundException) {
                l2 = SDMSFolderTable.pathToId(systemEnvironment, vector);
            }
            SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getNamedResource(systemEnvironment, vector2);
            Long l3 = sDMSNamedResource.getId(systemEnvironment);
            SDMSResource sDMSResource = SDMSResourceTable.idx_nrId_scopeId_getUnique(systemEnvironment, new SDMSKey(l3, l2));
            if (!sDMSResource.checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03407230021", "Insufficient privileges"));
            }
            l = sDMSResource.getId(systemEnvironment);
        } else if (this.fireObj.key.equals("NAMED_RESOURCE")) {
            Vector vector = (Vector)this.fireObj.value;
            SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getNamedResource(systemEnvironment, vector);
            if (!sDMSNamedResource.checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03407230018", "Insufficient privileges"));
            }
            l = sDMSNamedResource.getId(systemEnvironment);
        } else {
            String string = (String)this.fireObj.value;
            SDMSObjectMonitor sDMSObjectMonitor = SDMSObjectMonitorTable.idx_name_getUnique(systemEnvironment, string);
            if (!sDMSObjectMonitor.checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03109061704", "Insufficient privileges"));
            }
            l = sDMSObjectMonitor.getId(systemEnvironment);
        }
        return l;
    }

    private String quote(String string) {
        String string2 = string.replace("\\", "\\\\");
        string2 = string2.replace("'", "\\'");
        return string2;
    }

    private String renderParameters(SystemEnvironment systemEnvironment, SDMSTrigger sDMSTrigger) throws SDMSException {
        StringBuffer stringBuffer = new StringBuffer();
        Long l = sDMSTrigger.getId(systemEnvironment);
        String string = "";
        Vector vector = SDMSTriggerParameterTable.idx_triggerId.getSortedVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSTriggerParameter sDMSTriggerParameter = (SDMSTriggerParameter)vector.get(i);
            String string2 = sDMSTriggerParameter.getName(systemEnvironment);
            String string3 = sDMSTriggerParameter.getExpression(systemEnvironment);
            stringBuffer.append(string);
            stringBuffer.append("'");
            stringBuffer.append(string2);
            stringBuffer.append("'='");
            stringBuffer.append(this.quote(string3));
            stringBuffer.append("'");
            string = ",";
        }
        return stringBuffer.toString();
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Iterator iterator;
        Vector vector;
        Comparable comparable;
        SDMSOutputContainer sDMSOutputContainer = null;
        if (this.name != null) {
            comparable = SDMSSchedulingEntityTable.get(systemEnvironment, this.path, this.name);
            if (!((SDMSSchedulingEntityProxyGeneric)comparable).checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03402131651", "Insufficient privileges"));
            }
            if (this.reverse) {
                vector = SDMSTriggerTable.idx_seId.getVector(systemEnvironment, ((SDMSProxy)comparable).getId(systemEnvironment));
                iterator = vector.iterator();
            } else {
                vector = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, ((SDMSProxy)comparable).getId(systemEnvironment));
                iterator = vector.iterator();
            }
        } else if (this.fireObj != null) {
            comparable = this.getFireId(systemEnvironment);
            vector = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, comparable);
            iterator = vector.iterator();
        } else {
            iterator = SDMSTriggerTable.table.iterator(systemEnvironment);
        }
        Vector<String> vector2 = new Vector<String>();
        vector2.add("ID");
        vector2.add("NAME");
        vector2.add("OBJECT_TYPE");
        vector2.add("OBJECT_SUBTYPE");
        vector2.add("OBJECT_NAME");
        vector2.add("ACTIVE");
        vector2.add("ACTION");
        vector2.add("STATES");
        vector2.add("SUBMIT_TYPE");
        vector2.add("SUBMIT_NAME");
        vector2.add("SUBMIT_SE_OWNER");
        vector2.add("SUBMIT_PRIVS");
        vector2.add("MAIN_TYPE");
        vector2.add("MAIN_NAME");
        vector2.add("MAIN_SE_OWNER");
        vector2.add("MAIN_PRIVS");
        vector2.add("PARENT_TYPE");
        vector2.add("PARENT_NAME");
        vector2.add("PARENT_SE_OWNER");
        vector2.add("PARENT_PRIVS");
        vector2.add("TRIGGER_TYPE");
        vector2.add("MASTER");
        vector2.add("IS_INVERSE");
        vector2.add("SUBMIT_OWNER");
        vector2.add("IS_CREATE");
        vector2.add("IS_CHANGE");
        vector2.add("IS_DELETE");
        vector2.add("IS_GROUP");
        vector2.add("MAX_RETRY");
        vector2.add("SUSPEND");
        vector2.add("RESUME_AT");
        vector2.add("RESUME_IN");
        vector2.add("RESUME_BASE");
        vector2.add("WARN");
        vector2.add("LIMIT_STATE");
        vector2.add("CONDITION");
        vector2.add("CHECK_AMOUNT");
        vector2.add("CHECK_BASE");
        vector2.add("PARAMETERS");
        vector2.add("PRIVS");
        vector2.add("TAG");
        vector2.add("COMMENT");
        vector2.add("COMMENTTYPE");
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03206200023", "List of Triggers"), vector2);
        block20: while (iterator.hasNext()) {
            SDMSProxy sDMSProxy;
            Long l;
            Long l2;
            Comparable<Long> comparable2;
            Object object;
            SDMSProxy sDMSProxy2;
            SDMSTrigger sDMSTrigger = (SDMSTrigger)iterator.next();
            comparable = null;
            SDMSNamedResource sDMSNamedResource = null;
            SDMSResource sDMSResource = null;
            SDMSObjectMonitor sDMSObjectMonitor = null;
            SDMSResource sDMSResource2 = null;
            SDMSNamedResource sDMSNamedResource2 = null;
            Long l3 = sDMSTrigger.getFireId(systemEnvironment);
            int n = sDMSTrigger.getObjectType(systemEnvironment);
            switch (n) {
                case 0: {
                    comparable = SDMSSchedulingEntityTable.getObject(systemEnvironment, l3);
                    if (((SDMSSchedulingEntityProxyGeneric)comparable).checkPrivileges(systemEnvironment, 0x10000000L)) break;
                    continue block20;
                }
                case 2: {
                    sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l3);
                    if (sDMSNamedResource.checkPrivileges(systemEnvironment, 0x10000000L)) break;
                    continue block20;
                }
                case 1: {
                    sDMSResource = SDMSResourceTable.getObject(systemEnvironment, l3);
                    if (sDMSResource.checkPrivileges(systemEnvironment, 0x10000000L)) break;
                    continue block20;
                }
                case 3: {
                    sDMSObjectMonitor = SDMSObjectMonitorTable.getObject(systemEnvironment, l3);
                    if (sDMSObjectMonitor.checkPrivileges(systemEnvironment, 0x10000000L)) break;
                    continue block20;
                }
            }
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(sDMSTrigger.getId(systemEnvironment));
            vector3.add(sDMSTrigger.getName(systemEnvironment));
            vector3.add(sDMSTrigger.getObjectTypeAsString(systemEnvironment));
            switch (n) {
                case 0: {
                    vector3.add(((SDMSSchedulingEntityProxyGeneric)comparable).getTypeAsString(systemEnvironment));
                    break;
                }
                case 2: {
                    vector3.add(sDMSNamedResource.getUsageAsString(systemEnvironment));
                    break;
                }
                case 1: {
                    sDMSResource2 = SDMSResourceTable.getObject(systemEnvironment, l3);
                    sDMSNamedResource2 = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSResource2.getNrId(systemEnvironment));
                    vector3.add(sDMSNamedResource2.getUsageAsString(systemEnvironment));
                    break;
                }
                case 3: {
                    vector3.add("OBJECT MONITOR");
                }
            }
            switch (n) {
                case 0: {
                    vector3.add(((SDMSSchedulingEntity)comparable).pathVector(systemEnvironment));
                    break;
                }
                case 2: {
                    vector3.add(sDMSNamedResource.pathVector(systemEnvironment));
                    break;
                }
                case 1: {
                    vector3.add(sDMSResource.getURLName(systemEnvironment));
                    break;
                }
                case 3: {
                    vector3.add(sDMSObjectMonitor.getName(systemEnvironment));
                }
            }
            vector3.add(sDMSTrigger.getIsActive(systemEnvironment));
            vector3.add(sDMSTrigger.getActionAsString(systemEnvironment));
            Vector vector4 = SDMSTriggerStateTable.idx_triggerId.getVector(systemEnvironment, sDMSTrigger.getId(systemEnvironment));
            Iterator iterator2 = vector4.iterator();
            String string = "";
            StringBuffer stringBuffer = new StringBuffer();
            while (iterator2.hasNext()) {
                sDMSProxy2 = (SDMSTriggerState)iterator2.next();
                object = "";
                if (n == 1 || n == 2) {
                    comparable2 = ((SDMSTriggerStateProxyGeneric)sDMSProxy2).getFromStateId(systemEnvironment);
                    if (comparable2 != null) {
                        object = (String)object + SDMSResourceStateDefinitionTable.getObject(systemEnvironment, (Long)comparable2).getName(systemEnvironment);
                    }
                    object = (String)object + ":";
                    l2 = ((SDMSTriggerStateProxyGeneric)sDMSProxy2).getToStateId(systemEnvironment);
                    if (l2 != null) {
                        object = (String)object + SDMSResourceStateDefinitionTable.getObject(systemEnvironment, l2).getName(systemEnvironment);
                    }
                } else {
                    comparable2 = ((SDMSTriggerStateProxyGeneric)sDMSProxy2).getToStateId(systemEnvironment);
                    if (comparable2 != null) {
                        object = (String)object + SDMSExitStateDefinitionTable.getObject(systemEnvironment, (Long)comparable2).getName(systemEnvironment);
                    }
                }
                stringBuffer.append(string);
                stringBuffer.append((String)object);
                string = ",";
            }
            vector3.add(new String(stringBuffer));
            sDMSProxy2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSTrigger.getSeId(systemEnvironment));
            vector3.add(((SDMSSchedulingEntityProxyGeneric)sDMSProxy2).getTypeAsString(systemEnvironment));
            vector3.add(((SDMSSchedulingEntity)sDMSProxy2).pathVector(systemEnvironment));
            object = ((SDMSSchedulingEntityProxyGeneric)sDMSProxy2).getOwnerId(systemEnvironment);
            comparable2 = SDMSGroupTable.getObject(systemEnvironment, (Long)object);
            vector3.add(((SDMSGroupProxyGeneric)comparable2).getName(systemEnvironment));
            vector3.add(((SDMSSchedulingEntityProxyGeneric)sDMSProxy2).getPrivileges(systemEnvironment).toString());
            l2 = sDMSTrigger.getMainSeId(systemEnvironment);
            if (l2 == null) {
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
            } else {
                sDMSProxy2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, l2);
                vector3.add(((SDMSSchedulingEntityProxyGeneric)sDMSProxy2).getTypeAsString(systemEnvironment));
                vector3.add(((SDMSSchedulingEntity)sDMSProxy2).pathVector(systemEnvironment));
                object = ((SDMSSchedulingEntityProxyGeneric)sDMSProxy2).getOwnerId(systemEnvironment);
                comparable2 = SDMSGroupTable.getObject(systemEnvironment, (Long)object);
                vector3.add(((SDMSGroupProxyGeneric)comparable2).getName(systemEnvironment));
                vector3.add(((SDMSSchedulingEntityProxyGeneric)sDMSProxy2).getPrivileges(systemEnvironment).toString());
            }
            Long l4 = sDMSTrigger.getParentSeId(systemEnvironment);
            if (l4 == null) {
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
            } else {
                sDMSProxy2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, l4);
                vector3.add(((SDMSSchedulingEntityProxyGeneric)sDMSProxy2).getTypeAsString(systemEnvironment));
                vector3.add(((SDMSSchedulingEntity)sDMSProxy2).pathVector(systemEnvironment));
                object = ((SDMSSchedulingEntityProxyGeneric)sDMSProxy2).getOwnerId(systemEnvironment);
                comparable2 = SDMSGroupTable.getObject(systemEnvironment, (Long)object);
                vector3.add(((SDMSGroupProxyGeneric)comparable2).getName(systemEnvironment));
                vector3.add(((SDMSSchedulingEntityProxyGeneric)sDMSProxy2).getPrivileges(systemEnvironment).toString());
            }
            vector3.add(sDMSTrigger.getTypeAsString(systemEnvironment));
            vector3.add(sDMSTrigger.getIsMaster(systemEnvironment));
            vector3.add(sDMSTrigger.getIsInverse(systemEnvironment));
            if (sDMSTrigger.getIsMaster(systemEnvironment).booleanValue()) {
                l = sDMSTrigger.getSubmitOwnerId(systemEnvironment);
                comparable2 = SDMSGroupTable.getObject(systemEnvironment, l);
                vector3.add(((SDMSGroupProxyGeneric)comparable2).getName(systemEnvironment));
            } else {
                vector3.add(null);
            }
            vector3.add(sDMSTrigger.getIsCreate(systemEnvironment));
            vector3.add(sDMSTrigger.getIsChange(systemEnvironment));
            vector3.add(sDMSTrigger.getIsDelete(systemEnvironment));
            vector3.add(sDMSTrigger.getIsGroup(systemEnvironment));
            vector3.add(sDMSTrigger.getMaxRetry(systemEnvironment));
            vector3.add(sDMSTrigger.getIsSuspend(systemEnvironment));
            vector3.add(sDMSTrigger.getResumeAt(systemEnvironment));
            vector3.add(sDMSTrigger.getResumeIn(systemEnvironment));
            vector3.add(sDMSTrigger.getResumeBaseAsString(systemEnvironment));
            vector3.add(sDMSTrigger.getIsWarnOnLimit(systemEnvironment));
            l = sDMSTrigger.getLimitState(systemEnvironment);
            if (l == null) {
                vector3.add(null);
            } else {
                sDMSProxy = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l);
                vector3.add(((SDMSExitStateDefinitionProxyGeneric)sDMSProxy).getName(systemEnvironment));
            }
            vector3.add(sDMSTrigger.getCondition(systemEnvironment));
            vector3.add(sDMSTrigger.getCheckAmount(systemEnvironment));
            vector3.add(sDMSTrigger.getCheckBaseAsString(systemEnvironment));
            vector3.add(this.renderParameters(systemEnvironment, sDMSTrigger));
            vector3.add(sDMSTrigger.getPrivileges(systemEnvironment).toString());
            try {
                sDMSProxy = SDMSObjectCommentTable.idx_objectId_getFirst(systemEnvironment, sDMSTrigger.getId(systemEnvironment));
                vector3.add(((SDMSObjectCommentProxyGeneric)sDMSProxy).getTag(systemEnvironment));
                vector3.add(((SDMSObjectCommentProxyGeneric)sDMSProxy).getDescription(systemEnvironment));
                vector3.add(((SDMSObjectCommentProxyGeneric)sDMSProxy).getInfoTypeAsString(systemEnvironment));
            }
            catch (NotFoundException notFoundException) {
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
            }
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 2, 1));
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03206191305", "$1 Trigger(s) found", (Object)new Integer(sDMSOutputContainer.lines)));
    }
}

